CREATE TABLE `#__ak_profiles` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,   `configuration` longtext COLLATE utf8mb4_unicode_ci,   `filters` longtext COLLATE utf8mb4_unicode_ci,   `quickicon` tinyint(3) NOT NULL DEFAULT '1',   PRIMARY KEY (`id`) ) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `#__ak_profiles`  VALUES ('1', 'Default Backup Profile', '###AES128###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', '', '1');
CREATE TABLE `#__ak_stats` (   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,   `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,   `comment` longtext COLLATE utf8mb4_unicode_ci,   `backupstart` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `backupend` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',   `status` enum('run','fail','complete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'run',   `origin` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'backend',   `type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'full',   `profile_id` bigint(20) NOT NULL DEFAULT '1',   `archivename` longtext COLLATE utf8mb4_unicode_ci,   `absolute_path` longtext COLLATE utf8mb4_unicode_ci,   `multipart` int(11) NOT NULL DEFAULT '0',   `tag` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,   `backupid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,   `filesexist` tinyint(3) NOT NULL DEFAULT '1',   `remote_filename` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,   `total_size` bigint(20) NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `idx_fullstatus` (`filesexist`,`status`),   KEY `idx_stale` (`status`,`origin`) ) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `#__ak_stats`  VALUES ('3', 'Backup taken on Tuesday, 18 April 2017 00:07', '', '2017-04-18 00:07:13', '2017-04-18 00:10:06', 'complete', 'backend', 'full', '1', 'site-localhost-20170418-000713.jpa', 'E:/wamp/www/1new/autocare/administrator/components/com_akeeba/backup/site-localhost-20170418-000713.jpa', '1', 'backend', 'id3', '1', NULL, '57712426'), ('4', 'Backup taken on Tuesday, 18 April 2017 00:24', '', '2017-04-18 00:24:32', '2017-04-18 00:26:12', 'complete', 'backend', 'full', '1', 'site-localhost-20170418-002432.zip', 'E:/wamp/www/1new/autocare/administrator/components/com_akeeba/backup/site-localhost-20170418-002432.zip', '1', 'backend', 'id4', '1', NULL, '58682679'), ('5', 'Backup taken on Tuesday, 18 April 2017 00:28', '', '2017-04-18 00:28:44', '2017-04-18 00:30:27', 'complete', 'backend', 'full', '1', 'site-localhost-20170418-002844.jpa', 'E:/wamp/www/1new/autocare/administrator/components/com_akeeba/backup/site-localhost-20170418-002844.jpa', '1', 'backend', 'id5', '1', NULL, '57712449'), ('6', 'Backup taken on Monday, 10 July 2017 12:21', '', '2017-07-10 12:21:10', '0000-00-00 00:00:00', 'complete', 'backend', 'full', '1', 'site-localhost-20170710-122110.zip', 'E:/wamp/www/1new/autocare/administrator/components/com_akeeba/backup/site-localhost-20170710-122110.zip', '0', 'backend', 'id6', '1', NULL, '0'), ('7', 'Backup taken on Tuesday, 29 August 2017 08:17', '', '2017-08-29 08:17:09', '0000-00-00 00:00:00', 'complete', 'backend', 'full', '1', 'site-localhost-20170829-081709.jpa', '/Users/viki/Sites/autocare/administrator/components/com_akeeba/backup/site-localhost-20170829-081709.jpa', '0', 'backend', 'id7', '1', NULL, '0'), ('8', 'Backup taken on Saturday, 23 September 2017 05:51', '', '2017-09-23 05:51:06', '0000-00-00 00:00:00', 'complete', 'backend', 'full', '1', 'site-demo.joomlabuff.com-20170923-055106.jpa', '/home/vjbuff/public_html/demo/autocare/administrator/components/com_akeeba/backup/site-demo.joomlabuff.com-20170923-055106.jpa', '0', 'backend', 'id8', '1', NULL, '0'), ('9', 'Backup taken on Saturday, 23 September 2017 06:30', '', '2017-09-23 06:31:05', '0000-00-00 00:00:00', 'complete', 'backend', 'full', '1', 'site-localhost-20170923-063105.zip', '/Users/viki/Sites/autocare/administrator/components/com_akeeba/backup/site-localhost-20170923-063105.zip', '0', 'backend', 'id9', '1', NULL, '0');
CREATE TABLE `#__ak_storage` (   `tag` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,   `lastupdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,   `data` longtext COLLATE utf8mb4_unicode_ci,   PRIMARY KEY (`tag`(100)) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE `#__akeeba_common` (   `key` varchar(192) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,   `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,   PRIMARY KEY (`key`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `#__akeeba_common`  VALUES ('fof30', '[\"com_akeeba\"]'), ('stats_lastrun', '1506145466'), ('stats_siteid', '3c0fcd5f7743773e6bd110c8cbd21aa990aa24a9'), ('stats_siteurl', 'ac669eaff1ae95b85ac56d36f0867377');
CREATE TABLE `#__assets` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',   `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',   `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',   `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',   `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',   `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',   `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',   `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',   PRIMARY KEY (`id`),   UNIQUE KEY `idx_asset_name` (`name`),   KEY `idx_lft_rgt` (`lft`,`rgt`),   KEY `idx_parent_id` (`parent_id`) ) ENGINE=InnoDB AUTO_INCREMENT=148 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `#__assets`  VALUES ('1', '0', '0', '289', '0', 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'), ('2', '1', '1', '2', '1', 'com_admin', 'com_admin', '{}'), ('3', '1', '3', '6', '1', 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('4', '1', '7', '8', '1', 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'), ('5', '1', '9', '10', '1', 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'), ('6', '1', '11', '12', '1', 'com_config', 'com_config', '{}'), ('7', '1', '13', '16', '1', 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('8', '1', '17', '56', '1', 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('9', '1', '57', '58', '1', 'com_cpanel', 'com_cpanel', '{}'), ('10', '1', '59', '60', '1', 'com_installer', 'com_installer', '{\"core.admin\":[],\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'), ('11', '1', '61', '62', '1', 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('12', '1', '63', '64', '1', 'com_login', 'com_login', '{}'), ('13', '1', '65', '66', '1', 'com_mailto', 'com_mailto', '{}'), ('14', '1', '67', '68', '1', 'com_massmail', 'com_massmail', '{}'), ('15', '1', '69', '70', '1', 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'), ('16', '1', '71', '76', '1', 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('17', '1', '77', '78', '1', 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'), ('18', '1', '79', '232', '1', 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('19', '1', '233', '236', '1', 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('20', '1', '237', '238', '1', 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('21', '1', '239', '240', '1', 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1},\"core.manage\":[]}'), ('22', '1', '241', '242', '1', 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'), ('23', '1', '243', '244', '1', 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('24', '1', '245', '248', '1', 'com_users', 'com_users', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('26', '1', '249', '250', '1', 'com_wrapper', 'com_wrapper', '{}'), ('27', '8', '18', '19', '2', 'com_content.category.2', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('28', '3', '4', '5', '2', 'com_banners.category.3', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('29', '7', '14', '15', '2', 'com_contact.category.4', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('30', '19', '234', '235', '2', 'com_newsfeeds.category.5', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'), ('32', '24', '246', '247', '1', 'com_users.category.7', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('33', '1', '251', '252', '1', 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'), ('34', '1', '253', '254', '1', 'com_joomlaupdate', 'com_joomlaupdate', '{\"core.admin\":[],\"core.manage\":[],\"core.delete\":[],\"core.edit.state\":[]}'), ('35', '1', '255', '256', '1', 'com_tags', 'com_tags', '{\"core.admin\":[],\"core.manage\":[],\"core.manage\":[],\"core.delete\":[],\"core.edit.state\":[]}'), ('36', '1', '257', '258', '1', 'com_contenthistory', 'com_contenthistory', '{}'), ('37', '1', '259', '260', '1', 'com_ajax', 'com_ajax', '{}'), ('38', '1', '261', '262', '1', 'com_postinstall', 'com_postinstall', '{}'), ('39', '18', '80', '81', '2', 'com_modules.module.1', 'Main Menu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('40', '18', '82', '83', '2', 'com_modules.module.2', 'Login', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('41', '18', '84', '85', '2', 'com_modules.module.3', 'Popular Articles', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('42', '18', '86', '87', '2', 'com_modules.module.4', 'Recently Added Articles', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('43', '18', '88', '89', '2', 'com_modules.module.8', 'Toolbar', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('44', '18', '90', '91', '2', 'com_modules.module.9', 'Quick Icons', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('45', '18', '92', '93', '2', 'com_modules.module.10', 'Logged-in Users', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('46', '18', '94', '95', '2', 'com_modules.module.12', 'Admin Menu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('47', '18', '96', '97', '2', 'com_modules.module.13', 'Admin Submenu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('48', '18', '98', '99', '2', 'com_modules.module.14', 'User Status', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('49', '18', '100', '101', '2', 'com_modules.module.15', 'Title', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('50', '18', '102', '103', '2', 'com_modules.module.16', 'Login Form', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('51', '18', '104', '105', '2', 'com_modules.module.17', 'Breadcrumbs', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('52', '18', '106', '107', '2', 'com_modules.module.79', 'Multilanguage status', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('53', '18', '108', '109', '2', 'com_modules.module.86', 'Joomla Version', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'), ('54', '16', '72', '73', '2', 'com_menus.menu.1', 'Main Menu', '{}'), ('55', '18', '110', '111', '2', 'com_modules.module.87', 'Layer Slider', '{}'), ('56', '1', '263', '264', '1', 'com_layer_slider', 'com_layer_slider', '{}'), ('57', '1', '265', '266', '1', 'com_offlajn_installer', 'offlajn_installer', '{}'), ('58', '18', '112', '113', '2', 'com_modules.module.88', 'Languages', '{}'), ('59', '18', '114', '115', '2', 'com_modules.module.89', 'Owl home', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('60', '1', '267', '270', '1', 'com_sppagebuilder', 'SP Page Builder', '{}'), ('61', '18', '116', '117', '2', 'com_modules.module.90', 'SP Page Builder', '{}'), ('62', '18', '118', '119', '2', 'com_modules.module.91', 'SP Page Builder', '{}'), ('63', '18', '120', '121', '2', 'com_modules.module.92', 'SP Page Builder Admin Menu', '{}'), ('64', '18', '122', '123', '2', 'com_modules.module.93', 'mod_submenu', '{}'), ('65', '18', '124', '125', '2', 'com_modules.module.94', 'Home slide', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('66', '1', '271', '272', '1', 'com_akeeba', 'Akeeba', '{}'), ('67', '1', '273', '274', '1', 'com_j2store', 'J2Store', '{}'), ('68', '18', '126', '127', '2', 'com_modules.module.95', 'J2 Store Chart', '{}'), ('69', '18', '128', '129', '2', 'com_modules.module.96', 'J2 Store Stats Mini', '{}'), ('70', '18', '130', '131', '2', 'com_modules.module.97', 'J2 Store Orders', '{}'), ('71', '18', '132', '133', '2', 'com_modules.module.98', 'J2 Store Stats', '{}'), ('72', '18', '134', '135', '2', 'com_modules.module.99', 'J2Store Administrator Menu', '{}'), ('73', '18', '136', '137', '2', 'com_modules.module.100', 'J2Store Currency', '{}'), ('74', '18', '138', '139', '2', 'com_modules.module.101', 'Top Cart', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('75', '18', '140', '141', '2', 'com_modules.module.102', 'Footer social', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('76', '18', '142', '143', '2', 'com_modules.module.103', 'SP Tab', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('77', '18', '144', '145', '2', 'com_modules.module.104', 'Wheel Works', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('78', '18', '146', '147', '2', 'com_modules.module.105', 'Bottom1', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('79', '16', '74', '75', '2', 'com_menus.menu.2', 'Our Services', '{}'), ('80', '18', '148', '149', '2', 'com_modules.module.106', 'Our Services', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('81', '18', '150', '151', '2', 'com_modules.module.107', 'Our Services', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('82', '18', '152', '153', '2', 'com_modules.module.108', 'Shop Spare Parts', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('83', '18', '154', '155', '2', 'com_modules.module.109', 'Brand', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('84', '1', '275', '276', '1', 'com_jbeasyformmaker', 'com_jbeasyformmaker', '{}'), ('85', '18', '156', '157', '2', 'com_modules.module.110', 'Form1', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('86', '1', '277', '278', '1', 'com_k2', 'COM_K2', '{}'), ('87', '18', '158', '159', '2', 'com_modules.module.111', 'K2 Comments', '{}'), ('88', '18', '160', '161', '2', 'com_modules.module.112', 'Our Latest News', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('89', '18', '162', '163', '2', 'com_modules.module.113', 'Important Tags', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('90', '18', '164', '165', '2', 'com_modules.module.114', 'K2 Users', '{}'), ('91', '18', '166', '167', '2', 'com_modules.module.115', 'K2 User', '{}'), ('92', '18', '168', '169', '2', 'com_modules.module.116', 'K2 Quick Icons (admin)', '{}'), ('93', '18', '170', '171', '2', 'com_modules.module.117', 'K2 Stats (admin)', '{}'), ('94', '18', '172', '173', '2', 'com_modules.module.118', 'Working Hours:  ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('95', '18', '174', '175', '2', 'com_modules.module.119', 'testimonials about', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('96', '18', '176', '177', '2', 'com_modules.module.120', 'Testimonials', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('97', '18', '178', '179', '2', 'com_modules.module.121', 'FAQ\'s', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('98', '18', '180', '181', '2', 'com_modules.module.122', 'Services', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('99', '18', '182', '183', '2', 'com_modules.module.123', 'Air Conditioner', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('100', '18', '184', '185', '2', 'com_modules.module.124', 'Other Services', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('101', '18', '186', '187', '2', 'com_modules.module.125', 'Testimonials', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('102', '18', '188', '189', '2', 'com_modules.module.126', 'Belts & Hoses', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('103', '18', '190', '191', '2', 'com_modules.module.127', 'brake Repairs', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('104', '18', '192', '193', '2', 'com_modules.module.128', 'Engine Works', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('105', '18', '194', '195', '2', 'com_modules.module.129', 'Lube Oil & Filters', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('106', '18', '196', '197', '2', 'com_modules.module.130', 'Painting Works', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('107', '18', '198', '199', '2', 'com_modules.module.131', 'Water Service', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('108', '18', '200', '201', '2', 'com_modules.module.132', 'Wheel Works carousel', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('109', '1', '279', '282', '1', 'com_spsimpleportfolio', 'SP Simple Portfolio', '{}'), ('110', '18', '202', '203', '2', 'com_modules.module.133', 'SP Simple Portfolio Module', '{}'), ('111', '109', '280', '281', '2', 'com_spsimpleportfolio.category.8', 'V1', '{}'), ('112', '18', '204', '205', '2', 'com_modules.module.134', 'Contact page form', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('113', '8', '20', '55', '2', 'com_content.category.9', 'Shop', '{}'), ('114', '113', '21', '46', '3', 'com_content.category.10', 'Autobody Parts', '{}'), ('115', '113', '47', '48', '3', 'com_content.category.11', 'Engine Spares', '{}'), ('116', '113', '49', '50', '3', 'com_content.category.12', 'Air Filter & Cleaner', '{}'), ('117', '113', '51', '52', '3', 'com_content.category.13', 'Wires & Plugs', '{}'), ('118', '113', '53', '54', '3', 'com_content.category.14', 'Tools & Motors', '{}'), ('119', '114', '22', '23', '4', 'com_content.article.1', 'Engine Guard', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('120', '114', '24', '25', '4', 'com_content.article.2', 'Air Filter', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('121', '114', '26', '27', '4', 'com_content.article.3', 'Spark Plug', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('122', '114', '28', '29', '4', 'com_content.article.4', 'Evaporator Coil', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('123', '114', '30', '31', '4', 'com_content.article.5', 'Shock Absorber', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('124', '114', '32', '33', '4', 'com_content.article.6', 'Brake Disc', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('125', '114', '34', '35', '4', 'com_content.article.7', 'Air Cleaner', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('126', '114', '36', '37', '4', 'com_content.article.8', 'Lead Wires', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('127', '114', '38', '39', '4', 'com_content.article.9', 'Wiper Motor', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('128', '114', '40', '41', '4', 'com_content.article.10', 'Gearbox', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('129', '114', '42', '43', '4', 'com_content.article.11', 'Seat Belt', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('130', '114', '44', '45', '4', 'com_content.article.12', 'Radiator', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'), ('131', '18', '206', '207', '2', 'com_modules.module.135', 'Top Rated products', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('132', '18', '208', '209', '2', 'com_modules.module.136', 'Product Categories', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('133', '18', '210', '211', '2', 'com_modules.module.137', 'Search Products', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('134', '18', '212', '213', '2', 'com_modules.module.138', 'Shop Spare Parts', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('135', '18', '214', '215', '2', 'com_modules.module.139', 'Blog Categories', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('136', '18', '216', '217', '2', 'com_modules.module.140', 'Search', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('137', '18', '218', '219', '2', 'com_modules.module.141', 'Latest Posts', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('138', '18', '220', '221', '2', 'com_modules.module.142', 'Blog Archives', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('139', '18', '222', '223', '2', 'com_modules.module.143', 'Popular Tags', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'), ('140', '18', '224', '225', '2', 'com_modules.module.144', 'Breadcrumbs', '{}'), ('141', '1', '283', '284', '1', 'com_fields', 'com_fields', '{}'), ('142', '1', '285', '286', '1', 'com_associations', 'com_associations', '{}'), ('143', '60', '268', '269', '2', 'com_sppagebuilder.page.19', 'Home rtl', '{}'), ('144', '1', '287', '288', '1', '#__languages.2', '#__languages.2', '{}'), ('145', '18', '226', '227', '2', 'com_modules.module.145', 'lang', '{}'), ('146', '18', '228', '229', '2', 'com_modules.module.146', 'Owl home rtl', '{}'), ('147', '18', '230', '231', '2', 'com_modules.module.147', 'Menu responsive', '{}');
CREATE TABLE `#__associations` (   `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',   `context` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',   `key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',   PRIMARY KEY (`context`,`id`),   KEY `idx_key` (`key`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE `#__banner_clients` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `contact` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `extrainfo` text COLLATE utf8mb4_unicode_ci NOT NULL,   `state` tinyint(3) NOT NULL DEFAULT '0',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `metakey` text COLLATE utf8mb4_unicode_ci NOT NULL,   `own_prefix` tinyint(4) NOT NULL DEFAULT '0',   `metakey_prefix` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',   `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',   `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',   PRIMARY KEY (`id`),   KEY `idx_own_prefix` (`own_prefix`),   KEY `idx_metakey_prefix` (`metakey_prefix`(100)) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE `#__banner_tracks` (   `track_date` datetime NOT NULL,   `track_type` int(10) unsigned NOT NULL,   `banner_id` int(10) unsigned NOT NULL,   `count` int(10) unsigned NOT NULL DEFAULT '0',   PRIMARY KEY (`track_date`,`track_type`,`banner_id`),   KEY `idx_track_date` (`track_date`),   KEY `idx_track_type` (`track_type`),   KEY `idx_banner_id` (`banner_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE `#__banners` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `cid` int(11) NOT NULL DEFAULT '0',   `type` int(11) NOT NULL DEFAULT '0',   `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',   `imptotal` int(11) NOT NULL DEFAULT '0',   `impmade` int(11) NOT NULL DEFAULT '0',   `clicks` int(11) NOT NULL DEFAULT '0',   `clickurl` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `state` tinyint(3) NOT NULL DEFAULT '0',   `catid` int(10) unsigned NOT NULL DEFAULT '0',   `description` text COLLATE utf8mb4_unicode_ci NOT NULL,   `custombannercode` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,   `sticky` tinyint(1) unsigned NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   `metakey` text COLLATE utf8mb4_unicode_ci NOT NULL,   `params` text COLLATE utf8mb4_unicode_ci NOT NULL,   `own_prefix` tinyint(1) NOT NULL DEFAULT '0',   `metakey_prefix` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',   `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',   `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `created_by` int(10) unsigned NOT NULL DEFAULT '0',   `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(10) unsigned NOT NULL DEFAULT '0',   `version` int(10) unsigned NOT NULL DEFAULT '1',   PRIMARY KEY (`id`),   KEY `idx_state` (`state`),   KEY `idx_own_prefix` (`own_prefix`),   KEY `idx_metakey_prefix` (`metakey_prefix`(100)),   KEY `idx_banner_catid` (`catid`),   KEY `idx_language` (`language`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE `#__categories` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',   `parent_id` int(10) unsigned NOT NULL DEFAULT '0',   `lft` int(11) NOT NULL DEFAULT '0',   `rgt` int(11) NOT NULL DEFAULT '0',   `level` int(10) unsigned NOT NULL DEFAULT '0',   `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',   `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,   `published` tinyint(1) NOT NULL DEFAULT '0',   `checked_out` int(11) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `access` int(10) unsigned NOT NULL DEFAULT '0',   `params` text COLLATE utf8mb4_unicode_ci NOT NULL,   `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',   `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',   `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',   `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',   `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',   `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `hits` int(10) unsigned NOT NULL DEFAULT '0',   `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `version` int(10) unsigned NOT NULL DEFAULT '1',   PRIMARY KEY (`id`),   KEY `cat_idx` (`extension`,`published`,`access`),   KEY `idx_access` (`access`),   KEY `idx_checkout` (`checked_out`),   KEY `idx_path` (`path`(100)),   KEY `idx_left_right` (`lft`,`rgt`),   KEY `idx_alias` (`alias`(100)),   KEY `idx_language` (`language`) ) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `#__categories`  VALUES ('1', '0', '0', '0', '25', '0', '', 'system', 'ROOT', 'root', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{}', '', '', '{}', '364', '2011-01-01 00:00:01', '0', '0000-00-00 00:00:00', '0', '*', '1'), ('2', '27', '1', '1', '2', '1', 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '364', '2011-01-01 00:00:01', '0', '0000-00-00 00:00:00', '0', '*', '1'), ('3', '28', '1', '3', '4', '1', 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '364', '2011-01-01 00:00:01', '0', '0000-00-00 00:00:00', '0', '*', '1'), ('4', '29', '1', '5', '6', '1', 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '364', '2011-01-01 00:00:01', '0', '0000-00-00 00:00:00', '0', '*', '1'), ('5', '30', '1', '7', '8', '1', 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '364', '2011-01-01 00:00:01', '0', '0000-00-00 00:00:00', '0', '*', '1'), ('7', '32', '1', '9', '10', '1', 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '364', '2011-01-01 00:00:01', '0', '0000-00-00 00:00:00', '0', '*', '1'), ('8', '111', '1', '11', '12', '1', 'v1', 'com_spsimpleportfolio', 'V1', 'v1', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '364', '2017-04-11 11:32:08', '0', '2017-04-11 11:32:08', '0', '*', '1'), ('9', '113', '1', '13', '24', '1', 'shop', 'com_content', 'Shop', 'shop', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '364', '2017-04-11 22:15:10', '0', '2017-04-11 22:15:10', '0', '*', '1'), ('10', '114', '9', '14', '15', '2', 'shop/autobody-parts', 'com_content', 'Autobody Parts', 'autobody-parts', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '364', '2017-04-11 22:15:17', '0', '2017-04-11 22:15:17', '0', '*', '1'), ('11', '115', '9', '16', '17', '2', 'shop/engine-spares', 'com_content', 'Engine Spares', 'engine-spares', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '364', '2017-04-11 22:15:26', '0', '2017-04-11 22:15:26', '0', '*', '1'), ('12', '116', '9', '18', '19', '2', 'shop/air-filter-cleaner', 'com_content', 'Air Filter & Cleaner', 'air-filter-cleaner', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '364', '2017-04-11 22:15:34', '0', '2017-04-11 22:15:34', '0', '*', '1'), ('13', '117', '9', '20', '21', '2', 'shop/wires-plugs', 'com_content', 'Wires & Plugs', 'wires-plugs', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '364', '2017-04-11 22:15:42', '0', '2017-04-11 22:15:42', '0', '*', '1'), ('14', '118', '9', '22', '23', '2', 'shop/tools-motors', 'com_content', 'Tools & Motors', 'tools-motors', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '364', '2017-04-11 22:15:50', '0', '2017-04-11 22:15:50', '0', '*', '1');
CREATE TABLE `#__contact_details` (   `id` int(11) NOT NULL AUTO_INCREMENT,   `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,   `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,   `con_position` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,   `address` text COLLATE utf8mb4_unicode_ci,   `suburb` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,   `state` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,   `country` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,   `postcode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,   `telephone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,   `fax` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,   `misc` mediumtext COLLATE utf8mb4_unicode_ci,   `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,   `email_to` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,   `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',   `published` tinyint(1) NOT NULL DEFAULT '0',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) NOT NULL DEFAULT '0',   `params` text COLLATE utf8mb4_unicode_ci NOT NULL,   `user_id` int(11) NOT NULL DEFAULT '0',   `catid` int(11) NOT NULL DEFAULT '0',   `access` int(10) unsigned NOT NULL DEFAULT '0',   `mobile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `webpage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `sortname1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `sortname2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `sortname3` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created_by` int(10) unsigned NOT NULL DEFAULT '0',   `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(10) unsigned NOT NULL DEFAULT '0',   `metakey` text COLLATE utf8mb4_unicode_ci NOT NULL,   `metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,   `metadata` text COLLATE utf8mb4_unicode_ci NOT NULL,   `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if contact is featured.',   `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `version` int(10) unsigned NOT NULL DEFAULT '1',   `hits` int(10) unsigned NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `idx_access` (`access`),   KEY `idx_checkout` (`checked_out`),   KEY `idx_state` (`published`),   KEY `idx_catid` (`catid`),   KEY `idx_createdby` (`created_by`),   KEY `idx_featured_catid` (`featured`,`catid`),   KEY `idx_language` (`language`),   KEY `idx_xreference` (`xreference`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE `#__content` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',   `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',   `introtext` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,   `fulltext` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,   `state` tinyint(3) NOT NULL DEFAULT '0',   `catid` int(10) unsigned NOT NULL DEFAULT '0',   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created_by` int(10) unsigned NOT NULL DEFAULT '0',   `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `images` text COLLATE utf8mb4_unicode_ci NOT NULL,   `urls` text COLLATE utf8mb4_unicode_ci NOT NULL,   `attribs` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL,   `version` int(10) unsigned NOT NULL DEFAULT '1',   `ordering` int(11) NOT NULL DEFAULT '0',   `metakey` text COLLATE utf8mb4_unicode_ci NOT NULL,   `metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,   `access` int(10) unsigned NOT NULL DEFAULT '0',   `hits` int(10) unsigned NOT NULL DEFAULT '0',   `metadata` text COLLATE utf8mb4_unicode_ci NOT NULL,   `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',   `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',   `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   PRIMARY KEY (`id`),   KEY `idx_access` (`access`),   KEY `idx_checkout` (`checked_out`),   KEY `idx_state` (`state`),   KEY `idx_catid` (`catid`),   KEY `idx_createdby` (`created_by`),   KEY `idx_featured_catid` (`featured`,`catid`),   KEY `idx_language` (`language`),   KEY `idx_xreference` (`xreference`) ) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `#__content`  VALUES ('1', '119', 'Engine Guard', 'engine-guard', '<p>There are many variations of passages,the majority have suffered seds alterationin some form, by injected humourrandomised words which don\'t look evenslightly believable when get finance.</p>\r\n', '\r\n<p>A lot of auto repair customerss questions the importance of wheel alignment. Is it really necessary? Yes, it is. Masters builder of human happiness. No one rejects, dislikes, or utavoids pleasures itself, because it is pleasures, but because those who do not know how to pursue pleasure lot of auto repair customerss questions the importance.</p>', '1', '10', '2017-04-11 22:18:14', '364', '', '2017-04-11 22:53:27', '364', '0', '0000-00-00 00:00:00', '2017-04-11 22:18:14', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', '5', '11', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('2', '120', 'Air Filter', 'air-filter', '<p>There are many variations of passages,the majority have suffered seds alterationin some form, by injected humourrandomised words which don\'t look evenslightly believable when get finance.</p>\r\n', '\r\n<p>A lot of auto repair customerss questions the importance of wheel alignment. Is it really necessary? Yes, it is. Masters builder of human happiness. No one rejects, dislikes, or utavoids pleasures itself, because it is pleasures, but because those who do not know how to pursue pleasure lot of auto repair customerss questions the importance.</p>', '1', '10', '2017-04-11 22:18:14', '364', '', '2017-04-11 22:53:08', '364', '0', '0000-00-00 00:00:00', '2017-04-11 22:18:14', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', '3', '10', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('3', '121', 'Spark Plug', 'spark-plug', '<p>There are many variations of passages,the majority have suffered seds alterationin some form, by injected humourrandomised words which don\'t look evenslightly believable when get finance.</p>\r\n', '\r\n<p>A lot of auto repair customerss questions the importance of wheel alignment. Is it really necessary? Yes, it is. Masters builder of human happiness. No one rejects, dislikes, or utavoids pleasures itself, because it is pleasures, but because those who do not know how to pursue pleasure lot of auto repair customerss questions the importance.</p>', '1', '10', '2017-04-11 22:18:14', '364', '', '2017-04-11 22:52:54', '364', '0', '0000-00-00 00:00:00', '2017-04-11 22:18:14', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', '3', '9', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('4', '122', 'Evaporator Coil', 'evaporator-coil', '<p>There are many variations of passages,the majority have suffered seds alterationin some form, by injected humourrandomised words which don\'t look evenslightly believable when get finance.</p>\r\n', '\r\n<p>A lot of auto repair customerss questions the importance of wheel alignment. Is it really necessary? Yes, it is. Masters builder of human happiness. No one rejects, dislikes, or utavoids pleasures itself, because it is pleasures, but because those who do not know how to pursue pleasure lot of auto repair customerss questions the importance.</p>', '1', '10', '2017-04-11 22:18:14', '364', '', '2017-04-11 22:52:37', '364', '0', '0000-00-00 00:00:00', '2017-04-11 22:18:14', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', '3', '8', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('5', '123', 'Shock Absorber', 'shock-absorber', '<p>There are many variations of passages,the majority have suffered seds alterationin some form, by injected humourrandomised words which don\'t look evenslightly believable when get finance.</p>\r\n', '\r\n<p>A lot of auto repair customerss questions the importance of wheel alignment. Is it really necessary? Yes, it is. Masters builder of human happiness. No one rejects, dislikes, or utavoids pleasures itself, because it is pleasures, but because those who do not know how to pursue pleasure lot of auto repair customerss questions the importance.</p>', '1', '10', '2017-04-11 22:18:14', '364', '', '2017-04-11 22:52:09', '364', '0', '0000-00-00 00:00:00', '2017-04-11 22:18:14', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', '3', '7', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('6', '124', 'Brake Disc', 'brake-disc', '<p>There are many variations of passages,the majority have suffered seds alterationin some form, by injected humourrandomised words which don\'t look evenslightly believable when get finance.</p>\r\n', '\r\n<p>A lot of auto repair customerss questions the importance of wheel alignment. Is it really necessary? Yes, it is. Masters builder of human happiness. No one rejects, dislikes, or utavoids pleasures itself, because it is pleasures, but because those who do not know how to pursue pleasure lot of auto repair customerss questions the importance.</p>', '1', '10', '2017-04-11 22:18:14', '364', '', '2017-04-11 22:51:15', '364', '0', '0000-00-00 00:00:00', '2017-04-11 22:18:14', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', '3', '6', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('7', '125', 'Air Cleaner', 'air-cleaner', '<p>There are many variations of passages,the majority have suffered seds alterationin some form, by injected humourrandomised words which don\'t look evenslightly believable when get finance.</p>\r\n', '\r\n<p>A lot of auto repair customerss questions the importance of wheel alignment. Is it really necessary? Yes, it is. Masters builder of human happiness. No one rejects, dislikes, or utavoids pleasures itself, because it is pleasures, but because those who do not know how to pursue pleasure lot of auto repair customerss questions the importance.</p>', '1', '10', '2017-04-11 22:18:14', '364', '', '2017-04-11 22:50:17', '364', '0', '0000-00-00 00:00:00', '2017-04-11 22:18:14', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', '3', '5', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('8', '126', 'Lead Wires', 'lead-wires', '<p>There are many variations of passages,the majority have suffered seds alterationin some form, by injected humourrandomised words which don\'t look evenslightly believable when get finance.</p>\r\n', '\r\n<p>A lot of auto repair customerss questions the importance of wheel alignment. Is it really necessary? Yes, it is. Masters builder of human happiness. No one rejects, dislikes, or utavoids pleasures itself, because it is pleasures, but because those who do not know how to pursue pleasure lot of auto repair customerss questions the importance.</p>', '1', '10', '2017-04-11 22:18:14', '364', '', '2017-04-11 22:49:53', '364', '0', '0000-00-00 00:00:00', '2017-04-11 22:18:14', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', '3', '4', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('9', '127', 'Wiper Motor', 'wiper-motor', '<p>There are many variations of passages,the majority have suffered seds alterationin some form, by injected humourrandomised words which don\'t look evenslightly believable when get finance.</p>\r\n', '\r\n<p>A lot of auto repair customerss questions the importance of wheel alignment. Is it really necessary? Yes, it is. Masters builder of human happiness. No one rejects, dislikes, or utavoids pleasures itself, because it is pleasures, but because those who do not know how to pursue pleasure lot of auto repair customerss questions the importance.</p>', '1', '10', '2017-04-11 22:18:14', '364', '', '2017-04-11 22:49:37', '364', '0', '0000-00-00 00:00:00', '2017-04-11 22:18:14', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', '3', '3', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('10', '128', 'Gearbox', 'gearbox', '<p>There are many variations of passages,the majority have suffered seds alterationin some form, by injected humourrandomised words which don\'t look evenslightly believable when get finance.</p>\r\n', '\r\n<p>A lot of auto repair customerss questions the importance of wheel alignment. Is it really necessary? Yes, it is. Masters builder of human happiness. No one rejects, dislikes, or utavoids pleasures itself, because it is pleasures, but because those who do not know how to pursue pleasure lot of auto repair customerss questions the importance.</p>', '1', '10', '2017-04-11 22:18:14', '364', '', '2017-04-11 22:49:22', '364', '0', '0000-00-00 00:00:00', '2017-04-11 22:18:14', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', '3', '2', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('11', '129', 'Seat Belt', 'seat-belt', '<p>There are many variations of passages,the majority have suffered seds alterationin some form, by injected humourrandomised words which don\'t look evenslightly believable when get finance.</p>\r\n', '\r\n<p>A lot of auto repair customerss questions the importance of wheel alignment. Is it really necessary? Yes, it is. Masters builder of human happiness. No one rejects, dislikes, or utavoids pleasures itself, because it is pleasures, but because those who do not know how to pursue pleasure lot of auto repair customerss questions the importance.</p>', '1', '10', '2017-04-11 22:18:14', '364', '', '2017-04-11 22:48:41', '364', '0', '0000-00-00 00:00:00', '2017-04-11 22:18:14', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', '3', '1', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', ''), ('12', '130', 'Radiator', 'radiator', '<p>There are many variations of passages,the majority have suffered seds alterationin some form, by injected humourrandomised words which don\'t look evenslightly believable when get finance.</p>\r\n', '\r\n<p>A lot of auto repair customerss questions the importance of wheel alignment. Is it really necessary? Yes, it is. Masters builder of human happiness. No one rejects, dislikes, or utavoids pleasures itself, because it is pleasures, but because those who do not know how to pursue pleasure lot of auto repair customerss questions the importance.</p>', '1', '10', '2017-04-11 22:18:14', '364', '', '2017-04-11 22:48:24', '364', '0', '0000-00-00 00:00:00', '2017-04-11 22:18:14', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', '3', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '0', '*', '');
CREATE TABLE `#__content_frontpage` (   `content_id` int(11) NOT NULL DEFAULT '0',   `ordering` int(11) NOT NULL DEFAULT '0',   PRIMARY KEY (`content_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE `#__content_rating` (   `content_id` int(11) NOT NULL DEFAULT '0',   `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',   `rating_count` int(10) unsigned NOT NULL DEFAULT '0',   `lastip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   PRIMARY KEY (`content_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE `#__content_types` (   `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `table` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `rules` text COLLATE utf8mb4_unicode_ci NOT NULL,   `field_mappings` text COLLATE utf8mb4_unicode_ci NOT NULL,   `router` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `content_history_options` varchar(5120) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JSON string for com_contenthistory options',   PRIMARY KEY (`type_id`),   KEY `idx_alias` (`type_alias`(100)) ) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `#__content_types`  VALUES ('1', 'Article', 'com_content.article', '{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"Content\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"introtext\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"attribs\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"asset_id\"}, \"special\":{\"fulltext\":\"fulltext\"}}', 'ContentHelperRoute::getArticleRoute', '{\"formFile\":\"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'), ('2', 'Contact', 'com_contact.contact', '{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"Contact\",\"prefix\":\"ContactTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}', 'ContactHelperRoute::getContactRoute', '{\"formFile\":\"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml\",\"hideFields\":[\"default_con\",\"checked_out\",\"checked_out_time\",\"version\",\"xreference\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[ {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ] }'), ('3', 'Newsfeed', 'com_newsfeeds.newsfeed', '{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"Newsfeed\",\"prefix\":\"NewsfeedsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{\"formFile\":\"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml\",\"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'), ('4', 'User', 'com_users.user', '{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"User\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerdate\",\"core_modified_time\":\"lastvisitDate\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{}}', 'UsersHelperRoute::getUserRoute', ''), ('5', 'Article Category', 'com_content.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContentHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'), ('6', 'Contact Category', 'com_contact.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'), ('7', 'Newsfeeds Category', 'com_newsfeeds.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'), ('8', 'Tag', 'com_tags.tag', '{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"Tag\",\"prefix\":\"TagsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}', 'TagsHelperRoute::getTagRoute', '{\"formFile\":\"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'), ('9', 'Banner', 'com_banners.banner', '{\"special\":{\"dbtable\":\"#__banners\",\"key\":\"id\",\"type\":\"Banner\",\"prefix\":\"BannersTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"#__banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'), ('10', 'Banners Category', 'com_banners.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'), ('11', 'Banner Client', 'com_banners.client', '{\"special\":{\"dbtable\":\"#__banner_clients\",\"key\":\"id\",\"type\":\"Client\",\"prefix\":\"BannersTable\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}'), ('12', 'User Notes', 'com_users.note', '{\"special\":{\"dbtable\":\"#__user_notes\",\"key\":\"id\",\"type\":\"Note\",\"prefix\":\"UsersTable\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'), ('13', 'User Notes Category', 'com_users.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}');
CREATE TABLE `#__contentitem_tag_map` (   `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `core_content_id` int(10) unsigned NOT NULL COMMENT 'PK from the core content table',   `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',   `tag_id` int(10) unsigned NOT NULL COMMENT 'PK from the tag table',   `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',   `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table',   UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),   KEY `idx_tag_type` (`tag_id`,`type_id`),   KEY `idx_date_id` (`tag_date`,`tag_id`),   KEY `idx_core_content_id` (`core_content_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maps items from content tables to tags';
CREATE TABLE `#__core_log_searches` (   `search_term` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `hits` int(10) unsigned NOT NULL DEFAULT '0' ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE `#__extensions` (   `extension_id` int(11) NOT NULL AUTO_INCREMENT,   `package_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',   `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,   `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,   `element` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,   `folder` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,   `client_id` tinyint(3) NOT NULL,   `enabled` tinyint(3) NOT NULL DEFAULT '0',   `access` int(10) unsigned NOT NULL DEFAULT '1',   `protected` tinyint(3) NOT NULL DEFAULT '0',   `manifest_cache` text COLLATE utf8mb4_unicode_ci NOT NULL,   `params` text COLLATE utf8mb4_unicode_ci NOT NULL,   `custom_data` text COLLATE utf8mb4_unicode_ci NOT NULL,   `system_data` text COLLATE utf8mb4_unicode_ci NOT NULL,   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) DEFAULT '0',   `state` int(11) DEFAULT '0',   PRIMARY KEY (`extension_id`),   KEY `element_clientid` (`element`,`client_id`),   KEY `element_folder_clientid` (`element`,`folder`,`client_id`),   KEY `extension` (`type`,`element`,`folder`,`client_id`) ) ENGINE=InnoDB AUTO_INCREMENT=10078 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `#__extensions`  VALUES ('1', '0', 'com_mailto', 'component', 'com_mailto', '', '0', '1', '1', '1', '{\"name\":\"com_mailto\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MAILTO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mailto\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('2', '0', 'com_wrapper', 'component', 'com_wrapper', '', '0', '1', '1', '1', '{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"wrapper\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('3', '0', 'com_admin', 'component', 'com_admin', '', '1', '1', '1', '1', '{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('4', '0', 'com_banners', 'component', 'com_banners', '', '1', '1', '1', '0', '{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"banners\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\",\"save_history\":\"1\",\"history_limit\":10}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('5', '0', 'com_cache', 'component', 'com_cache', '', '1', '1', '1', '1', '{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('6', '0', 'com_categories', 'component', 'com_categories', '', '1', '1', '1', '1', '{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('7', '0', 'com_checkin', 'component', 'com_checkin', '', '1', '1', '1', '1', '{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('8', '0', 'com_contact', 'component', 'com_contact', '', '1', '1', '1', '0', '{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{\"show_contact_category\":\"hide\",\"save_history\":\"1\",\"history_limit\":10,\"show_contact_list\":\"0\",\"presentation_style\":\"sliders\",\"show_name\":\"1\",\"show_position\":\"1\",\"show_email\":\"0\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_misc\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"show_profile\":\"0\",\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"show_headings\":\"1\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"allow_vcard_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_email_form\":\"1\",\"show_email_copy\":\"1\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_category_crumb\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('9', '0', 'com_cpanel', 'component', 'com_cpanel', '', '1', '1', '1', '1', '{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10', '0', 'com_installer', 'component', 'com_installer', '', '1', '1', '1', '1', '{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('11', '0', 'com_languages', 'component', 'com_languages', '', '1', '1', '1', '1', '{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('12', '0', 'com_login', 'component', 'com_login', '', '1', '1', '1', '1', '{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('13', '0', 'com_media', 'component', 'com_media', '', '1', '1', '0', '1', '{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\",\"upload_mime_illegal\":\"text\\/html\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('14', '0', 'com_menus', 'component', 'com_menus', '', '1', '1', '1', '1', '{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('15', '0', 'com_messages', 'component', 'com_messages', '', '1', '1', '1', '1', '{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('16', '0', 'com_modules', 'component', 'com_modules', '', '1', '1', '1', '1', '{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('17', '0', 'com_newsfeeds', 'component', 'com_newsfeeds', '', '1', '1', '1', '0', '{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"newsfeed_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_character_count\":\"0\",\"feed_display_order\":\"des\",\"float_first\":\"right\",\"float_second\":\"right\",\"show_tags\":\"1\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('18', '0', 'com_plugins', 'component', 'com_plugins', '', '1', '1', '1', '1', '{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('19', '0', 'com_search', 'component', 'com_search', '', '1', '1', '1', '0', '{\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_SEARCH_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"search\"}', '{\"enabled\":\"0\",\"show_date\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('20', '0', 'com_templates', 'component', 'com_templates', '', '1', '1', '1', '1', '{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"template_positions_display\":\"0\",\"upload_limit\":\"10\",\"image_formats\":\"gif,bmp,jpg,jpeg,png\",\"source_formats\":\"txt,less,ini,xml,js,php,css\",\"font_formats\":\"woff,ttf,otf\",\"compressed_formats\":\"zip\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('22', '0', 'com_content', 'component', 'com_content', '', '1', '1', '0', '1', '{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"1\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"1\",\"show_item_navigation\":\"1\",\"show_vote\":\"0\",\"show_readmore\":\"1\",\"show_readmore_title\":\"1\",\"readmore_limit\":\"100\",\"show_icons\":\"1\",\"show_print_icon\":\"1\",\"show_email_icon\":\"1\",\"show_hits\":\"1\",\"show_noauth\":\"0\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"save_history\":\"1\",\"history_limit\":10,\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"left\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_subcat_desc\":\"1\",\"show_cat_num_articles\":\"0\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"0\",\"show_subcategory_content\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('23', '0', 'com_config', 'component', 'com_config', '', '1', '1', '0', '1', '{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"10\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"12\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('24', '0', 'com_redirect', 'component', 'com_redirect', '', '1', '1', '0', '1', '{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('25', '0', 'com_users', 'component', 'com_users', '', '1', '1', '0', '1', '{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"users\"}', '{\"allowUserRegistration\":\"0\",\"new_usertype\":\"2\",\"guest_usergroup\":\"9\",\"sendpassword\":\"1\",\"useractivation\":\"2\",\"mail_to_admin\":\"1\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"reset_count\":\"10\",\"reset_time\":\"1\",\"minimum_length\":\"4\",\"minimum_integers\":\"0\",\"minimum_symbols\":\"0\",\"minimum_uppercase\":\"0\",\"save_history\":\"1\",\"history_limit\":5,\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('27', '0', 'com_finder', 'component', 'com_finder', '', '1', '1', '0', '0', '{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '{\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_advanced\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stemmer\":\"snowball\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('28', '0', 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', '1', '1', '0', '1', '{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"February 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.2\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('29', '0', 'com_tags', 'component', 'com_tags', '', '1', '1', '1', '1', '{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"December 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{\"tag_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_tag_title\":\"0\",\"tag_list_show_tag_image\":\"0\",\"tag_list_show_tag_description\":\"0\",\"tag_list_image\":\"\",\"show_tag_num_items\":\"0\",\"tag_list_orderby\":\"title\",\"tag_list_orderby_direction\":\"ASC\",\"show_headings\":\"0\",\"tag_list_show_date\":\"0\",\"tag_list_show_item_image\":\"0\",\"tag_list_show_item_description\":\"0\",\"tag_list_item_maximum_characters\":0,\"return_any_or_all\":\"1\",\"include_children\":\"0\",\"maximum\":200,\"tag_list_language_filter\":\"all\",\"tags_layout\":\"_:default\",\"all_tags_orderby\":\"title\",\"all_tags_orderby_direction\":\"ASC\",\"all_tags_show_tag_image\":\"0\",\"all_tags_show_tag_descripion\":\"0\",\"all_tags_tag_maximum_characters\":20,\"all_tags_show_tag_hits\":\"0\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"tag_field_ajax_mode\":\"1\",\"show_feed_link\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('30', '0', 'com_contenthistory', 'component', 'com_contenthistory', '', '1', '1', '1', '0', '{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"May 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contenthistory\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('31', '0', 'com_ajax', 'component', 'com_ajax', '', '1', '1', '1', '1', '{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ajax\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('32', '0', 'com_postinstall', 'component', 'com_postinstall', '', '1', '1', '1', '1', '{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('33', '0', 'com_fields', 'component', 'com_fields', '', '1', '1', '1', '0', '{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('34', '0', 'com_associations', 'component', 'com_associations', '', '1', '1', '1', '0', '{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"Januar 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('102', '0', 'LIB_PHPUTF8', 'library', 'phputf8', '', '0', '1', '1', '1', '{\"name\":\"LIB_PHPUTF8\",\"type\":\"library\",\"creationDate\":\"2006\",\"author\":\"Harry Fuecks\",\"copyright\":\"Copyright various authors\",\"authorEmail\":\"hfuecks@gmail.com\",\"authorUrl\":\"http:\\/\\/sourceforge.net\\/projects\\/phputf8\",\"version\":\"0.5\",\"description\":\"LIB_PHPUTF8_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phputf8\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('103', '0', 'LIB_JOOMLA', 'library', 'joomla', '', '0', '1', '1', '1', '{\"name\":\"LIB_JOOMLA\",\"type\":\"library\",\"creationDate\":\"2008\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"mediaversion\":\"67c9df7436d00886d049d3da408ea53c\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('104', '0', 'LIB_IDNA', 'library', 'idna_convert', '', '0', '1', '1', '1', '{\"name\":\"LIB_IDNA\",\"type\":\"library\",\"creationDate\":\"2004\",\"author\":\"phlyLabs\",\"copyright\":\"2004-2011 phlyLabs Berlin, http:\\/\\/phlylabs.de\",\"authorEmail\":\"phlymail@phlylabs.de\",\"authorUrl\":\"http:\\/\\/phlylabs.de\",\"version\":\"0.8.0\",\"description\":\"LIB_IDNA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"idna_convert\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('105', '0', 'FOF', 'library', 'fof', '', '0', '1', '1', '1', '{\"name\":\"FOF\",\"type\":\"library\",\"creationDate\":\"2015-04-22 13:15:32\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2011-2015 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"2.4.3\",\"description\":\"LIB_FOF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fof\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('106', '0', 'LIB_PHPASS', 'library', 'phpass', '', '0', '1', '1', '1', '{\"name\":\"LIB_PHPASS\",\"type\":\"library\",\"creationDate\":\"2004-2006\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"http:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.3\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpass\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('200', '0', 'mod_articles_archive', 'module', 'mod_articles_archive', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_archive\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('201', '0', 'mod_articles_latest', 'module', 'mod_articles_latest', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_latest\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('202', '0', 'mod_articles_popular', 'module', 'mod_articles_popular', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_popular\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('203', '0', 'mod_banners', 'module', 'mod_banners', '', '0', '1', '1', '0', '{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_banners\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('204', '0', 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', '0', '1', '1', '1', '{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_breadcrumbs\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('205', '0', 'mod_custom', 'module', 'mod_custom', '', '0', '1', '1', '1', '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('206', '0', 'mod_feed', 'module', 'mod_feed', '', '0', '1', '1', '0', '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('207', '0', 'mod_footer', 'module', 'mod_footer', '', '0', '1', '1', '0', '{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_footer\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('208', '0', 'mod_login', 'module', 'mod_login', '', '0', '1', '1', '1', '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('209', '0', 'mod_menu', 'module', 'mod_menu', '', '0', '1', '1', '1', '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('210', '0', 'mod_articles_news', 'module', 'mod_articles_news', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_news\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('211', '0', 'mod_random_image', 'module', 'mod_random_image', '', '0', '1', '1', '0', '{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_random_image\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('212', '0', 'mod_related_items', 'module', 'mod_related_items', '', '0', '1', '1', '0', '{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_related_items\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('213', '0', 'mod_search', 'module', 'mod_search', '', '0', '1', '1', '0', '{\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SEARCH_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_search\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('214', '0', 'mod_stats', 'module', 'mod_stats', '', '0', '1', '1', '0', '{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('215', '0', 'mod_syndicate', 'module', 'mod_syndicate', '', '0', '1', '1', '1', '{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"May 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_syndicate\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('216', '0', 'mod_users_latest', 'module', 'mod_users_latest', '', '0', '1', '1', '0', '{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"December 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_users_latest\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('218', '0', 'mod_whosonline', 'module', 'mod_whosonline', '', '0', '1', '1', '0', '{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_whosonline\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('219', '0', 'mod_wrapper', 'module', 'mod_wrapper', '', '0', '1', '1', '0', '{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"October 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_wrapper\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('220', '0', 'mod_articles_category', 'module', 'mod_articles_category', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_category\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('221', '0', 'mod_articles_categories', 'module', 'mod_articles_categories', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_categories\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('222', '0', 'mod_languages', 'module', 'mod_languages', '', '0', '1', '1', '1', '{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_languages\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('223', '0', 'mod_finder', 'module', 'mod_finder', '', '0', '1', '0', '0', '{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_finder\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('300', '0', 'mod_custom', 'module', 'mod_custom', '', '1', '1', '1', '1', '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('301', '0', 'mod_feed', 'module', 'mod_feed', '', '1', '1', '1', '0', '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('302', '0', 'mod_latest', 'module', 'mod_latest', '', '1', '1', '1', '0', '{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latest\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('303', '0', 'mod_logged', 'module', 'mod_logged', '', '1', '1', '1', '0', '{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"January 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_logged\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('304', '0', 'mod_login', 'module', 'mod_login', '', '1', '1', '1', '1', '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"March 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('305', '0', 'mod_menu', 'module', 'mod_menu', '', '1', '1', '1', '0', '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('307', '0', 'mod_popular', 'module', 'mod_popular', '', '1', '1', '1', '0', '{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_popular\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('308', '0', 'mod_quickicon', 'module', 'mod_quickicon', '', '1', '1', '1', '1', '{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_quickicon\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('309', '0', 'mod_status', 'module', 'mod_status', '', '1', '1', '1', '0', '{\"name\":\"mod_status\",\"type\":\"module\",\"creationDate\":\"Feb 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_status\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('310', '0', 'mod_submenu', 'module', 'mod_submenu', '', '1', '1', '1', '0', '{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"Feb 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_submenu\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('311', '0', 'mod_title', 'module', 'mod_title', '', '1', '1', '1', '0', '{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_title\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('312', '0', 'mod_toolbar', 'module', 'mod_toolbar', '', '1', '1', '1', '1', '{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_toolbar\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('313', '0', 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', '1', '1', '1', '0', '{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"September 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_multilangstatus\"}', '{\"cache\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('314', '0', 'mod_version', 'module', 'mod_version', '', '1', '1', '1', '0', '{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"January 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_version\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('315', '0', 'mod_stats_admin', 'module', 'mod_stats_admin', '', '1', '1', '1', '0', '{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats_admin\"}', '{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('316', '0', 'mod_tags_popular', 'module', 'mod_tags_popular', '', '0', '1', '1', '0', '{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_popular\"}', '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('317', '0', 'mod_tags_similar', 'module', 'mod_tags_similar', '', '0', '1', '1', '0', '{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_similar\"}', '{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('318', '0', 'mod_sampledata', 'module', 'mod_sampledata', '', '1', '0', '1', '0', '{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sampledata\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('400', '0', 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', '0', '0', '1', '0', '{\"name\":\"plg_authentication_gmail\",\"type\":\"plugin\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_GMAIL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"gmail\"}', '{\"applysuffix\":\"0\",\"suffix\":\"\",\"verifypeer\":\"1\",\"user_blacklist\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('401', '0', 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', '0', '1', '1', '1', '{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTH_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('402', '0', 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', '0', '0', '1', '0', '{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ldap\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('403', '0', 'plg_content_contact', 'plugin', 'contact', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"January 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('404', '0', 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"emailcloak\"}', '{\"mode\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('406', '0', 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"loadmodule\"}', '{\"style\":\"xhtml\"}', '', '', '0', '2011-09-18 15:22:50', '0', '0'), ('407', '0', 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('408', '0', 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"January 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagenavigation\"}', '{\"position\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '5', '0'), ('409', '0', 'plg_content_vote', 'plugin', 'vote', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"vote\"}', '', '', '', '0', '0000-00-00 00:00:00', '6', '0'), ('410', '0', 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', '0', '1', '1', '1', '{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2017 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"http:\\/\\/codemirror.net\\/\",\"version\":\"5.28\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"codemirror\"}', '{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('411', '0', 'plg_editors_none', 'plugin', 'none', 'editors', '0', '1', '1', '1', '{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"September 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"none\"}', '', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('412', '0', 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', '0', '1', '1', '0', '{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-2017\",\"author\":\"Ephox Corporation\",\"copyright\":\"Ephox Corporation\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"http:\\/\\/www.tinymce.com\",\"version\":\"4.5.7\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tinymce\"}', '{\"mode\":\"1\",\"skin\":\"0\",\"mobile\":\"0\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"extended_elements\":\"\",\"html_height\":\"550\",\"html_width\":\"750\",\"resizing\":\"1\",\"element_path\":\"1\",\"fonts\":\"1\",\"paste\":\"1\",\"searchreplace\":\"1\",\"insertdate\":\"1\",\"colors\":\"1\",\"table\":\"1\",\"smilies\":\"1\",\"hr\":\"1\",\"link\":\"1\",\"media\":\"1\",\"print\":\"1\",\"directionality\":\"1\",\"fullscreen\":\"1\",\"alignment\":\"1\",\"visualchars\":\"1\",\"visualblocks\":\"1\",\"nonbreaking\":\"1\",\"template\":\"1\",\"blockquote\":\"1\",\"wordcount\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"inlinepopups\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('413', '0', 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"October 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"article\"}', '', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('414', '0', 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"image\"}', '', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('415', '0', 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('416', '0', 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"readmore\"}', '', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('417', '0', 'plg_search_categories', 'plugin', 'categories', 'search', '0', '1', '1', '0', '{\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('418', '0', 'plg_search_contacts', 'plugin', 'contacts', 'search', '0', '1', '1', '0', '{\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('419', '0', 'plg_search_content', 'plugin', 'content', 'search', '0', '1', '1', '0', '{\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('420', '0', 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', '0', '1', '1', '0', '{\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('422', '0', 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', '0', '1', '1', '1', '{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"July 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagefilter\"}', '', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('423', '0', 'plg_system_p3p', 'plugin', 'p3p', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_p3p\",\"type\":\"plugin\",\"creationDate\":\"September 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_P3P_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"p3p\"}', '{\"headers\":\"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM\"}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('424', '0', 'plg_system_cache', 'plugin', 'cache', 'system', '0', '0', '1', '1', '{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"February 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cache\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', '', '0', '0000-00-00 00:00:00', '9', '0'), ('425', '0', 'plg_system_debug', 'plugin', 'debug', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"debug\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('426', '0', 'plg_system_log', 'plugin', 'log', 'system', '0', '1', '1', '1', '{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"log\"}', '', '', '', '0', '0000-00-00 00:00:00', '5', '0'), ('427', '0', 'plg_system_redirect', 'plugin', 'redirect', 'system', '0', '0', '1', '1', '{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"redirect\"}', '', '', '', '0', '0000-00-00 00:00:00', '6', '0'), ('428', '0', 'plg_system_remember', 'plugin', 'remember', 'system', '0', '1', '1', '1', '{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"remember\"}', '', '', '', '0', '0000-00-00 00:00:00', '7', '0'), ('429', '0', 'plg_system_sef', 'plugin', 'sef', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sef\"}', '', '', '', '0', '0000-00-00 00:00:00', '8', '0'), ('430', '0', 'plg_system_logout', 'plugin', 'logout', 'system', '0', '1', '1', '1', '{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logout\"}', '', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('431', '0', 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', '0', '0', '1', '0', '{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"August 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contactcreator\"}', '{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('432', '0', 'plg_user_joomla', 'plugin', 'joomla', 'user', '0', '1', '1', '0', '{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"autoregister\":\"1\",\"mail_to_user\":\"1\",\"forceLogout\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('433', '0', 'plg_user_profile', 'plugin', 'profile', 'user', '0', '0', '1', '0', '{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"January 2008\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"profile\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('434', '0', 'plg_extension_joomla', 'plugin', 'joomla', 'extension', '0', '1', '1', '1', '{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"May 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('435', '0', 'plg_content_joomla', 'plugin', 'joomla', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('436', '0', 'plg_system_languagecode', 'plugin', 'languagecode', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"November 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagecode\"}', '', '', '', '0', '0000-00-00 00:00:00', '10', '0'), ('437', '0', 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', '0', '1', '1', '1', '{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomlaupdate\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('438', '0', 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', '0', '1', '1', '1', '{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"extensionupdate\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('439', '0', 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', '0', '0', '1', '0', '{\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.4.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('440', '0', 'plg_system_highlight', 'plugin', 'highlight', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"highlight\"}', '', '', '', '0', '0000-00-00 00:00:00', '7', '0'), ('441', '0', 'plg_content_finder', 'plugin', 'finder', 'content', '0', '0', '1', '0', '{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('442', '0', 'plg_finder_categories', 'plugin', 'categories', 'finder', '0', '1', '1', '0', '{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('443', '0', 'plg_finder_contacts', 'plugin', 'contacts', 'finder', '0', '1', '1', '0', '{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}', '', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('444', '0', 'plg_finder_content', 'plugin', 'content', 'finder', '0', '1', '1', '0', '{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('445', '0', 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', '0', '1', '1', '0', '{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '', '', '', '0', '0000-00-00 00:00:00', '4', '0'), ('447', '0', 'plg_finder_tags', 'plugin', 'tags', 'finder', '0', '1', '1', '0', '{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"February 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('448', '0', 'plg_twofactorauth_totp', 'plugin', 'totp', 'twofactorauth', '0', '0', '1', '0', '{\"name\":\"plg_twofactorauth_totp\",\"type\":\"plugin\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"totp\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('449', '0', 'plg_authentication_cookie', 'plugin', 'cookie', 'authentication', '0', '1', '1', '0', '{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"July 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTH_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cookie\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('450', '0', 'plg_twofactorauth_yubikey', 'plugin', 'yubikey', 'twofactorauth', '0', '0', '1', '0', '{\"name\":\"plg_twofactorauth_yubikey\",\"type\":\"plugin\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"yubikey\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('451', '0', 'plg_search_tags', 'plugin', 'tags', 'search', '0', '1', '1', '0', '{\"name\":\"plg_search_tags\",\"type\":\"plugin\",\"creationDate\":\"March 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{\"search_limit\":\"50\",\"show_tagged_items\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('452', '0', 'plg_system_updatenotification', 'plugin', 'updatenotification', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"May 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"updatenotification\"}', '{\"lastrun\":1506148111}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('453', '0', 'plg_editors-xtd_module', 'plugin', 'module', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"October 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"module\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('454', '0', 'plg_system_stats', 'plugin', 'stats', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"stats\"}', '{\"mode\":3,\"lastrun\":\"\",\"unique_id\":\"3fe5869600dcb167339da7e8d8d1293fb32e67a0\",\"interval\":12}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('455', '0', 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', 'installer', '0', '1', '1', '1', '{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"packageinstaller\"}', '', '', '', '0', '0000-00-00 00:00:00', '1', '0'), ('456', '0', 'PLG_INSTALLER_FOLDERINSTALLER', 'plugin', 'folderinstaller', 'installer', '0', '1', '1', '1', '{\"name\":\"PLG_INSTALLER_FOLDERINSTALLER\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"folderinstaller\"}', '', '', '', '0', '0000-00-00 00:00:00', '2', '0'), ('457', '0', 'PLG_INSTALLER_URLINSTALLER', 'plugin', 'urlinstaller', 'installer', '0', '1', '1', '1', '{\"name\":\"PLG_INSTALLER_URLINSTALLER\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"urlinstaller\"}', '', '', '', '0', '0000-00-00 00:00:00', '3', '0'), ('458', '0', 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', 'quickicon', '0', '1', '1', '1', '{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpversioncheck\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('459', '0', 'plg_editors-xtd_menu', 'plugin', 'menu', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"menu\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('460', '0', 'plg_editors-xtd_contact', 'plugin', 'contact', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"October 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('461', '0', 'plg_system_fields', 'plugin', 'fields', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('462', '0', 'plg_fields_calendar', 'plugin', 'calendar', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"calendar\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('463', '0', 'plg_fields_checkboxes', 'plugin', 'checkboxes', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"checkboxes\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('464', '0', 'plg_fields_color', 'plugin', 'color', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"color\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('465', '0', 'plg_fields_editor', 'plugin', 'editor', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"editor\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('466', '0', 'plg_fields_imagelist', 'plugin', 'imagelist', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"imagelist\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('467', '0', 'plg_fields_integer', 'plugin', 'integer', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"integer\"}', '{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('468', '0', 'plg_fields_list', 'plugin', 'list', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"list\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('469', '0', 'plg_fields_media', 'plugin', 'media', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('470', '0', 'plg_fields_radio', 'plugin', 'radio', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"radio\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('471', '0', 'plg_fields_sql', 'plugin', 'sql', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sql\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('472', '0', 'plg_fields_text', 'plugin', 'text', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"text\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('473', '0', 'plg_fields_textarea', 'plugin', 'textarea', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"textarea\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('474', '0', 'plg_fields_url', 'plugin', 'url', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"url\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('475', '0', 'plg_fields_user', 'plugin', 'user', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('476', '0', 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"usergrouplist\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('477', '0', 'plg_content_fields', 'plugin', 'fields', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('478', '0', 'plg_editors-xtd_fields', 'plugin', 'fields', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('479', '0', 'plg_sampledata_blog', 'plugin', 'blog', 'sampledata', '0', '0', '1', '0', '{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"blog\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('503', '0', 'beez3', 'template', 'beez3', '', '0', '1', '1', '0', '{\"name\":\"beez3\",\"type\":\"template\",\"creationDate\":\"25 November 2009\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"3.1.0\",\"description\":\"TPL_BEEZ3_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"templatecolor\":\"nature\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('504', '0', 'hathor', 'template', 'hathor', '', '1', '1', '1', '0', '{\"name\":\"hathor\",\"type\":\"template\",\"creationDate\":\"May 2010\",\"author\":\"Andrea Tarr\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"3.0.0\",\"description\":\"TPL_HATHOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"showSiteName\":\"0\",\"colourChoice\":\"0\",\"boldText\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('506', '0', 'protostar', 'template', 'protostar', '', '0', '1', '1', '0', '{\"name\":\"protostar\",\"type\":\"template\",\"creationDate\":\"4\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_PROTOSTAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"templateColor\":\"\",\"logoFile\":\"\",\"googleFont\":\"1\",\"googleFontName\":\"Open+Sans\",\"fluidContainer\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('507', '0', 'isis', 'template', 'isis', '', '1', '1', '1', '0', '{\"name\":\"isis\",\"type\":\"template\",\"creationDate\":\"3\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ISIS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"templateColor\":\"\",\"logoFile\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('600', '802', 'English (en-GB)', 'language', 'en-GB', '', '0', '1', '1', '1', '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"September 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"en-GB site language\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('601', '802', 'English (en-GB)', 'language', 'en-GB', '', '1', '1', '1', '1', '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"September 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"en-GB administrator language\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('700', '0', 'files_joomla', 'file', 'joomla', '', '0', '1', '1', '1', '{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"September 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('802', '0', 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', '', '0', '1', '1', '1', '{\"name\":\"English (en-GB) Language Pack\",\"type\":\"package\",\"creationDate\":\"September 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0.1\",\"description\":\"en-GB language pack\",\"group\":\"\",\"filename\":\"pkg_en-GB\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10000', '0', 'autocare', 'template', 'autocare', '', '0', '1', '1', '0', '{\"name\":\"autocare\",\"type\":\"template\",\"creationDate\":\"May 2017\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"2.0\",\"description\":\"Autocare 2.0\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"preloader\":\"0\",\"preloader_animation\":\"circle\",\"preloader_bg\":\"#f5f5f5\",\"preloader_tx\":\"#333333\",\"goto_top\":\"0\",\"sticky_header\":\"1\",\"boxed_layout\":\"0\",\"logo_type\":\"image\",\"logo_position\":\"logo\",\"logo_load_pos\":\"default\",\"body_bg_repeat\":\"inherit\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"body_bg_position\":\"0 0\",\"enabled_copyright\":\"1\",\"copyright_position\":\"footer1\",\"copyright_load_pos\":\"default\",\"copyright\":\"\\u00a9 2015 Your Company. All Rights Reserved. Designed By JoomShaper\",\"show_social_icons\":\"1\",\"social_position\":\"top1\",\"social_load_pos\":\"default\",\"enable_contactinfo\":\"1\",\"contact_position\":\"top2\",\"comingsoon_mode\":\"0\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_date\":\"5-10-2018\",\"comingsoon_content\":\"Coming soon content\",\"preset\":\"preset1\",\"preset1_bg\":\"#ffffff\",\"preset1_text\":\"#000000\",\"preset1_major\":\"#26aae1\",\"preset1_megabg\":\"#ffffff\",\"preset1_megatx\":\"#333333\",\"preset2_bg\":\"#ffffff\",\"preset2_text\":\"#000000\",\"preset2_major\":\"#3d449a\",\"preset2_megabg\":\"#ffffff\",\"preset2_megatx\":\"#333333\",\"preset3_bg\":\"#ffffff\",\"preset3_text\":\"#000000\",\"preset3_major\":\"#2bb673\",\"preset3_megabg\":\"#ffffff\",\"preset3_megatx\":\"#333333\",\"preset4_bg\":\"#ffffff\",\"preset4_text\":\"#000000\",\"preset4_major\":\"#eb4947\",\"preset4_megabg\":\"#ffffff\",\"preset4_megatx\":\"#333333\",\"menu\":\"mainmenu\",\"menu_type\":\"mega_offcanvas\",\"menu_animation\":\"menu-fade\",\"offcanvas_animation\":\"default\",\"enable_body_font\":\"1\",\"body_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"300\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h1_font\":\"1\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"800\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h2_font\":\"1\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h3_font\":\"1\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h4_font\":\"1\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h5_font\":\"1\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h6_font\":\"1\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_navigation_font\":\"0\",\"enable_custom_font\":\"0\",\"compress_css\":\"0\",\"compress_js\":\"0\",\"lessoption\":\"0\",\"show_post_format\":\"1\",\"commenting_engine\":\"disabled\",\"disqus_devmode\":\"0\",\"intensedebate_acc\":\"\",\"fb_width\":\"500\",\"fb_cpp\":\"10\",\"comments_count\":\"0\",\"social_share\":\"1\",\"image_small\":\"0\",\"image_small_size\":\"100X100\",\"image_thumbnail\":\"1\",\"image_thumbnail_size\":\"200X200\",\"image_medium\":\"0\",\"image_medium_size\":\"300X300\",\"image_large\":\"0\",\"image_large_size\":\"600X600\",\"blog_list_image\":\"default\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10001', '0', 'offlajn_installer', 'component', 'com_offlajn_installer', '', '1', '1', '0', '0', '{\"name\":\"offlajn_installer\",\"type\":\"component\",\"creationDate\":\"2012 January\",\"author\":\"Balint Polgarfi\",\"copyright\":\"Copyright (C) 2012 All rights reserved.\",\"authorEmail\":\"balint.polgarfi|at|offlajn.com\",\"authorUrl\":\"http:\\/\\/www.offlajn.com\",\"version\":\"1.0\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10002', '0', 'Layer Slider', 'module', 'mod_layer_slider', '', '0', '1', '0', '0', '{\"name\":\"Layer Slider\",\"type\":\"module\",\"creationDate\":\"2014-03-24\",\"author\":\"John Gera, George Krupa, Janos Biro, Balint Polgarfi\",\"copyright\":\"Copyright (C) 2016. All rights reserved.\",\"authorEmail\":\"info@offlajn.com\",\"authorUrl\":\"http:\\/\\/offlajn.com\",\"version\":\"6.5.132\",\"description\":\"\",\"group\":\"\",\"filename\":\"mod_layer_slider\"}', '{\"slider\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10003', '0', 'Layer Slider editor extend', 'plugin', 'layer_slider', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"Layer Slider editor extend\",\"type\":\"plugin\",\"creationDate\":\"Apr 2014\",\"author\":\"Janos Biro\",\"copyright\":\"Copyright (C) 2014 Offlajn.com All rights reserved.\",\"authorEmail\":\"info@offlajn.com\",\"authorUrl\":\"www.offlajn.com\",\"version\":\"1.0.0\",\"description\":\"\",\"group\":\"\",\"filename\":\"layer_slider\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10004', '0', 'Layer slider content plugin', 'plugin', 'loadlayerslider', 'content', '0', '1', '1', '0', '{\"name\":\"Layer slider content plugin\",\"type\":\"plugin\",\"creationDate\":\"Apr 2014\",\"author\":\"Janos Biro, Balint Polgarfi\",\"copyright\":\"Copyright (C) 2017 All rights reserved.\",\"authorEmail\":\"info@offlajn.com\",\"authorUrl\":\"http:\\/\\/offlajn.com\",\"version\":\"6.5.0\",\"description\":\"With this content plugin you can load LayerSlider anywhere in your articles with a shortcode.\",\"group\":\"\",\"filename\":\"loadlayerslider\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10005', '0', 'System - Offlajn Params', 'plugin', 'offlajnparams', 'system', '0', '1', '1', '0', '{\"name\":\"System - Offlajn Params\",\"type\":\"plugin\",\"creationDate\":\"Marc 2016\",\"author\":\"Balint Polgarfi\",\"copyright\":\"Copyright (C) Offlajn.com\",\"authorEmail\":\"info@offlajn.com\",\"authorUrl\":\"http:\\/\\/offlajn.com\",\"version\":\"1.1.0\",\"description\":\"\",\"group\":\"\",\"filename\":\"offlajnparams\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10006', '0', 'com_layer_slider', 'component', 'com_layer_slider', '', '1', '1', '0', '0', '{\"name\":\"com_layer_slider\",\"type\":\"component\",\"creationDate\":\"2014-03-24\",\"author\":\"John Gera, George Krupa, Janos Biro, Balint Polgarfi\",\"copyright\":\"Copyright (C) 2016. All rights reserved.\",\"authorEmail\":\"info@offlajn.com\",\"authorUrl\":\"http:\\/\\/offlajn.com\",\"version\":\"6.5.132\",\"description\":\"\",\"group\":\"\",\"filename\":\"layer_slider\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10007', '0', 'Helix3 - Ajax', 'plugin', 'helix3', 'ajax', '0', '1', '1', '0', '{\"name\":\"Helix3 - Ajax\",\"type\":\"plugin\",\"creationDate\":\"Jan 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"2.3\",\"description\":\"Helix3 Framework - Joomla Template Framework by JoomShaper\",\"group\":\"\",\"filename\":\"helix3\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10008', '0', 'System - Helix3 Framework', 'plugin', 'helix3', 'system', '0', '1', '1', '0', '{\"name\":\"System - Helix3 Framework\",\"type\":\"plugin\",\"creationDate\":\"Jan 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"2.3\",\"description\":\"Helix3 Framework - Joomla Template Framework by JoomShaper\",\"group\":\"\",\"filename\":\"helix3\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10009', '0', 'Custom HTML advanced', 'module', 'mod_custom_advanced', '', '0', '1', '0', '0', '{\"name\":\"Custom HTML advanced\",\"type\":\"module\",\"creationDate\":\"April 2014\",\"author\":\"Pluginaria.com\",\"copyright\":\"Copyright (C) 2013 Pluginaria.com.\",\"authorEmail\":\"feedback@jtricks.com\",\"authorUrl\":\"www.pluginaria.com\",\"version\":\"2.6\",\"description\":\"MOD_CUSTOM_ADVANCED_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom_advanced\"}', '{\"customHtml\":\"\",\"prepare_content\":\"0\",\"evalPhp\":\"\",\"moduleStyle\":\"\",\"cssOverride\":\"\",\"styleSheet\":\"\",\"javascriptFile\":\"\",\"htmlComments\":\"1\",\"requireHttpParam\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10010', '0', 'Owl Сarousel', 'module', 'mod_owl_carousel', '', '0', '1', '0', '0', '{\"name\":\"Owl \\u0421arousel\",\"type\":\"module\",\"creationDate\":\"10\\/07\\/2016\",\"author\":\"payo\",\"copyright\":\"Copyright (C) 2016. All Rights Reserved.\",\"authorEmail\":\"office@payothemes.com\",\"authorUrl\":\"\",\"version\":\"1.5\",\"description\":\"Owl \\u0421arousel\",\"group\":\"\",\"filename\":\"mod_owl_carousel\"}', '{\"owl_load_jquery\":\"1\",\"owl_jquery_ver\":\"1.10.2\",\"owl_load_base\":\"1\",\"owl_width_block\":\"600\",\"owl_items\":\"1\",\"owl_navigation\":\"true\",\"owl_pagination\":\"true\",\"owl_paginationnumbers\":\"false\",\"img1\":\"\",\"alt1\":\"\",\"url1\":\"\",\"target1\":\"_self\",\"html1\":\"\",\"img2\":\"\",\"alt2\":\"\",\"url2\":\"\",\"target2\":\"_self\",\"html2\":\"\",\"img3\":\"\",\"alt3\":\"\",\"url3\":\"\",\"target3\":\"_self\",\"html3\":\"\",\"img4\":\"\",\"alt4\":\"\",\"url4\":\"\",\"target4\":\"_self\",\"html4\":\"\",\"img5\":\"\",\"alt5\":\"\",\"url5\":\"\",\"target5\":\"_self\",\"html5\":\"\",\"img6\":\"\",\"alt6\":\"\",\"url6\":\"\",\"target6\":\"_self\",\"html6\":\"\",\"img7\":\"\",\"alt7\":\"\",\"url7\":\"\",\"target7\":\"_self\",\"html7\":\"\",\"img8\":\"\",\"alt8\":\"\",\"url8\":\"\",\"target8\":\"_self\",\"html8\":\"\",\"img9\":\"\",\"alt9\":\"\",\"url9\":\"\",\"target9\":\"_self\",\"html9\":\"\",\"img10\":\"\",\"alt10\":\"\",\"url10\":\"\",\"target10\":\"_self\",\"html10\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10011', '0', 'SP Page Builder', 'component', 'com_sppagebuilder', '', '1', '1', '0', '0', '{\"name\":\"SP Page Builder\",\"type\":\"component\",\"creationDate\":\"Sep 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright @ 2010 - 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"2.5.3\",\"description\":\"\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{\"addcontainer\":\"1\",\"gmap_api\":\"AIzaSyB9E2j0TDNfZk7D5eLeJJg5cEcXH9UDfEs\",\"fontawesome\":\"1\",\"disableanimatecss\":\"0\",\"disablecss\":\"0\",\"joomshaper_email\":\"\",\"joomshaper_license_key\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10012', '0', 'System - SP PageBuilder', 'plugin', 'sppagebuilder', 'system', '0', '1', '1', '0', '{\"name\":\"System - SP PageBuilder\",\"type\":\"plugin\",\"creationDate\":\"Sep 2016\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10013', '0', 'System - SP Page Builder Pro Updater', 'plugin', 'sppagebuilderproupdater', 'system', '0', '1', '1', '0', '{\"name\":\"System - SP Page Builder Pro Updater\",\"type\":\"plugin\",\"creationDate\":\"Jul 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.1\",\"description\":\"SP Page Builder Pro Updater Plugin\",\"group\":\"\",\"filename\":\"sppagebuilderproupdater\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10014', '0', 'plg_search_sppagebuilder', 'plugin', 'sppagebuilder', 'search', '0', '1', '1', '0', '{\"name\":\"plg_search_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"July 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2015 Open Source Matters. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.2\",\"description\":\"PLG_SEARCH_SPPAGEBUILDER_DESCRIPTION\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10015', '0', 'SP Page Builder', 'module', 'mod_sppagebuilder', '', '0', '1', '0', '0', '{\"name\":\"SP Page Builder\",\"type\":\"module\",\"creationDate\":\"Oct 2016\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.2\",\"description\":\"Module to display content from SP Page Builder\",\"group\":\"\",\"filename\":\"mod_sppagebuilder\"}', '{\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10016', '0', 'mod_sppagebuilder_icons', 'module', 'mod_sppagebuilder_icons', '', '1', '1', '2', '0', '{\"name\":\"mod_sppagebuilder_icons\",\"type\":\"module\",\"creationDate\":\"August 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.2\",\"description\":\"MOD_SPPAGEBUILDER_ICONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sppagebuilder_icons\"}', '[]', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10017', '0', 'mod_sppagebuilder_admin_menu', 'module', 'mod_sppagebuilder_admin_menu', '', '1', '1', '2', '0', '{\"name\":\"mod_sppagebuilder_admin_menu\",\"type\":\"module\",\"creationDate\":\"August 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"MOD_SPPAGEBUILDER_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sppagebuilder_admin_menu\"}', '[]', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10018', '0', 'mod_submenu', 'module', 'mod_submenu', '', '0', '1', '0', '0', '{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2016 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"Show submenu from item\",\"group\":\"\",\"filename\":\"mod_submenu\"}', '[]', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10020', '10024', 'Akeeba', 'component', 'com_akeeba', '', '1', '1', '0', '0', '{\"name\":\"Akeeba\",\"type\":\"component\",\"creationDate\":\"2017-09-12\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2017 Akeeba Ltd \\/ Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"5.6.0\",\"description\":\"Akeeba Backup Core - Full Joomla! site backup solution, Core Edition.\",\"group\":\"\",\"filename\":\"akeeba\"}', '{\"confwiz_upgrade\":1,\"updatedb\":null,\"siteurl\":\"http:\\/\\/localhost:8888\\/autocare\\/\",\"jlibrariesdir\":\"\\/Users\\/viki\\/Sites\\/autocare\\/libraries\",\"jversion\":\"1.6\",\"show_howtorestoremodal\":0,\"frontend_secret_word\":\"###AES128###EI5Kao8iCChkyi11CSSqekpQU1R7OBSQDHqUcZn6n3c19q1U5WfCjDGdyLatBFrf0MGGYbVy8y82sGJfwMQW\\/L\\/o+YH7bp1OewBvCzUfGmIKHJbwSlBJVjJ7w8LT6h1K40MMNw7+1vQAAAAA\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10021', '10024', 'plg_quickicon_akeebabackup', 'plugin', 'akeebabackup', 'quickicon', '0', '1', '1', '0', '{\"name\":\"plg_quickicon_akeebabackup\",\"type\":\"plugin\",\"creationDate\":\"2012-09-26\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2017 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"1.0\",\"description\":\"PLG_QUICKICON_AKEEBABACKUP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"akeebabackup\"}', '{\"context\":\"mod_quickicon\",\"enablewarning\":\"1\",\"warnfailed\":\"1\",\"maxbackupperiod\":\"24\",\"profileid\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10022', '10024', 'PLG_SYSTEM_AKEEBAUPDATECHECK_TITLE', 'plugin', 'akeebaupdatecheck', 'system', '0', '0', '1', '0', '{\"name\":\"PLG_SYSTEM_AKEEBAUPDATECHECK_TITLE\",\"type\":\"plugin\",\"creationDate\":\"2011-05-26\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2017 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"1.1\",\"description\":\"PLG_AKEEBAUPDATECHECK_DESCRIPTION2\",\"group\":\"\",\"filename\":\"akeebaupdatecheck\"}', '{\"email\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10023', '10024', 'PLG_SYSTEM_BACKUPONUPDATE_TITLE', 'plugin', 'backuponupdate', 'system', '0', '0', '1', '0', '{\"name\":\"PLG_SYSTEM_BACKUPONUPDATE_TITLE\",\"type\":\"plugin\",\"creationDate\":\"2013-08-13\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2017 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"3.7\",\"description\":\"PLG_SYSTEM_BACKUPONUPDATE_DESCRIPTION\",\"group\":\"\",\"filename\":\"backuponupdate\"}', '{\"profileid\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10024', '0', 'Akeeba Backup package', 'package', 'pkg_akeeba', '', '0', '1', '1', '0', '{\"name\":\"Akeeba Backup package\",\"type\":\"package\",\"creationDate\":\"2017-09-12\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2017 Akeeba Ltd \\/ Nicholas K. Dionysopoulos\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"5.6.0\",\"description\":\"Akeeba Backup installation package v.5.6.0\",\"group\":\"\",\"filename\":\"pkg_akeeba\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10025', '0', 'J2Store', 'component', 'com_j2store', '', '1', '1', '0', '0', '{\"name\":\"J2Store\",\"type\":\"component\",\"creationDate\":\"June 2017\",\"author\":\"Ramesh Elamathi\",\"copyright\":\"Copyright (c) 2017 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"3.2.23\",\"description\":\"<h3>J2 Store V3 Core<\\/h3>\\n      Flexible and native Joomla shopping cart solution. <br \\/>\\n      Use Joomla articles as products and get your shop online in less than 10 minutes. <br \\/>\\n      Start setting up your store now. <br \\/>\\n      Learn more from the <a target=\\\"_blank\\\" href=\\\"https:\\/\\/www.j2store.org\\/support\\/user-guide\\/getting-started-with-j2store.html\\\">Getting started guide<\\/a>\\n      If you have any questions, <a target=\\\"_blank\\\" href=\\\"https:\\/\\/www.j2store.org\\/support\\/community-forum.html\\\">get in touch with us<\\/a>\\n      \",\"group\":\"\",\"filename\":\"com_j2store\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10026', '0', 'J2 Store Chart', 'module', 'mod_j2store_chart', '', '1', '1', '2', '0', '{\"name\":\"J2 Store Chart\",\"type\":\"module\",\"creationDate\":\"Jan 2015\",\"author\":\"Gokila PriyaBose\",\"copyright\":\"Copyright (c) 2014 - 2019 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"\\n\\t <p>J2 Store Chart\\n\\t <p> Please contact to us for more info <a href=\\\"mailto:support@j2store.org\\\">support@j2store.org<\\/a><\\/p>\\t  \\n    \\t\\n\\t\\n\\t\",\"group\":\"\",\"filename\":\"mod_j2store_chart\"}', '{\"chart_type\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10027', '0', 'J2 Store Stats Mini', 'module', 'mod_j2store_stats_mini', '', '1', '1', '2', '0', '{\"name\":\"J2 Store Stats Mini\",\"type\":\"module\",\"creationDate\":\"Jan 2015\",\"author\":\"Gokila PriyaBose\",\"copyright\":\"Copyright (c) 2014 - 2019 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"\\n\\t <p>J2 Store Stats\\n\\t <p> Please contact to us for more info <a href=\\\"mailto:support@j2store.org\\\">support@j2store.org<\\/a><\\/p>\\t  \\n    \\t\\n\\t\\n\\t\",\"group\":\"\",\"filename\":\"mod_j2store_stats_mini\"}', '[]', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10028', '0', 'J2 Store Orders', 'module', 'mod_j2store_orders', '', '1', '1', '2', '0', '{\"name\":\"J2 Store Orders\",\"type\":\"module\",\"creationDate\":\"Jan 2015\",\"author\":\"Gokila PriyaBose\",\"copyright\":\"Copyright (c) 2014 - 2019 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"\\n\\t <p>J2 Store Orders\\n\\t <p> Please contact to us for more info <a href=\\\"mailto:support@j2store.org\\\">support@j2store.org<\\/a><\\/p>\\t  \\n    \\t\\n\\t\\n\\t\",\"group\":\"\",\"filename\":\"mod_j2store_orders\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10029', '0', 'J2 Store Stats', 'module', 'mod_j2store_stats', '', '1', '1', '2', '0', '{\"name\":\"J2 Store Stats\",\"type\":\"module\",\"creationDate\":\"Jan 2015\",\"author\":\"Gokila PriyaBose\",\"copyright\":\"Copyright (c) 2014 - 2019 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"\\n\\t <p>J2 Store Stats\\n\\t <p> Please contact to us for more info <a href=\\\"mailto:support@j2store.org\\\">support@j2store.org<\\/a><\\/p>\\t  \\n    \\t\\n\\t\\n\\t\",\"group\":\"\",\"filename\":\"mod_j2store_stats\"}', '[]', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10030', '0', 'J2Store Administrator Menu', 'module', 'mod_j2store_menu', '', '1', '1', '2', '0', '{\"name\":\"J2Store Administrator Menu\",\"type\":\"module\",\"creationDate\":\"June 2015\",\"author\":\"Gokila Priya\",\"copyright\":\"Copyright (c) 2011 - 2016 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"MOD_J2STORE_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_j2store_menu\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10031', '0', 'J2Store Currency', 'module', 'mod_j2store_currency', '', '0', '1', '0', '0', '{\"name\":\"J2Store Currency\",\"type\":\"module\",\"creationDate\":\"December 2014\",\"author\":\"Ramesh Elamathi\",\"copyright\":\"Copyright (c) 2013 - 2018 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"\\n\\t <p>J2Store shopping cart currency switcher module\\n\\t <p> Please contact to us for more info <a href=\\\"mailto:support@j2store.org\\\">support@j2store.org<\\/a><\\/p>\\t  \\n    \\t\\n\\t\\n\\t\",\"group\":\"\",\"filename\":\"mod_j2store_currency\"}', '{\"moduleclass_sfx\":\"\",\"background_color\":\"#FFFFFF\",\"text_color\":\"#000000\",\"link_color\":\"#CCCCCC\",\"link_hover_color\":\"#000000\",\"active_link_color\":\"#000000\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10032', '0', 'J2 Store Cart', 'module', 'mod_j2store_cart', '', '0', '1', '0', '0', '{\"name\":\"J2 Store Cart\",\"type\":\"module\",\"creationDate\":\"Jan 2015\",\"author\":\"Sasi varna kumar\",\"copyright\":\"Copyright (c) 2011 - 2016 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"\\n\\t <p>J2 Store Cart\\n\\t <p> Please contact to us for more info <a href=\\\"mailto:support@j2store.org\\\">support@j2store.org<\\/a><\\/p>\\t  \\n    \\t\\n\\t\\n\\t\",\"group\":\"\",\"filename\":\"mod_j2store_cart\"}', '{\"moduleclass_sfx\":\"\",\"link_type\":\"link\",\"check_empty\":\"0\",\"quantity_count\":\"0\",\"show_thumbimage\":\"0\",\"show_product_qty\":\"0\",\"show_cart_remove\":\"0\",\"enable_checkout\":\"0\",\"enable_view_cart\":\"0\",\"minicart_cart_icon_class\":\"fa fa-shoppingcart\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10033', '0', 'Content - J2Store', 'plugin', 'j2store', 'content', '0', '1', '1', '0', '{\"name\":\"Content - J2Store\",\"type\":\"plugin\",\"creationDate\":\"October 2014\",\"author\":\"J2Store Team\",\"copyright\":\"Copyright (c) 2014 - 2019 J2Store.org All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"Content plugin for J2Store.\",\"group\":\"\",\"filename\":\"j2store\"}', '', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10034', '0', 'System - J2Store', 'plugin', 'j2store', 'system', '0', '1', '1', '0', '{\"name\":\"System - J2Store\",\"type\":\"plugin\",\"creationDate\":\"Jan 2012\",\"author\":\"Sasi varna kumar\",\"copyright\":\"(C) 2010-2015 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"www.j2store.org\",\"version\":\"2.0\",\"description\":\"System plugin that loads the required Javascript and other files required for J2Store.\",\"group\":\"\",\"filename\":\"j2store\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10035', '0', 'System - J2Page Cache', 'plugin', 'j2pagecache', 'system', '0', '0', '1', '0', '{\"name\":\"System - J2Page Cache\",\"type\":\"plugin\",\"creationDate\":\"JUN 2016\",\"author\":\"Alagesan\",\"copyright\":\"(C) 2016 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"www.j2store.org\",\"version\":\"1.0\",\"description\":\"System plugin that used to clear page cache.\",\"group\":\"\",\"filename\":\"j2pagecache\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10036', '0', 'Search - J2Store ', 'plugin', 'j2store', 'search', '0', '0', '1', '0', '{\"name\":\"Search - J2Store \",\"type\":\"plugin\",\"creationDate\":\"September 2015\",\"author\":\"Gokila Priya\",\"copyright\":\"Copyright (c) 2011 - 2016 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"PLG_SEARCH_J2STORE_DESCRIPTION\",\"group\":\"\",\"filename\":\"j2store\"}', '{\"redirect_to\":\"j2store\",\"search_limit\":\"50\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10037', '0', 'Finder - J2Store', 'plugin', 'j2store', 'finder', '0', '0', '1', '0', '{\"name\":\"Finder - J2Store\",\"type\":\"plugin\",\"creationDate\":\"September 2015\",\"author\":\"Gokila Priya\",\"copyright\":\"2010 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"PLG_FINDER_J2STORE_DESCRIPTION\",\"group\":\"\",\"filename\":\"j2store\"}', '{\"redirect_to\":\"j2store\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10038', '0', 'Free Shipping', 'plugin', 'shipping_free', 'j2store', '0', '0', '1', '0', '{\"name\":\"Free Shipping\",\"type\":\"plugin\",\"creationDate\":\"September 2015\",\"author\":\"Gokila Priya\",\"copyright\":\"2015 WeblogicxIndia\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"http:\\/\\/www.j2store.org\",\"version\":\"1.1\",\"description\":\"PLG_J2STORE_SHIPPING_FREE_DESCRIPTION\",\"group\":\"\",\"filename\":\"shipping_free\"}', '{\"display_name\":\"Free shipping\",\"min_subtotal\":\"0\",\"max_subtotal\":\"-1\",\"requires_coupon\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10039', '0', 'Standard Shipping methods', 'plugin', 'shipping_standard', 'j2store', '0', '1', '1', '0', '{\"name\":\"Standard Shipping methods\",\"type\":\"plugin\",\"creationDate\":\"December 2014\",\"author\":\"J2Store\",\"copyright\":\"2010 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"J2STORE_PLUGINDESC\",\"group\":\"\",\"filename\":\"shipping_standard\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10040', '0', 'Cash on Delivery', 'plugin', 'payment_cash', 'j2store', '0', '1', '1', '0', '{\"name\":\"Cash on Delivery\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Weblogicx India\",\"copyright\":\"2013 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"J2STORE_CASH_PLUGINDESC\",\"group\":\"\",\"filename\":\"payment_cash\"}', '{\"display_name\":\"\",\"surcharge_percent\":\"\",\"surcharge_fixed\":\"\",\"surcharge_name\":\"\",\"surcharge_tax_class_id\":\"\",\"min_subtotal\":\"0.000\",\"max_subtotal\":\"-1.00\",\"payment_status\":\"4\",\"geozone_id\":\"\",\"onselection\":\"\",\"onbeforepayment\":\"\",\"onafterpayment\":\"\",\"button_text\":\"J2STORE_PLACE_ORDER\",\"articleid\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10041', '0', 'Money Order', 'plugin', 'payment_moneyorder', 'j2store', '0', '1', '1', '0', '{\"name\":\"Money Order\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Weblogicx India\",\"copyright\":\"2013 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"J2STORE_MONEYORDER_PLUGINDESC\",\"group\":\"\",\"filename\":\"payment_moneyorder\"}', '{\"display_name\":\"\",\"moneyorder_information\":\"\",\"payment_status\":\"4\",\"surcharge_percent\":\"\",\"surcharge_fixed\":\"\",\"surcharge_name\":\"\",\"surcharge_tax_class_id\":\"\",\"geozone_id\":\"\",\"onselection\":\"\",\"onbeforepayment\":\"\",\"onafterpayment\":\"\",\"button_text\":\"J2STORE_PLACE_ORDER\",\"articleid\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10042', '0', 'Bank transfer', 'plugin', 'payment_banktransfer', 'j2store', '0', '1', '1', '0', '{\"name\":\"Bank transfer\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Weblogicx India\",\"copyright\":\"2013 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"J2STORE_BANKTRANSFER_PLUGINDESC\",\"group\":\"\",\"filename\":\"payment_banktransfer\"}', '{\"display_name\":\"\",\"bank_information\":\"\",\"payment_status\":\"4\",\"surcharge_percent\":\"\",\"surcharge_fixed\":\"\",\"surcharge_name\":\"\",\"surcharge_tax_class_id\":\"\",\"geozone_id\":\"\",\"onselection\":\"\",\"onbeforepayment\":\"\",\"onafterpayment\":\"\",\"button_text\":\"J2STORE_PLACE_ORDER\",\"articleid\":\"\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10043', '0', 'Paymill', 'plugin', 'payment_paymill', 'j2store', '0', '1', '1', '0', '{\"name\":\"Paymill\",\"type\":\"plugin\",\"creationDate\":\"June 2014\",\"author\":\"j2store.org\",\"copyright\":\"2014 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.1\",\"description\":\"J2STORE_PAYMILL_PAYMENT_DESC\",\"group\":\"\",\"filename\":\"payment_paymill\"}', '{\"display_name\":\"\",\"registration\":\"\",\"live_private_key\":\"\",\"live_public_key\":\"\",\"sandbox\":\"0\",\"test_private_key\":\"\",\"test_public_key\":\"\",\"onselection\":\"\",\"onbeforepayment\":\"\",\"onafterpayment\":\"\",\"onerrorpayment\":\"\",\"oncancelpayment\":\"\",\"button_text\":\"J2STORE_PLACE_ORDER\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10044', '0', 'SagePay Direct', 'plugin', 'payment_sagepay', 'j2store', '0', '1', '1', '0', '{\"name\":\"SagePay Direct\",\"type\":\"plugin\",\"creationDate\":\"January 2016\",\"author\":\"j2store.org\",\"copyright\":\"2013-2018 Weblogicx India Private Limited \",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"2.4\",\"description\":\"J2STORE_SAGEPAY_PLUGINDESC\",\"group\":\"\",\"filename\":\"payment_sagepay\"}', '{\"display_name\":\"\",\"merchant_email\":\"\",\"enc_password\":\"\",\"card_types\":\"Visa,Mastercard\",\"sandbox\":\"0\",\"articleid\":\"\",\"onselection\":\"\",\"onbeforepayment\":\"\",\"onafterpayment\":\"\",\"onerrorpayment\":\"\",\"oncancelpayment\":\"\",\"button_text\":\"J2STORE_PLACE_ORDER\",\"debug\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10045', '0', 'Report Itemised', 'plugin', 'report_itemised', 'j2store', '0', '1', '1', '0', '{\"name\":\"Report Itemised\",\"type\":\"plugin\",\"creationDate\":\"May 2014\",\"author\":\"Gokila Priya\",\"copyright\":\"2014-19 WeblogicxIndia\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"http:\\/\\/www.j2store.org\",\"version\":\"1.0\",\"description\":\"PLG_J2STORE_PLUGIN_REPORT_ITEMISED_DESC\",\"group\":\"\",\"filename\":\"report_itemised\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10046', '0', 'Localization Data for J2Store', 'plugin', 'app_localization_data', 'j2store', '0', '1', '1', '0', '{\"name\":\"Localization Data for J2Store\",\"type\":\"plugin\",\"creationDate\":\"Jan 2015\",\"author\":\"Gokila Priya\",\"copyright\":\"2014-19 WeblogicxIndia\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"http:\\/\\/www.j2store.org\",\"version\":\"1.0\",\"description\":\"J2STORE_APP_LOCALIZATION_DATA_HELP_TEXT\",\"group\":\"\",\"filename\":\"app_localization_data\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10047', '0', 'Diagnostics Tool', 'plugin', 'app_diagnostics', 'j2store', '0', '1', '1', '0', '{\"name\":\"Diagnostics Tool\",\"type\":\"plugin\",\"creationDate\":\"February 2015\",\"author\":\"Gokila Priya\",\"copyright\":\"2015 Weblogicx India\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"http:\\/\\/www.j2store.org\",\"version\":\"1.0\",\"description\":\"J2STORE_DIAGNOSTICS_HELP_TEXT\",\"group\":\"\",\"filename\":\"app_diagnostics\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10049', '0', 'SP Tab', 'module', 'mod_sptab', '', '0', '0', '0', '0', '{\"name\":\"SP Tab\",\"type\":\"module\",\"creationDate\":\"May 2011\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2012 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"2.0\",\"description\":\"SP Tab - Next generation tab module for joomla\",\"group\":\"\",\"filename\":\"mod_sptab\"}', '{\"mods\":\"0\",\"ordering\":\"ordering\",\"ordering_direction\":\"ASC\",\"nav_height\":\"30\",\"nav_pos\":\"top\",\"body_padding\":\"10px\",\"tab_style\":\"custom\",\"color\":\"sptab_red\",\"header_bg\":\"#333333\",\"nav_bg\":\"#333333\",\"nav_text\":\"#FFFFFF\",\"nav_hover\":\"#057ea6\",\"nav_hover_text\":\"#FFFFFF\",\"nav_active\":\"#729c00\",\"nav_active_text\":\"#FFFFFF\",\"nav_border_color\":\"#666666\",\"nav_border_pos\":\"right\",\"nav_wborder\":\"1\",\"nav_margin\":\"right\",\"nav_margin_val\":\"0\",\"body_bg\":\"#FFFFFF\",\"body_text\":\"#444444\",\"border_color\":\"#e1e1e1\",\"body_wborder\":\"1\",\"activator\":\"click\",\"fx_speed\":\"400\",\"animation\":\"scroll:fade\",\"transition\":\"linear\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10050', '0', 'com_jbeasyformmaker', 'component', 'com_jbeasyformmaker', '', '1', '1', '0', '0', '{\"name\":\"com_jbeasyformmaker\",\"type\":\"component\",\"creationDate\":\"June 2016 \",\"author\":\"Priya Bose\",\"copyright\":\"2016 www.joomlabuff.com\",\"authorEmail\":\"support@joomlabuff.com\",\"authorUrl\":\"www.joomlabuff.com\",\"version\":\"1.0.0\",\"description\":\"Create flexible and easy forms using Easy Form Maker - JoomlaBuff \",\"group\":\"\",\"filename\":\"com_jbeasyformmaker\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10051', '0', 'mod_jbeasyformmaker', 'module', 'mod_jbeasyformmaker', '', '0', '1', '0', '0', '{\"name\":\"mod_jbeasyformmaker\",\"type\":\"module\",\"creationDate\":\"June 2016\",\"author\":\"Priya Bose JoomlaBuff\",\"copyright\":\"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.\",\"authorEmail\":\"support@joomlabuff.com\",\"authorUrl\":\"www.joomla.org\",\"version\":\"1.0.0\",\"description\":\"MOD_JBEASYFORMMAKER_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_jbeasyformmaker\"}', '{\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10052', '0', 'COM_K2', 'component', 'com_k2', '', '1', '1', '0', '0', '{\"name\":\"COM_K2\",\"type\":\"component\",\"creationDate\":\"August 18th, 2017\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2017 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.8.0\",\"description\":\"Thank you for installing K2 by JoomlaWorks, the powerful content extension for Joomla\",\"group\":\"\",\"filename\":\"k2\"}', '{\"enable_css\":\"1\",\"jQueryHandling\":\"1.8remote\",\"backendJQueryHandling\":\"remote\",\"userName\":\"1\",\"userImage\":\"1\",\"userDescription\":\"1\",\"userURL\":\"1\",\"userEmail\":\"0\",\"userFeedLink\":\"0\",\"userFeedIcon\":\"0\",\"userItemCount\":\"10\",\"userItemTitle\":\"1\",\"userItemTitleLinked\":\"1\",\"userItemDateCreated\":\"1\",\"userItemImage\":\"1\",\"userItemIntroText\":\"1\",\"userItemCategory\":\"1\",\"userItemTags\":\"1\",\"userItemCommentsAnchor\":\"1\",\"userItemReadMore\":\"1\",\"userItemK2Plugins\":\"1\",\"tagItemCount\":\"10\",\"tagItemTitle\":\"1\",\"tagItemTitleLinked\":\"1\",\"tagItemDateCreated\":\"1\",\"tagItemImage\":\"1\",\"tagItemIntroText\":\"1\",\"tagItemCategory\":\"1\",\"tagItemReadMore\":\"1\",\"tagItemExtraFields\":\"0\",\"tagOrdering\":\"\",\"tagFeedLink\":\"0\",\"tagFeedIcon\":\"0\",\"genericItemCount\":\"10\",\"genericItemTitle\":\"1\",\"genericItemTitleLinked\":\"1\",\"genericItemDateCreated\":\"1\",\"genericItemImage\":\"1\",\"genericItemIntroText\":\"1\",\"genericItemCategory\":\"1\",\"genericItemReadMore\":\"1\",\"genericItemExtraFields\":\"0\",\"genericFeedLink\":\"0\",\"genericFeedIcon\":\"0\",\"feedLimit\":\"10\",\"feedItemImage\":\"1\",\"feedImgSize\":\"S\",\"feedItemIntroText\":\"1\",\"feedTextWordLimit\":\"\",\"feedItemFullText\":\"1\",\"feedItemTags\":\"0\",\"feedItemVideo\":\"0\",\"feedItemGallery\":\"0\",\"feedItemAttachments\":\"0\",\"feedBogusEmail\":\"\",\"introTextCleanup\":\"0\",\"introTextCleanupExcludeTags\":\"\",\"introTextCleanupTagAttr\":\"\",\"fullTextCleanup\":\"0\",\"fullTextCleanupExcludeTags\":\"\",\"fullTextCleanupTagAttr\":\"\",\"xssFiltering\":\"0\",\"linkPopupWidth\":\"900\",\"linkPopupHeight\":\"600\",\"imagesQuality\":\"100\",\"itemImageXS\":\"100\",\"itemImageS\":\"200\",\"itemImageM\":\"400\",\"itemImageL\":\"600\",\"itemImageXL\":\"900\",\"itemImageGeneric\":\"300\",\"catImageWidth\":\"100\",\"catImageDefault\":\"1\",\"userImageWidth\":\"100\",\"userImageDefault\":\"1\",\"commenterImgWidth\":\"48\",\"onlineImageEditor\":\"sumopaint\",\"imageTimestamp\":\"0\",\"imageMemoryLimit\":\"\",\"socialButtonCode\":\"\",\"twitterUsername\":\"\",\"facebookMetatags\":\"1\",\"facebookImage\":\"Medium\",\"comments\":\"1\",\"commentsOrdering\":\"DESC\",\"commentsLimit\":\"10\",\"commentsFormPosition\":\"below\",\"commentsPublishing\":\"0\",\"commentsReporting\":\"2\",\"commentsReportRecipient\":\"\",\"inlineCommentsModeration\":\"0\",\"gravatar\":\"1\",\"antispam\":\"0\",\"recaptchaForRegistered\":\"0\",\"akismetForRegistered\":\"0\",\"commentsFormNotes\":\"0\",\"commentsFormNotesText\":\"\",\"frontendEditing\":\"1\",\"showImageTab\":\"1\",\"showImageGalleryTab\":\"1\",\"showVideoTab\":\"1\",\"showExtraFieldsTab\":\"1\",\"showAttachmentsTab\":\"1\",\"showK2Plugins\":\"1\",\"sideBarDisplayFrontend\":\"0\",\"mergeEditors\":\"1\",\"sideBarDisplay\":\"1\",\"attachmentsFolder\":\"\",\"hideImportButton\":\"0\",\"googleSearch\":\"0\",\"googleSearchContainer\":\"k2GoogleSearchContainer\",\"K2UserProfile\":\"1\",\"redirect\":\"101\",\"adminSearch\":\"simple\",\"cookieDomain\":\"\",\"gatherStatistics\":\"1\",\"taggingSystem\":\"1\",\"lockTags\":\"0\",\"showTagFilter\":\"0\",\"k2TagNorm\":\"0\",\"k2TagNormCase\":\"lower\",\"k2TagNormAdditionalReplacements\":\"\",\"recaptcha_public_key\":\"\",\"recaptcha_private_key\":\"\",\"recaptcha_theme\":\"clean\",\"recaptchaV2\":\"1\",\"recaptchaOnRegistration\":\"0\",\"akismetApiKey\":\"\",\"stopForumSpam\":\"0\",\"stopForumSpamApiKey\":\"\",\"profilePageDisplay\":\"0\",\"showItemsCounterAdmin\":\"1\",\"showChildCatItems\":\"1\",\"disableCompactOrdering\":\"0\",\"metaDescLimit\":\"150\",\"enforceSEFReplacements\":\"0\",\"SEFReplacements\":\"\\u00c0|A, \\u00c1|A, \\u00c2|A, \\u00c3|A, \\u00c4|A, \\u00c5|A, \\u00e0|a, \\u00e1|a, \\u00e2|a, \\u00e3|a, \\u00e4|a, \\u00e5|a, \\u0100|A, \\u0101|a, \\u0102|A, \\u0103|a, \\u0104|A, \\u0105|a, \\u00c7|C, \\u00e7|c, \\u0106|C, \\u0107|c, \\u0108|C, \\u0109|c, \\u010a|C, \\u010b|c, \\u010c|C, \\u010d|c, \\u00d0|D, \\u00f0|d, \\u010e|D, \\u010f|d, \\u0110|D, \\u0111|d, \\u00c8|E, \\u00c9|E, \\u00ca|E, \\u00cb|E, \\u00e8|e, \\u00e9|e, \\u00ea|e, \\u00eb|e, \\u0112|E, \\u0113|e, \\u0114|E, \\u0115|e, \\u0116|E, \\u0117|e, \\u0118|E, \\u0119|e, \\u011a|E, \\u011b|e, \\u011c|G, \\u011d|g, \\u011e|G, \\u011f|g, \\u0120|G, \\u0121|g, \\u0122|G, \\u0123|g, \\u0124|H, \\u0125|h, \\u0126|H, \\u0127|h, \\u00cc|I, \\u00cd|I, \\u00ce|I, \\u00cf|I, \\u00ec|i, \\u00ed|i, \\u00ee|i, \\u00ef|i, \\u0128|I, \\u0129|i, \\u012a|I, \\u012b|i, \\u012c|I, \\u012d|i, \\u012e|I, \\u012f|i, \\u0130|I, \\u0131|i, \\u0134|J, \\u0135|j, \\u0136|K, \\u0137|k, \\u0138|k, \\u0139|L, \\u013a|l, \\u013b|L, \\u013c|l, \\u013d|L, \\u013e|l, \\u013f|L, \\u0140|l, \\u0141|L, \\u0142|l, \\u00d1|N, \\u00f1|n, \\u0143|N, \\u0144|n, \\u0145|N, \\u0146|n, \\u0147|N, \\u0148|n, \\u0149|n, \\u014a|N, \\u014b|n, \\u00d2|O, \\u00d3|O, \\u00d4|O, \\u00d5|O, \\u00d6|O, \\u00d8|O, \\u00f2|o, \\u00f3|o, \\u00f4|o, \\u00f5|o, \\u00f6|o, \\u00f8|o, \\u014c|O, \\u014d|o, \\u014e|O, \\u014f|o, \\u0150|O, \\u0151|o, \\u0154|R, \\u0155|r, \\u0156|R, \\u0157|r, \\u0158|R, \\u0159|r, \\u015a|S, \\u015b|s, \\u015c|S, \\u015d|s, \\u015e|S, \\u015f|s, \\u0160|S, \\u0161|s, \\u017f|s, \\u0162|T, \\u0163|t, \\u0164|T, \\u0165|t, \\u0166|T, \\u0167|t, \\u00d9|U, \\u00da|U, \\u00db|U, \\u00dc|U, \\u00f9|u, \\u00fa|u, \\u00fb|u, \\u00fc|u, \\u0168|U, \\u0169|u, \\u016a|U, \\u016b|u, \\u016c|U, \\u016d|u, \\u016e|U, \\u016f|u, \\u0170|U, \\u0171|u, \\u0172|U, \\u0173|u, \\u0174|W, \\u0175|w, \\u00dd|Y, \\u00fd|y, \\u00ff|y, \\u0176|Y, \\u0177|y, \\u0178|Y, \\u0179|Z, \\u017a|z, \\u017b|Z, \\u017c|z, \\u017d|Z, \\u017e|z, \\u03b1|a, \\u03b2|b, \\u03b3|g, \\u03b4|d, \\u03b5|e, \\u03b6|z, \\u03b7|h, \\u03b8|th, \\u03b9|i, \\u03ba|k, \\u03bb|l, \\u03bc|m, \\u03bd|n, \\u03be|x, \\u03bf|o, \\u03c0|p, \\u03c1|r, \\u03c3|s, \\u03c4|t, \\u03c5|y, \\u03c6|f, \\u03c7|ch, \\u03c8|ps, \\u03c9|w, \\u0391|A, \\u0392|B, \\u0393|G, \\u0394|D, \\u0395|E, \\u0396|Z, \\u0397|H, \\u0398|Th, \\u0399|I, \\u039a|K, \\u039b|L, \\u039c|M, \\u039e|X, \\u039f|O, \\u03a0|P, \\u03a1|R, \\u03a3|S, \\u03a4|T, \\u03a5|Y, \\u03a6|F, \\u03a7|Ch, \\u03a8|Ps, \\u03a9|W, \\u03ac|a, \\u03ad|e, \\u03ae|h, \\u03af|i, \\u03cc|o, \\u03cd|y, \\u03ce|w, \\u0386|A, \\u0388|E, \\u0389|H, \\u038a|I, \\u038c|O, \\u038e|Y, \\u038f|W, \\u03ca|i, \\u0390|i, \\u03cb|y, \\u03c2|s, \\u0410|A, \\u04d0|A, \\u04d2|A, \\u04d8|E, \\u04da|E, \\u04d4|E, \\u0411|B, \\u0412|V, \\u0413|G, \\u0490|G, \\u0403|G, \\u0492|G, \\u04f6|G, y|Y, \\u0414|D, \\u0415|E, \\u0400|E, \\u0401|YO, \\u04d6|E, \\u04bc|E, \\u04be|E, \\u0404|YE, \\u0416|ZH, \\u04c1|DZH, \\u0496|ZH, \\u04dc|DZH, \\u0417|Z, \\u0498|Z, \\u04de|DZ, \\u04e0|DZ, \\u0405|DZ, \\u0418|I, \\u040d|I, \\u04e4|I, \\u04e2|I, \\u0406|I, \\u0407|JI, \\u04c0|I, \\u0419|Y, \\u048a|Y, \\u0408|J, \\u041a|K, \\u049a|Q, \\u049e|Q, \\u04a0|K, \\u04c3|Q, \\u049c|K, \\u041b|L, \\u04c5|L, \\u0409|L, \\u041c|M, \\u04cd|M, \\u041d|N, \\u04c9|N, \\u04a2|N, \\u04c7|N, \\u04a4|N, \\u040a|N, \\u041e|O, \\u04e6|O, \\u04e8|O, \\u04ea|O, \\u04a8|O, \\u041f|P, \\u04a6|PF, \\u0420|P, \\u048e|P, \\u0421|S, \\u04aa|S, \\u0422|T, \\u04ac|TH, \\u040b|T, \\u040c|K, \\u0423|U, \\u040e|U, \\u04f2|U, \\u04f0|U, \\u04ee|U, \\u04ae|U, \\u04b0|U, \\u0424|F, \\u0425|H, \\u04b2|H, \\u04ba|H, \\u0426|TS, \\u04b4|TS, \\u0427|CH, \\u04f4|CH, \\u04b6|CH, \\u04cb|CH, \\u04b8|CH, \\u040f|DZ, \\u0428|SH, \\u0429|SHT, \\u042a|A, \\u042b|Y, \\u04f8|Y, \\u042c|Y, \\u048c|Y, \\u042d|E, \\u04ec|E, \\u042e|YU, \\u042f|YA, \\u0430|a, \\u04d1|a, \\u04d3|a, \\u04d9|e, \\u04db|e, \\u04d5|e, \\u0431|b, \\u0432|v, \\u0433|g, \\u0491|g, \\u0453|g, \\u0493|g, \\u04f7|g, y|y, \\u0434|d, \\u0435|e, \\u0450|e, \\u0451|yo, \\u04d7|e, \\u04bd|e, \\u04bf|e, \\u0454|ye, \\u0436|zh, \\u04c2|dzh, \\u0497|zh, \\u04dd|dzh, \\u0437|z, \\u0499|z, \\u04df|dz, \\u04e1|dz, \\u0455|dz, \\u0438|i, \\u045d|i, \\u04e5|i, \\u04e3|i, \\u0456|i, \\u0457|ji, \\u04c0|i, \\u0439|y, \\u048b|y, \\u0458|j, \\u043a|k, \\u049b|q, \\u049f|q, \\u04a1|k, \\u04c4|q, \\u049d|k, \\u043b|l, \\u04c6|l, \\u0459|l, \\u043c|m, \\u04ce|m, \\u043d|n, \\u04ca|n, \\u04a3|n, \\u04c8|n, \\u04a5|n, \\u045a|n, \\u043e|o, \\u04e7|o, \\u04e9|o, \\u04eb|o, \\u04a9|o, \\u043f|p, \\u04a7|pf, \\u0440|p, \\u048f|p, \\u0441|s, \\u04ab|s, \\u0442|t, \\u04ad|th, \\u045b|t, \\u045c|k, \\u0443|u, \\u045e|u, \\u04f3|u, \\u04f1|u, \\u04ef|u, \\u04af|u, \\u04b1|u, \\u0444|f, \\u0445|h, \\u04b3|h, \\u04bb|h, \\u0446|ts, \\u04b5|ts, \\u0447|ch, \\u04f5|ch, \\u04b7|ch, \\u04cc|ch, \\u04b9|ch, \\u045f|dz, \\u0448|sh, \\u0449|sht, \\u044a|a, \\u044b|y, \\u04f9|y, \\u044c|y, \\u048d|y, \\u044d|e, \\u04ed|e, \\u044e|yu, \\u044f|ya\",\"k2Sef\":\"0\",\"k2SefLabelCat\":\"content\",\"k2SefLabelTag\":\"tag\",\"k2SefLabelUser\":\"author\",\"k2SefLabelSearch\":\"search\",\"k2SefLabelDate\":\"date\",\"k2SefLabelItem\":\"0\",\"k2SefLabelItemCustomPrefix\":\"\",\"k2SefInsertItemId\":\"1\",\"k2SefItemIdTitleAliasSep\":\"dash\",\"k2SefUseItemTitleAlias\":\"1\",\"k2SefInsertCatId\":\"1\",\"k2SefCatIdTitleAliasSep\":\"dash\",\"k2SefUseCatTitleAlias\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10053', '0', 'plg_finder_k2', 'plugin', 'k2', 'finder', '0', '0', '1', '0', '{\"name\":\"plg_finder_k2\",\"type\":\"plugin\",\"creationDate\":\"August 18th, 2017\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2017 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.8.0\",\"description\":\"PLG_FINDER_K2_DESCRIPTION\",\"group\":\"\",\"filename\":\"k2\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10054', '0', 'Search - K2', 'plugin', 'k2', 'search', '0', '1', '1', '0', '{\"name\":\"Search - K2\",\"type\":\"plugin\",\"creationDate\":\"August 18th, 2017\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2017 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.8.0\",\"description\":\"K2_THIS_PLUGIN_EXTENDS_THE_DEFAULT_JOOMLA_SEARCH_FUNCTIONALITY_TO_K2_CONTENT\",\"group\":\"\",\"filename\":\"k2\"}', '{\"search_limit\":\"50\",\"search_tags\":\"0\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10055', '0', 'System - K2', 'plugin', 'k2', 'system', '0', '1', '1', '0', '{\"name\":\"System - K2\",\"type\":\"plugin\",\"creationDate\":\"August 18th, 2017\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2017 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.8.0\",\"description\":\"K2_THE_K2_SYSTEM_PLUGIN_IS_USED_TO_ASSIST_THE_PROPER_FUNCTIONALITY_OF_THE_K2_COMPONENT_SITE_WIDE_MAKE_SURE_ITS_ALWAYS_PUBLISHED_WHEN_THE_K2_COMPONENT_IS_INSTALLED\",\"group\":\"\",\"filename\":\"k2\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10056', '0', 'User - K2', 'plugin', 'k2', 'user', '0', '1', '1', '0', '{\"name\":\"User - K2\",\"type\":\"plugin\",\"creationDate\":\"August 18th, 2017\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2017 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.8.0\",\"description\":\"K2_A_USER_SYNCHRONIZATION_PLUGIN_FOR_K2\",\"group\":\"\",\"filename\":\"k2\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10057', '0', 'K2 Comments', 'module', 'mod_k2_comments', '', '0', '1', '0', '0', '{\"name\":\"K2 Comments\",\"type\":\"module\",\"creationDate\":\"August 18th, 2017\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2017 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.8.0\",\"description\":\"MOD_K2_COMMENTS_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_k2_comments.j25\"}', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"\",\"\":\"K2_TOP_COMMENTERS\",\"catfilter\":\"0\",\"category_id\":\"\",\"comments_limit\":\"5\",\"comments_word_limit\":\"10\",\"commenterName\":\"1\",\"commentAvatar\":\"1\",\"commentAvatarWidthSelect\":\"custom\",\"commentAvatarWidth\":\"50\",\"commentDate\":\"1\",\"commentDateFormat\":\"absolute\",\"commentLink\":\"1\",\"itemTitle\":\"1\",\"itemCategory\":\"1\",\"feed\":\"1\",\"commenters_limit\":\"5\",\"commenterNameOrUsername\":\"1\",\"commenterAvatar\":\"1\",\"commenterAvatarWidthSelect\":\"custom\",\"commenterAvatarWidth\":\"50\",\"commenterLink\":\"1\",\"commenterCommentsCounter\":\"1\",\"commenterLatestComment\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10058', '0', 'K2 Content', 'module', 'mod_k2_content', '', '0', '1', '0', '0', '{\"name\":\"K2 Content\",\"type\":\"module\",\"creationDate\":\"August 18th, 2017\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2017 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.8.0\",\"description\":\"K2_MOD_K2_CONTENT_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_k2_content.j25\"}', '{\"moduleclass_sfx\":\"\",\"getTemplate\":\"Default\",\"source\":\"filter\",\"\":\"K2_OTHER_OPTIONS\",\"catfilter\":\"0\",\"category_id\":\"\",\"getChildren\":\"0\",\"itemCount\":\"5\",\"itemsOrdering\":\"\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"\",\"items\":\"\",\"itemTitle\":\"1\",\"itemAuthor\":\"1\",\"itemAuthorAvatar\":\"1\",\"itemAuthorAvatarWidthSelect\":\"custom\",\"itemAuthorAvatarWidth\":\"50\",\"userDescription\":\"1\",\"itemIntroText\":\"1\",\"itemIntroTextWordLimit\":\"\",\"itemImage\":\"1\",\"itemImgSize\":\"Small\",\"itemVideo\":\"1\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemAttachments\":\"1\",\"itemTags\":\"1\",\"itemCategory\":\"1\",\"itemDateCreated\":\"1\",\"itemHits\":\"1\",\"itemReadMore\":\"1\",\"itemExtraFields\":\"0\",\"itemCommentsCounter\":\"1\",\"feed\":\"1\",\"itemPreText\":\"\",\"itemCustomLink\":\"0\",\"itemCustomLinkTitle\":\"\",\"itemCustomLinkURL\":\"http:\\/\\/\",\"itemCustomLinkMenuItem\":\"\",\"K2Plugins\":\"1\",\"JPlugins\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10059', '0', 'K2 Tools', 'module', 'mod_k2_tools', '', '0', '1', '0', '0', '{\"name\":\"K2 Tools\",\"type\":\"module\",\"creationDate\":\"August 18th, 2017\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2017 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.8.0\",\"description\":\"K2_TOOLS\",\"group\":\"\",\"filename\":\"mod_k2_tools.j25\"}', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"0\",\"\":\"K2_CUSTOM_CODE_SETTINGS\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"\",\"authors_module_category\":\"\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"\",\"catfilter\":\"0\",\"category_id\":\"\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"searchItemId\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":\"0\",\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10060', '0', 'K2 Users', 'module', 'mod_k2_users', '', '0', '1', '0', '0', '{\"name\":\"K2 Users\",\"type\":\"module\",\"creationDate\":\"August 18th, 2017\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2017 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.8.0\",\"description\":\"K2_MOD_K2_USERS_DESCRTIPTION\",\"group\":\"\",\"filename\":\"mod_k2_users.j25\"}', '{\"moduleclass_sfx\":\"\",\"getTemplate\":\"Default\",\"source\":\"0\",\"\":\"K2_DISPLAY_OPTIONS\",\"filter\":\"1\",\"K2UserGroup\":\"\",\"ordering\":\"1\",\"limit\":\"4\",\"userIDs\":\"\",\"userName\":\"1\",\"userAvatar\":\"1\",\"userAvatarWidthSelect\":\"custom\",\"userAvatarWidth\":\"50\",\"userDescription\":\"1\",\"userDescriptionWordLimit\":\"\",\"userURL\":\"1\",\"userEmail\":\"0\",\"userFeed\":\"1\",\"userItemCount\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10061', '0', 'K2 User', 'module', 'mod_k2_user', '', '0', '1', '0', '0', '{\"name\":\"K2 User\",\"type\":\"module\",\"creationDate\":\"August 18th, 2017\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2017 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.8.0\",\"description\":\"K2_MOD_K2_USER_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_k2_user.j25\"}', '{\"moduleclass_sfx\":\"\",\"pretext\":\"\",\"\":\"K2_LOGIN_LOGOUT_REDIRECTION\",\"name\":\"1\",\"userAvatar\":\"1\",\"userAvatarWidthSelect\":\"custom\",\"userAvatarWidth\":\"50\",\"menu\":\"\",\"login\":\"\",\"logout\":\"\",\"usesecure\":\"0\",\"cache\":\"0\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10062', '0', 'K2 Quick Icons (admin)', 'module', 'mod_k2_quickicons', '', '1', '1', '2', '0', '{\"name\":\"K2 Quick Icons (admin)\",\"type\":\"module\",\"creationDate\":\"August 18th, 2017\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2017 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.8.0\",\"description\":\"K2_QUICKICONS_FOR_USE_IN_THE_JOOMLA_CONTROL_PANEL_DASHBOARD_PAGE\",\"group\":\"\",\"filename\":\"mod_k2_quickicons.j25\"}', '{\"modCSSStyling\":\"1\",\"modLogo\":\"1\",\"cache\":\"0\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10063', '0', 'K2 Stats (admin)', 'module', 'mod_k2_stats', '', '1', '1', '2', '0', '{\"name\":\"K2 Stats (admin)\",\"type\":\"module\",\"creationDate\":\"August 18th, 2017\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2017 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.8.0\",\"description\":\"K2_STATS_FOR_USE_IN_THE_K2_DASHBOARD_PAGE\",\"group\":\"\",\"filename\":\"mod_k2_stats.j25\"}', '{\"latestItems\":\"1\",\"popularItems\":\"1\",\"mostCommentedItems\":\"1\",\"latestComments\":\"1\",\"statistics\":\"1\",\"cache\":\"0\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10064', '0', 'SP Simple Portfolio', 'component', 'com_spsimpleportfolio', '', '1', '1', '0', '0', '{\"name\":\"SP Simple Portfolio\",\"type\":\"component\",\"creationDate\":\"December 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (c) 2010- 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"1.5\",\"description\":\"Simple Portfolio Component for Joomla 3.3+\",\"group\":\"\",\"filename\":\"spsimpleportfolio\"}', '{\"quare\":\"570x535\",\"rectangle\":\"270x235\",\"tall\":\"600X800\",\"cropratio\":\"4\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10065', '0', 'SP Simple Portfolio Module', 'module', 'mod_spsimpleportfolio', '', '0', '1', '0', '0', '{\"name\":\"SP Simple Portfolio Module\",\"type\":\"module\",\"creationDate\":\"December 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.4\",\"description\":\"Module to display latest item from SP Simple Portfolio\",\"group\":\"\",\"filename\":\"mod_spsimpleportfolio\"}', '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"masonry\",\"limit\":\"12\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10066', '0', 'mod_j2products', 'module', 'mod_j2products', '', '0', '1', '0', '0', '{\"name\":\"mod_j2products\",\"type\":\"module\",\"creationDate\":\"FEB 2017\",\"author\":\"J2Store\",\"copyright\":\"Copyright (C) 2017 J2Store.org. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.20\",\"description\":\"MOD_J2PRODUCTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_j2products\"}', '{\"content_integration\":\"joomla\",\"sort_by\":\"\",\"include_subcategories\":\"1\",\"include_subcat_level\":\"0\",\"number_of_coloums\":\"3\",\"number_of_coloums_Desktop\":\"3\",\"number_of_coloums_DesktopSmall\":\"3\",\"number_of_coloums_Tablet\":\"3\",\"number_of_coloums_TabletSmall\":\"2\",\"number_of_coloums_Mobile\":\"1\",\"show_navigation\":\"0\",\"number_of_items\":\"6\",\"show_feature_only\":\"0\",\"show_title\":\"1\",\"link_title\":\"1\",\"show_price\":\"1\",\"show_price_taxinfo\":\"1\",\"show_special_price\":\"1\",\"show_offers\":\"1\",\"show_stock\":\"0\",\"show_beforedisplaycontent\":\"1\",\"show_afterdisplaycontent\":\"1\",\"list_show_cart\":\"2\",\"show_introtext\":\"0\",\"introtext_limit\":\"50\",\"show_quickview\":\"0\",\"show_image\":\"1\",\"link_image\":\"1\",\"image_type\":\"thumbimage\",\"image_size_width\":\"80\",\"image_size_height\":\"80\",\"image_position\":\"top\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10067', '0', 'J2Store Categories', 'module', 'mod_j2store_categories', '', '0', '1', '0', '0', '{\"name\":\"J2Store Categories\",\"type\":\"module\",\"creationDate\":\"JULY 2016\",\"author\":\"Gokila Priya\",\"copyright\":\"Copyright (C) 2016 ThemeParrot. All rights reserved.\",\"authorEmail\":\"support@themeparrot.com\",\"authorUrl\":\"www.themeparrot.com\",\"version\":\"1.5\",\"description\":\"MOD_J2STORE_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_j2store_categories\"}', '{\"menuitem_id\":\"0\",\"show_description\":\"0\",\"numitems\":\"0\",\"browse_link\":\"1\",\"show_children\":\"0\",\"count\":\"0\",\"maxlevel\":\"0\",\"show_image\":\"1\",\"item_heading\":\"4\",\"owncache\":\"1\",\"cache_time\":\"900\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10068', '0', 'Social Media', 'plugin', 'app_socialmedia', 'j2store', '0', '0', '1', '0', '{\"name\":\"Social Media\",\"type\":\"plugin\",\"creationDate\":\"MARCH 2017\",\"author\":\"Sasi varna kumar\",\"copyright\":\"2017 J2Store\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"http:\\/\\/www.j2store.org\",\"version\":\"1.4\",\"description\":\"PLG_J2STORE_APP_SOCIAL_MEDIA_DESC\",\"group\":\"\",\"filename\":\"app_socialmedia\"}', '{\"show_facebook_icon\":\"1\",\"show_twitter_icon\":\"1\",\"show_google_plus_icon\":\"1\",\"show_linkedin_icon\":\"1\",\"show_pinterest_icon\":\"1\",\"socialmedia_image_width\":\"30\",\"socialmedia_share_text\":\"PLG_J2STORE_APP_SOCIALMEDIA_CHECKOUT\",\"include_price\":\"1\",\"twitter_meta_tags\":\"1\",\"twitter_product_image_width\":\"50\",\"twitter_product_description_limit\":\"50\",\"twitter_summary_card_type\":\"summary\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10069', '0', 'Display quantity discounts', 'plugin', 'app_qtydiscount', 'j2store', '0', '0', '1', '0', '{\"name\":\"Display quantity discounts\",\"type\":\"plugin\",\"creationDate\":\"June 2015\",\"author\":\"Gokila Priya\",\"copyright\":\"2015 Weblogicx India\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"http:\\/\\/www.j2store.org\",\"version\":\"1.1\",\"description\":\"PLG_J2STORE_APP_QTY_DISCOUNT_DESC\",\"group\":\"\",\"filename\":\"app_qtydiscount\"}', '[]', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10070', '0', 'J2Store Products search module ', 'module', 'mod_j2store_search', '', '0', '1', '0', '0', '{\"name\":\"J2Store Products search module \",\"type\":\"module\",\"creationDate\":\"JAN 2017\",\"author\":\"Gokila Priya\",\"copyright\":\"Copyright (c) 2017 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.6\",\"description\":\"MOD_J2STORE_SEARCH\",\"group\":\"\",\"filename\":\"mod_j2store_search\"}', '{\"moduleclass_sfx\":\"\",\"show_label\":\"1\"}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10072', '0', 'F0F (NEW) DO NOT REMOVE', 'library', 'lib_f0f', '', '0', '1', '1', '0', '{\"name\":\"F0F (NEW) DO NOT REMOVE\",\"type\":\"library\",\"creationDate\":\"2016-04-01\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2011-2014 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"revAA17947\",\"description\":\"Framework-on-Framework (FOF) newer version - DO NOT REMOVE - The rapid component development framework for Joomla!. This package is the newer version of FOF, not the one shipped with Joomla! as the official Joomla! RAD Layer. The Joomla! RAD Layer has ceased development in March 2014. DO NOT UNINSTALL THIS PACKAGE, IT IS *** N O T *** A DUPLICATE OF THE \'FOF\' PACKAGE. REMOVING EITHER FOF PACKAGE WILL BREAK YOUR SITE.\",\"group\":\"\",\"filename\":\"lib_f0f\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10073', '10075', 'ArabicUnitag', 'language', 'ar-AA', '', '0', '1', '0', '0', '{\"name\":\"Arabic Unitag (\\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629)\",\"type\":\"language\",\"creationDate\":\"22\\/08\\/2017\",\"author\":\"Ashraf Damra\",\"copyright\":\"Joomla! in Arabic\",\"authorEmail\":\"dr.d.ashraf@gmail.com\",\"authorUrl\":\"https:\\/\\/www.jarabic.com\\/\",\"version\":\"3.7.5.1\",\"description\":\"ar-AA - Site language\",\"group\":\"\",\"filename\":\"install\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10074', '10075', 'ArabicUnitag', 'language', 'ar-AA', '', '1', '1', '0', '0', '{\"name\":\"Arabic Unitag (\\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629)\",\"type\":\"language\",\"creationDate\":\"22\\/08\\/2017\",\"author\":\"Ashraf Damra\",\"copyright\":\"Joomla! in Arabic\",\"authorEmail\":\"dr.d.ashraf@gmail.com\",\"authorUrl\":\"https:\\/\\/www.jarabic.com\\/\",\"version\":\"3.7.5.1\",\"description\":\"ar-AA - Administration language\",\"group\":\"\",\"filename\":\"install\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10075', '0', 'Arabic', 'package', 'pkg_ar-AA', '', '0', '1', '1', '0', '{\"name\":\"Arabic\",\"type\":\"package\",\"creationDate\":\"22\\/08\\/2017\",\"author\":\"Ashraf Damra\",\"copyright\":\"Joomla! in Arabic\",\"authorEmail\":\"dr.d.ashraf@gmail.com\",\"authorUrl\":\"https:\\/\\/www.jarabic.com\\/\",\"version\":\"3.7.5.1\",\"description\":\"<h3>\\u062d\\u0632\\u0645\\u0629 \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629 \\u0644\\u0646\\u0638\\u0627\\u0645 \\u062c\\u0648\\u0645\\u0644\\u0627! 3.7.5 \\u0627\\u0644\\u0627\\u0635\\u062f\\u0627\\u0631 1<\\/h3>\",\"group\":\"\",\"filename\":\"pkg_ar-AA\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0'), ('10077', '0', 'FOF30', 'library', 'lib_fof30', '', '0', '1', '1', '0', '{\"name\":\"FOF30\",\"type\":\"library\",\"creationDate\":\"2017-09-12\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2010-2017 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"3.1.3\",\"description\":\"\\n\\t\\t\\n\\t\\tFramework-on-Framework (FOF) 3.x - The rapid application development framework for Joomla!.<br\\/>\\n\\t\\t<b>WARNING<\\/b>: This is NOT a duplicate of the FOF library already installed with Joomla!. It is a different version used by other extensions on your site. Do NOT uninstall either FOF package. If you do you will break your site.\\n\\t\\t\\n\\t\",\"group\":\"\",\"filename\":\"lib_fof30\"}', '{}', '', '', '0', '0000-00-00 00:00:00', '0', '0');
CREATE TABLE `#__fields` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `asset_id` int(10) unsigned NOT NULL DEFAULT '0',   `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `group_id` int(10) unsigned NOT NULL DEFAULT '0',   `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `default_value` text COLLATE utf8mb4_unicode_ci NOT NULL,   `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',   `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `description` text COLLATE utf8mb4_unicode_ci NOT NULL,   `state` tinyint(1) NOT NULL DEFAULT '0',   `required` tinyint(1) NOT NULL DEFAULT '0',   `checked_out` int(11) NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) NOT NULL DEFAULT '0',   `params` text COLLATE utf8mb4_unicode_ci NOT NULL,   `fieldparams` text COLLATE utf8mb4_unicode_ci NOT NULL,   `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',   `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(10) unsigned NOT NULL DEFAULT '0',   `access` int(11) NOT NULL DEFAULT '1',   PRIMARY KEY (`id`),   KEY `idx_checkout` (`checked_out`),   KEY `idx_state` (`state`),   KEY `idx_created_user_id` (`created_user_id`),   KEY `idx_access` (`access`),   KEY `idx_context` (`context`(191)),   KEY `idx_language` (`language`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE `#__fields_categories` (   `field_id` int(11) NOT NULL DEFAULT '0',   `category_id` int(11) NOT NULL DEFAULT '0',   PRIMARY KEY (`field_id`,`category_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE `#__fields_groups` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `asset_id` int(10) unsigned NOT NULL DEFAULT '0',   `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `description` text COLLATE utf8mb4_unicode_ci NOT NULL,   `state` tinyint(1) NOT NULL DEFAULT '0',   `checked_out` int(11) NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `ordering` int(11) NOT NULL DEFAULT '0',   `params` text COLLATE utf8mb4_unicode_ci NOT NULL,   `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created_by` int(10) unsigned NOT NULL DEFAULT '0',   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(10) unsigned NOT NULL DEFAULT '0',   `access` int(11) NOT NULL DEFAULT '1',   PRIMARY KEY (`id`),   KEY `idx_checkout` (`checked_out`),   KEY `idx_state` (`state`),   KEY `idx_created_by` (`created_by`),   KEY `idx_access` (`access`),   KEY `idx_context` (`context`(191)),   KEY `idx_language` (`language`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE `#__fields_values` (   `field_id` int(10) unsigned NOT NULL,   `item_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',   `value` text COLLATE utf8mb4_unicode_ci NOT NULL,   KEY `idx_field_id` (`field_id`),   KEY `idx_item_id` (`item_id`(191)) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
CREATE TABLE `#__finder_filters` (   `filter_id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `title` varchar(255) NOT NULL,   `alias` varchar(255) NOT NULL,   `state` tinyint(1) NOT NULL DEFAULT '1',   `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `created_by` int(10) unsigned NOT NULL,   `created_by_alias` varchar(255) NOT NULL,   `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `modified_by` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out` int(10) unsigned NOT NULL DEFAULT '0',   `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `map_count` int(10) unsigned NOT NULL DEFAULT '0',   `data` text NOT NULL,   `params` mediumtext,   PRIMARY KEY (`filter_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_links` (   `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `url` varchar(255) NOT NULL,   `route` varchar(255) NOT NULL,   `title` varchar(400) DEFAULT NULL,   `description` text,   `indexdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `md5sum` varchar(32) DEFAULT NULL,   `published` tinyint(1) NOT NULL DEFAULT '1',   `state` int(5) DEFAULT '1',   `access` int(5) DEFAULT '0',   `language` varchar(8) NOT NULL,   `publish_start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `publish_end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',   `list_price` double unsigned NOT NULL DEFAULT '0',   `sale_price` double unsigned NOT NULL DEFAULT '0',   `type_id` int(11) NOT NULL,   `object` mediumblob NOT NULL,   PRIMARY KEY (`link_id`),   KEY `idx_type` (`type_id`),   KEY `idx_title` (`title`(100)),   KEY `idx_md5` (`md5sum`),   KEY `idx_url` (`url`(75)),   KEY `idx_published_list` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`list_price`),   KEY `idx_published_sale` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`sale_price`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_links_terms0` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_links_terms1` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_links_terms2` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_links_terms3` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_links_terms4` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_links_terms5` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_links_terms6` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_links_terms7` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_links_terms8` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_links_terms9` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_links_termsa` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_links_termsb` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_links_termsc` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_links_termsd` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_links_termse` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_links_termsf` (   `link_id` int(10) unsigned NOT NULL,   `term_id` int(10) unsigned NOT NULL,   `weight` float unsigned NOT NULL,   PRIMARY KEY (`link_id`,`term_id`),   KEY `idx_term_weight` (`term_id`,`weight`),   KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_taxonomy` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `parent_id` int(10) unsigned NOT NULL DEFAULT '0',   `title` varchar(255) NOT NULL,   `state` tinyint(1) unsigned NOT NULL DEFAULT '1',   `access` tinyint(1) unsigned NOT NULL DEFAULT '0',   `ordering` tinyint(1) unsigned NOT NULL DEFAULT '0',   PRIMARY KEY (`id`),   KEY `parent_id` (`parent_id`),   KEY `state` (`state`),   KEY `ordering` (`ordering`),   KEY `access` (`access`),   KEY `idx_parent_published` (`parent_id`,`state`,`access`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_taxonomy_map` (   `link_id` int(10) unsigned NOT NULL,   `node_id` int(10) unsigned NOT NULL,   PRIMARY KEY (`link_id`,`node_id`),   KEY `link_id` (`link_id`),   KEY `node_id` (`node_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_terms` (   `term_id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `term` varchar(75) NOT NULL,   `stem` varchar(75) NOT NULL,   `common` tinyint(1) unsigned NOT NULL DEFAULT '0',   `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',   `weight` float unsigned NOT NULL DEFAULT '0',   `soundex` varchar(75) NOT NULL,   `links` int(10) NOT NULL DEFAULT '0',   `language` char(3) NOT NULL DEFAULT '',   PRIMARY KEY (`term_id`),   UNIQUE KEY `idx_term` (`term`),   KEY `idx_term_phrase` (`term`,`phrase`),   KEY `idx_stem_phrase` (`stem`,`phrase`),   KEY `idx_soundex_phrase` (`soundex`,`phrase`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_terms_common` (   `term` varchar(75) NOT NULL,   `language` varchar(3) NOT NULL,   KEY `idx_word_lang` (`term`,`language`),   KEY `idx_lang` (`language`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
INSERT INTO `#__finder_terms_common`  VALUES ('a', 'en'), ('about', 'en'), ('after', 'en'), ('ago', 'en'), ('all', 'en'), ('am', 'en'), ('an', 'en'), ('and', 'en'), ('ani', 'en'), ('any', 'en'), ('are', 'en'), ('aren\'t', 'en'), ('as', 'en'), ('at', 'en'), ('be', 'en'), ('but', 'en'), ('by', 'en'), ('for', 'en'), ('from', 'en'), ('get', 'en'), ('go', 'en'), ('how', 'en'), ('if', 'en'), ('in', 'en'), ('into', 'en'), ('is', 'en'), ('isn\'t', 'en'), ('it', 'en'), ('its', 'en'), ('me', 'en'), ('more', 'en'), ('most', 'en'), ('must', 'en'), ('my', 'en'), ('new', 'en'), ('no', 'en'), ('none', 'en'), ('not', 'en'), ('noth', 'en'), ('nothing', 'en'), ('of', 'en'), ('off', 'en'), ('often', 'en'), ('old', 'en'), ('on', 'en'), ('onc', 'en'), ('once', 'en'), ('onli', 'en'), ('only', 'en'), ('or', 'en'), ('other', 'en'), ('our', 'en'), ('ours', 'en'), ('out', 'en'), ('over', 'en'), ('page', 'en'), ('she', 'en'), ('should', 'en'), ('small', 'en'), ('so', 'en'), ('some', 'en'), ('than', 'en'), ('thank', 'en'), ('that', 'en'), ('the', 'en'), ('their', 'en'), ('theirs', 'en'), ('them', 'en'), ('then', 'en'), ('there', 'en'), ('these', 'en'), ('they', 'en'), ('this', 'en'), ('those', 'en'), ('thus', 'en'), ('time', 'en'), ('times', 'en'), ('to', 'en'), ('too', 'en'), ('true', 'en'), ('under', 'en'), ('until', 'en'), ('up', 'en'), ('upon', 'en'), ('use', 'en'), ('user', 'en'), ('users', 'en'), ('veri', 'en'), ('version', 'en'), ('very', 'en'), ('via', 'en'), ('want', 'en'), ('was', 'en'), ('way', 'en'), ('were', 'en'), ('what', 'en'), ('when', 'en'), ('where', 'en'), ('whi', 'en'), ('which', 'en'), ('who', 'en'), ('whom', 'en'), ('whose', 'en'), ('why', 'en'), ('wide', 'en'), ('will', 'en'), ('with', 'en'), ('within', 'en'), ('without', 'en'), ('would', 'en'), ('yes', 'en'), ('yet', 'en'), ('you', 'en'), ('your', 'en'), ('yours', 'en');
CREATE TABLE `#__finder_tokens` (   `term` varchar(75) NOT NULL,   `stem` varchar(75) NOT NULL,   `common` tinyint(1) unsigned NOT NULL DEFAULT '0',   `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',   `weight` float unsigned NOT NULL DEFAULT '1',   `context` tinyint(1) unsigned NOT NULL DEFAULT '2',   `language` char(3) NOT NULL DEFAULT '',   KEY `idx_word` (`term`),   KEY `idx_context` (`context`) ) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_tokens_aggregate` (   `term_id` int(10) unsigned NOT NULL,   `map_suffix` char(1) NOT NULL,   `term` varchar(75) NOT NULL,   `stem` varchar(75) NOT NULL,   `common` tinyint(1) unsigned NOT NULL DEFAULT '0',   `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',   `term_weight` float unsigned NOT NULL,   `context` tinyint(1) unsigned NOT NULL DEFAULT '2',   `context_weight` float unsigned NOT NULL,   `total_weight` float unsigned NOT NULL,   `language` char(3) NOT NULL DEFAULT '',   KEY `token` (`term`),   KEY `keyword_id` (`term_id`) ) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4;
CREATE TABLE `#__finder_types` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `title` varchar(100) NOT NULL,   `mime` varchar(100) NOT NULL,   PRIMARY KEY (`id`),   UNIQUE KEY `title` (`title`) ) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4;
INSERT INTO `#__finder_types`  VALUES ('1', 'Tag', ''), ('2', 'Category', ''), ('3', 'Contact', ''), ('4', 'Article', ''), ('5', 'News Feed', '');
CREATE TABLE `#__j2store_addresses` (   `j2store_address_id` int(11) NOT NULL AUTO_INCREMENT,   `user_id` int(11) NOT NULL,   `first_name` varchar(255) NOT NULL,   `last_name` varchar(255) NOT NULL,   `email` varchar(255) NOT NULL,   `address_1` varchar(255) NOT NULL,   `address_2` varchar(255) NOT NULL,   `city` varchar(255) NOT NULL,   `zip` varchar(255) NOT NULL,   `zone_id` varchar(255) NOT NULL,   `country_id` varchar(255) NOT NULL,   `phone_1` varchar(255) NOT NULL,   `phone_2` varchar(255) NOT NULL,   `fax` varchar(255) NOT NULL,   `type` varchar(255) NOT NULL,   `company` varchar(255) NOT NULL,   `tax_number` varchar(255) NOT NULL,   PRIMARY KEY (`j2store_address_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `#__j2store_cartitems` (   `j2store_cartitem_id` int(11) unsigned NOT NULL AUTO_INCREMENT,   `cart_id` int(11) unsigned NOT NULL,   `product_id` int(11) unsigned NOT NULL,   `variant_id` int(11) unsigned NOT NULL,   `vendor_id` int(11) unsigned NOT NULL,   `product_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,   `cartitem_params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,   `product_qty` decimal(12,4) NOT NULL,   `product_options` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,   PRIMARY KEY (`j2store_cartitem_id`),   KEY `cart_id` (`cart_id`),   KEY `product_id` (`product_id`),   KEY `variant_id` (`variant_id`) ) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `#__j2store_cartitems`  VALUES ('1', '159', '2', '2', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('2', '881', '1', '1', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('3', '888', '1', '1', '0', 'simple', '{}', '5.0000', 'YTowOnt9'), ('4', '952', '4', '4', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('5', '969', '1', '1', '0', 'simple', '{}', '2.0000', 'YTowOnt9'), ('6', '1023', '1', '1', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('7', '1027', '10', '10', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('8', '1037', '2', '2', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('9', '1040', '1', '1', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('10', '1183', '11', '11', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('11', '1340', '2', '2', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('12', '1827', '4', '4', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('13', '1913', '1', '1', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('14', '1917', '3', '3', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('15', '1973', '2', '2', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('17', '2069', '7', '7', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('18', '2138', '10', '10', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('19', '2180', '2', '2', '0', 'simple', '{}', '3.0000', 'YTowOnt9'), ('20', '2180', '7', '7', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('21', '2180', '6', '6', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('22', '2209', '8', '8', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('23', '2224', '1', '1', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('24', '2234', '1', '1', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('25', '2236', '2', '2', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('26', '2242', '2', '2', '0', 'simple', '{}', '1.0000', 'YTowOnt9'), ('27', '2279', '5', '5', '0', 'simple', '{}', '1.0000', 'YTowOnt9');
CREATE TABLE `#__j2store_carts` (   `j2store_cart_id` int(11) NOT NULL AUTO_INCREMENT,   `user_id` int(11) NOT NULL,   `session_id` varchar(255) NOT NULL,   `cart_voucher` varchar(255) DEFAULT NULL,   `cart_coupon` varchar(255) DEFAULT NULL,   `cart_type` varchar(255) NOT NULL DEFAULT 'cart',   `created_on` datetime NOT NULL,   `modified_on` datetime NOT NULL,   `customer_ip` varchar(255) NOT NULL,   `cart_params` text NOT NULL,   `cart_browser` text NOT NULL,   `cart_analytics` text NOT NULL,   PRIMARY KEY (`j2store_cart_id`),   KEY `session_id` (`session_id`),   KEY `user_id` (`user_id`) ) ENGINE=InnoDB AUTO_INCREMENT=2329 DEFAULT CHARSET=utf8;
INSERT INTO `#__j2store_carts`  VALUES ('1', '0', 'ukj53tv54t7e4pjkdc5avp5447', NULL, NULL, 'cart', '2017-03-22 01:06:24', '2017-03-22 01:21:45', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('2', '0', '0332lluck4cn4or3cna0hp9q55', NULL, NULL, 'cart', '2017-03-22 12:19:45', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('3', '0', '9mqji9rffp03vn5df2vn90s7i4', NULL, NULL, 'cart', '2017-03-22 13:24:36', '2017-03-22 17:44:39', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('4', '0', 'g8h9s9q3kl4es80v5hl6lclfa0', NULL, NULL, 'cart', '2017-03-22 23:06:28', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('5', '0', 'idntn7ks2nsbs19f01d2kgjmf3', NULL, NULL, 'cart', '2017-03-23 11:59:02', '2017-03-23 16:31:55', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('6', '0', 'ogvnikr9od8gs59r8nkvh71pu1', NULL, NULL, 'cart', '2017-03-23 22:48:56', '2017-03-24 01:31:57', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('7', '0', 'm92nr8ov1lm77691p66np4amt7', NULL, NULL, 'cart', '2017-03-24 01:32:07', '2017-03-24 01:38:20', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('8', '0', 'uj4j3f1609ubvcn2am76oes2c2', NULL, NULL, 'cart', '2017-03-24 18:01:45', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('9', '0', '1bjcdppik0m0vrhhnrctfbhna6', NULL, NULL, 'cart', '2017-03-24 23:01:14', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('10', '0', '7pj69gulj021pl4g4t9th7afs7', NULL, NULL, 'cart', '2017-03-25 14:56:58', '2017-03-25 15:30:18', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('11', '0', 't1h1r6i6jr0m8mfj2psuhpff36', NULL, NULL, 'cart', '2017-03-25 16:09:18', '2017-03-25 17:55:22', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('12', '0', 'hr5gn1976qdjvr3rms22oepdd5', NULL, NULL, 'cart', '2017-03-26 16:41:04', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('13', '0', 's6dqdn598e4v5qq253rrmi0607', NULL, NULL, 'cart', '2017-03-31 00:49:43', '2017-03-31 01:06:59', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('14', '0', 'sr8ubfdp35aeds90hrv43g26i1', NULL, NULL, 'cart', '2017-03-31 10:50:25', '2017-03-31 11:27:35', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('15', '0', 'bc1nojv7l6rgsto2at46er6c04', NULL, NULL, 'cart', '2017-03-31 22:57:22', '2017-04-01 00:02:57', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('16', '0', 'js6f8j2s406t95roete4rqba02', NULL, NULL, 'cart', '2017-04-01 13:28:56', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('17', '0', '4am5d3h8ek9lo8b8n5errco3l6', NULL, NULL, 'cart', '2017-04-01 17:16:04', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('18', '0', '8tp986g4ic328vds5ptlg53hb4', NULL, NULL, 'cart', '2017-04-01 22:58:47', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('19', '0', 'l3edv0vl7aidgocmg3je2v9sa4', NULL, NULL, 'cart', '2017-04-01 23:20:51', '2017-04-01 23:58:09', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('20', '0', '4vjcb5eoeg7nrnajgjvlls1194', NULL, NULL, 'cart', '2017-04-02 15:53:28', '2017-04-02 16:53:24', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('21', '0', 'nb9pdhqv2rl42esrejui8hel00', NULL, NULL, 'cart', '2017-04-02 23:07:19', '2017-04-03 00:36:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('22', '0', 'dqlkt7can91kf79eqsev2lqff5', NULL, NULL, 'cart', '2017-04-03 14:59:20', '2017-04-03 15:40:51', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('23', '0', 'lc17p0snnce8c82dukjitt83i5', NULL, NULL, 'cart', '2017-04-03 16:22:54', '2017-04-03 17:06:04', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('24', '0', '4tbmevrgr8elnuob13ksud6654', NULL, NULL, 'cart', '2017-04-03 22:14:58', '2017-04-03 23:29:55', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('25', '0', 'ekgq3bnasmqo165vh16fh8va54', NULL, NULL, 'cart', '2017-04-04 11:03:07', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('26', '0', 'v1b77vt5k13uscnieldtu6df93', NULL, NULL, 'cart', '2017-04-04 12:42:40', '2017-04-04 15:03:28', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('27', '0', 'nnk88n738991ec0j11o24crld5', NULL, NULL, 'cart', '2017-04-04 22:15:34', '2017-04-04 23:59:30', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('28', '0', 'nhhs2qecrsthmkjl9rfemvjtc1', NULL, NULL, 'cart', '2017-04-05 08:58:05', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('29', '0', '61iakmehao0skc96u4uokuicf6', NULL, NULL, 'cart', '2017-04-05 10:41:25', '2017-04-05 12:27:21', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('30', '0', 'gof1jgsdnst5470en0ddvs1517', NULL, NULL, 'cart', '2017-04-05 12:59:33', '2017-04-05 16:38:34', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('31', '0', 'flpaq0nca6te8ojohsunanjdd7', NULL, NULL, 'cart', '2017-04-05 23:25:05', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('32', '0', '03h02lbdsvs0gfg7cnoecvipn3', NULL, NULL, 'cart', '2017-04-06 22:12:54', '2017-04-07 00:25:40', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('33', '0', 'n1ial41pu8k07ucem0cv3lalr5', NULL, NULL, 'cart', '2017-04-07 12:53:41', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('34', '0', '3p2kmi329ums23k9buoojmj5v0', NULL, NULL, 'cart', '2017-04-07 12:54:16', '2017-04-07 12:54:42', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('35', '0', 'kp6ga1eavrrj16gpterpeiser2', NULL, NULL, 'cart', '2017-04-07 14:13:00', '2017-04-07 16:40:29', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('36', '0', 'pb4nn8hfpek7cqcvhqg85pbas3', NULL, NULL, 'cart', '2017-04-07 22:50:26', '2017-04-07 23:01:54', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('37', '0', 'hg8jcsktf31p1or0grbp49vpn0', NULL, NULL, 'cart', '2017-04-08 12:59:00', '2017-04-08 14:24:20', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('38', '0', 'ush81csgj0qtu1c09vgsqpfta0', NULL, NULL, 'cart', '2017-04-08 14:15:55', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('39', '0', 'fl1jn8b3ibta5ikbmfapof81g2', NULL, NULL, 'cart', '2017-04-08 22:38:06', '2017-04-08 23:24:16', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('40', '0', '4qeg931mfq5hihae57qc2i1i93', NULL, NULL, 'cart', '2017-04-09 14:45:52', '2017-04-10 00:13:16', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('41', '0', 'ioqud6482cvhh3hhlotkhet880', NULL, NULL, 'cart', '2017-04-10 11:22:36', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('42', '0', '98vjv17g392t8kprojg27ne6r5', NULL, NULL, 'cart', '2017-04-10 12:09:51', '2017-04-10 13:03:40', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('43', '0', 'aoam7vh78lsvib24vuejul17r2', NULL, NULL, 'cart', '2017-04-10 13:21:13', '2017-04-10 16:08:28', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('44', '0', '8t43mesku0jast18ehk53bqku5', NULL, NULL, 'cart', '2017-04-10 22:07:04', '2017-04-10 23:45:53', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('45', '0', '4h1j9uk56uviv7sq0avsdu9cf4', NULL, NULL, 'cart', '2017-04-11 10:30:05', '2017-04-11 14:07:38', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('46', '0', '5iemg2rbjqtidgal2el6flikk5', NULL, NULL, 'cart', '2017-04-11 22:11:43', '2017-04-11 23:59:58', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('47', '0', '62ddpjomnqa0lj6taanposuth7', NULL, NULL, 'cart', '2017-04-12 12:35:53', '2017-04-12 14:16:16', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('48', '0', 'l37bej86enq5egr6dpvcbrhs63', NULL, NULL, 'cart', '2017-04-14 10:55:00', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('49', '0', 'b635qo4bb4lc9ij6kplkbrfk04', NULL, NULL, 'cart', '2017-04-14 12:43:25', '2017-04-14 22:30:50', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('50', '0', 'mh3sejkpmisvbhjpllqfsqhv34', NULL, NULL, 'cart', '2017-04-14 12:44:11', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('51', '0', '28buommk6u126qfco4o8pvtg83', NULL, NULL, 'cart', '2017-04-14 13:05:03', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('52', '0', 'uc9tcluefe3gkaku7le83rjp70', NULL, NULL, 'cart', '2017-04-14 23:59:51', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('53', '0', 'dl4a52vtptjugcnmk8thv94ma1', NULL, NULL, 'cart', '2017-04-15 12:38:18', '2017-04-15 15:19:45', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('54', '0', 'ourlsmt5c22mtjh44ad51r6ko4', NULL, NULL, 'cart', '2017-04-15 13:29:09', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('55', '0', '2g6m8gp29u53gkf8kdh8t2d527', NULL, NULL, 'cart', '2017-04-15 23:11:48', '2017-04-15 23:12:22', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('56', '0', 'j2ku151di5ii2ji086cn11amh1', NULL, NULL, 'cart', '2017-04-16 21:49:37', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('57', '0', 'hmlpiub5ieft0beo14d7sqe1f6', NULL, NULL, 'cart', '2017-04-16 22:25:51', '2017-04-17 00:10:54', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('58', '0', '9hr59609d0c2hh54hsusgr5ca4', NULL, NULL, 'cart', '2017-04-17 12:33:38', '2017-04-17 14:13:08', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('59', '0', '2157olpo3bjqsp0gif41imruj5', NULL, NULL, 'cart', '2017-04-17 16:33:57', '2017-04-17 16:35:20', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('60', '0', 'uk303l15pbsgn2e5vij2uf0rf0', NULL, NULL, 'cart', '2017-04-17 16:36:46', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('61', '0', 'hbk95euj1bmhl511pd3lrcbtv2', NULL, NULL, 'cart', '2017-04-17 21:30:33', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('62', '0', 'vcs6v11aebj5bq2rd6p9v84oe6', NULL, NULL, 'cart', '2017-04-17 22:02:30', '2017-04-18 00:23:36', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('63', '0', '1lhnp5tagekri1nga50ntp8qs2', NULL, NULL, 'cart', '2017-04-19 08:52:14', '2017-04-19 08:52:53', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('64', '0', 'bttjuk5i02hl2sqh7ctm3sail4', NULL, NULL, 'cart', '2017-05-03 13:44:57', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('65', '0', 'fdbb5ird54653om5gssnu7tqf7', NULL, NULL, 'cart', '2017-05-04 14:05:27', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('66', '0', 'g4gnpdh24nlnmdrru8pv8i5di4', NULL, NULL, 'cart', '2017-05-04 14:41:55', '2017-05-04 14:42:54', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('67', '0', 'ij3sb8pjm583spn9q6o1ni0nu0', NULL, NULL, 'cart', '2017-05-04 16:34:12', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('68', '0', 'vf9j59gldfvnb5bmv8su5stih5', NULL, NULL, 'cart', '2017-05-04 16:42:22', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('69', '0', 'hjsi6ndo91ermo0bumdd7fsna0', NULL, NULL, 'cart', '2017-05-13 11:03:38', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('70', '0', 'r8f9baerqald6bdehnuhpmud37', NULL, NULL, 'cart', '2017-07-03 15:23:06', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('71', '0', 'qacueers32ak79tnegbu1fam27', NULL, NULL, 'cart', '2017-07-03 15:27:52', '2017-07-03 15:36:57', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('72', '0', 'l28rth5l3au0plh75q59ku1al3', NULL, NULL, 'cart', '2017-07-03 15:37:19', '2017-07-03 15:50:07', '::1', '', 'chrome', '{\"is_mobile\":false}'), ('73', '0', 'nb1hdddh3ce86jjahuaj645gu6', NULL, NULL, 'cart', '2017-07-04 15:05:47', '0000-00-00 00:00:00', '::1', '', 'chrome', '{\"is_mobile\":false}'), ('74', '0', 'd7g8027e87mip206ictd91fd25', NULL, NULL, 'cart', '2017-07-04 15:05:47', '2017-07-04 15:08:29', '::1', '', 'chrome', '{\"is_mobile\":false}'), ('75', '0', '9gamq3k1ebtmric0nai5v12ns4', NULL, NULL, 'cart', '2017-07-04 15:06:54', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('76', '0', 'a32nm8kovpb3vk5086d2tji813', NULL, NULL, 'cart', '2017-07-04 15:16:25', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('77', '0', 'iu075d555m98bg30f59jpcupl5', NULL, NULL, 'cart', '2017-07-10 10:29:10', '2017-07-10 12:20:40', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('78', '0', 'ogi48gphfcholemjutsuvf0336', NULL, NULL, 'cart', '2017-07-10 11:47:59', '0000-00-00 00:00:00', '127.0.0.1', '', 'mozilla', '{\"is_mobile\":false}'), ('79', '0', '11adc1084b98e52219335826d2c5488e', NULL, NULL, 'cart', '2017-08-17 14:09:54', '2017-08-17 14:10:42', '::1', '', 'chrome', '{\"is_mobile\":false}'), ('80', '0', '5e6ca3dc2d47622d96135bd16b8debc4', NULL, NULL, 'cart', '2017-08-29 07:57:22', '2017-08-29 08:07:53', '::1', '', 'mozilla', '{\"is_mobile\":false}'), ('81', '0', 'er0nulpuh1mcjtrbu1t4d91fg6', NULL, NULL, 'cart', '2017-08-29 09:01:17', '0000-00-00 00:00:00', '103.25.44.2', '', 'mozilla', '{\"is_mobile\":false}'), ('82', '0', 'fnqh0eube4igaua6akbo244gf1', NULL, NULL, 'cart', '2017-08-29 09:01:57', '0000-00-00 00:00:00', '103.25.44.2', '', 'chrome', '{\"is_mobile\":false}'), ('83', '0', '3pf9u727b5qqutr2elcjok5p26', NULL, NULL, 'cart', '2017-08-29 09:02:17', '0000-00-00 00:00:00', '66.249.64.28', '', 'mozilla', '{\"is_mobile\":false}'), ('84', '0', 'tb3oe9degl0gebcfpg76voh9b4', NULL, NULL, 'cart', '2017-08-29 09:17:19', '0000-00-00 00:00:00', '66.249.64.27', '', 'mozilla', '{\"is_mobile\":false}'), ('85', '0', 'll9sair9n5ff0rdh5mj8ff7o07', NULL, NULL, 'cart', '2017-08-29 09:35:59', '2017-08-29 09:37:13', '83.77.60.55', '', 'chrome', '{\"is_mobile\":false}'), ('86', '0', '86092eqjcsrpa0phu245i9dsg3', NULL, NULL, 'cart', '2017-08-29 11:38:20', '2017-08-29 11:38:20', '188.0.188.50', '', 'chrome', '{\"is_mobile\":false}'), ('87', '0', 'mnv05e3jiddqi3anmrgd3jk7c2', NULL, NULL, 'cart', '2017-08-29 11:42:42', '0000-00-00 00:00:00', '149.154.167.171', '', '', '{\"is_mobile\":false}'), ('88', '0', 'eor88u3ke8p7s2q35tl01h01n5', NULL, NULL, 'cart', '2017-08-29 12:10:10', '0000-00-00 00:00:00', '66.249.93.200', '', 'chrome', '{\"is_mobile\":false}'), ('89', '0', 'vjflcra28pqcjij1o4b3tpbcn3', NULL, NULL, 'cart', '2017-08-29 13:17:05', '0000-00-00 00:00:00', '66.249.81.30', '', 'chrome', '{\"is_mobile\":false}'), ('90', '0', 'e0jarqjppgljsv3u4jiur302s5', NULL, NULL, 'cart', '2017-08-29 15:03:38', '0000-00-00 00:00:00', '141.8.143.177', '', 'mozilla', '{\"is_mobile\":false}'), ('91', '0', 'm89fr4rmpahg5pdvetjh7dq412', NULL, NULL, 'cart', '2017-08-29 15:09:09', '0000-00-00 00:00:00', '5.255.250.124', '', 'mozilla', '{\"is_mobile\":false}'), ('92', '0', '03ej24pq5giifeqkp50jucs8s4', NULL, NULL, 'cart', '2017-08-29 15:17:58', '0000-00-00 00:00:00', '66.249.93.198', '', 'chrome', '{\"is_mobile\":false}'), ('93', '0', 'vpevc5dr1odgqb122akbbdmh76', NULL, NULL, 'cart', '2017-08-29 15:30:16', '2017-08-29 15:34:30', '105.161.207.132', '', 'chrome', '{\"is_mobile\":false}'), ('94', '0', 'lba7gtucv6bdhta5f2pk8thl55', NULL, NULL, 'cart', '2017-08-29 15:59:39', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('95', '0', 'jimbo68m1f4veivu9sjtvtpvc3', NULL, NULL, 'cart', '2017-08-29 16:21:14', '2017-08-29 16:57:46', '105.161.207.132', '', 'chrome', '{\"is_mobile\":false}'), ('96', '0', 'n5bftu65nsbkb7e6uo1e9mgno3', NULL, NULL, 'cart', '2017-08-29 16:28:05', '0000-00-00 00:00:00', '177.141.184.59', '', 'opera', '{\"is_mobile\":false}'), ('97', '0', 'j3d2at0lgvcejnk6cr2ss88ft5', NULL, NULL, 'cart', '2017-08-29 16:38:42', '0000-00-00 00:00:00', '141.138.177.9', '', 'chrome', '{\"is_mobile\":false}'), ('98', '0', '6utsg5067o9mtr0m0o6l93rco0', NULL, NULL, 'cart', '2017-08-29 17:24:00', '0000-00-00 00:00:00', '207.241.229.79', '', 'mozilla', '{\"is_mobile\":false}'), ('99', '0', 'vpvvrt73na1ud6jpr3hvil2dc0', NULL, NULL, 'cart', '2017-08-29 18:24:06', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('100', '0', 'nq2h431k6if04tvbv9cntl6er2', NULL, NULL, 'cart', '2017-08-29 18:54:18', '0000-00-00 00:00:00', '54.165.90.203', '', '', '{\"is_mobile\":false}'), ('101', '0', '245evt37snik1tntk9756olf87', NULL, NULL, 'cart', '2017-08-29 18:59:15', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('102', '0', 'e67nn8bkah00ulo5auv13o8d80', NULL, NULL, 'cart', '2017-08-29 19:43:07', '0000-00-00 00:00:00', '207.46.13.194', '', 'mozilla', '{\"is_mobile\":false}'), ('103', '0', 'v86og895c3nd8v3dhr7n0qil53', NULL, NULL, 'cart', '2017-08-29 19:48:33', '0000-00-00 00:00:00', '40.77.167.146', '', 'mozilla', '{\"is_mobile\":false}'), ('104', '0', 'k8d5kruj2qde9jh1nuv96v1kq6', NULL, NULL, 'cart', '2017-08-29 20:00:33', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('105', '0', 'b25s2p1j89kujkc9oj3gcogh65', NULL, NULL, 'cart', '2017-08-29 21:27:36', '0000-00-00 00:00:00', '184.154.139.48', '', 'msie', '{\"is_mobile\":false}'), ('106', '0', '8n29tknh97jvpcuhqgmncl7k86', NULL, NULL, 'cart', '2017-08-29 21:33:12', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('107', '0', 'vjni8k6o10ko4qda7vtikta1o6', NULL, NULL, 'cart', '2017-08-29 21:51:59', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('108', '0', 'h97682mp0ih93nbhkvbjdp10q5', NULL, NULL, 'cart', '2017-08-29 22:28:32', '0000-00-00 00:00:00', '77.88.5.57', '', 'mozilla', '{\"is_mobile\":false}'), ('109', '0', 'fgstmniejtk8uagapjt8fvrb63', NULL, NULL, 'cart', '2017-08-29 22:30:58', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('110', '0', '79p190i0dkdtgf85m56anff6a4', NULL, NULL, 'cart', '2017-08-29 22:57:29', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('111', '0', 'ut1r1gl58djo8gbh2nvusndbd0', NULL, NULL, 'cart', '2017-08-30 00:17:18', '0000-00-00 00:00:00', '141.8.143.177', '', 'mozilla', '{\"is_mobile\":false}'), ('112', '0', '51rkrjmmmohcm6ijl226v9ljv2', NULL, NULL, 'cart', '2017-08-30 01:21:54', '0000-00-00 00:00:00', '36.67.91.153', '', 'mozilla', '{\"is_mobile\":false}'), ('113', '0', 'hg2doooaqmh4fcoqi6e6q188d1', NULL, NULL, 'cart', '2017-08-30 01:22:48', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('114', '0', 'k94pqad79eo58jfk5qphq1i973', NULL, NULL, 'cart', '2017-08-30 03:14:49', '0000-00-00 00:00:00', '27.33.104.198', '', 'chrome', '{\"is_mobile\":false}'), ('115', '0', 'v6r42qkfcdc1cvh3oj2mh6cm25', NULL, NULL, 'cart', '2017-08-30 04:16:00', '0000-00-00 00:00:00', '141.8.143.177', '', 'mozilla', '{\"is_mobile\":false}'), ('116', '0', 'obo3fauvqtv2dh9i0tn9o06e92', NULL, NULL, 'cart', '2017-08-30 04:27:13', '0000-00-00 00:00:00', '5.255.250.94', '', 'mozilla', '{\"is_mobile\":false}'), ('117', '0', 'jits8r0a71b825souhv46iu7e6', NULL, NULL, 'cart', '2017-08-30 05:50:40', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('118', '0', 'sirpvr2ce393kgq5qquic8hln6', NULL, NULL, 'cart', '2017-08-30 06:25:39', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('119', '0', '08fh0c1gloi7nogfqk95d73md2', NULL, NULL, 'cart', '2017-08-30 08:02:42', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('120', '0', '25ss42dbnr66us176nccbfi802', NULL, NULL, 'cart', '2017-08-30 08:04:37', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('121', '0', 'buh2ijturn6pqq9iu5lgijmo84', NULL, NULL, 'cart', '2017-08-30 08:33:01', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('122', '0', '912hv0um8copon39llpe48htu3', NULL, NULL, 'cart', '2017-08-30 08:45:06', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('123', '0', 'ieusrjcrka8uq3kl37b4b3mml2', NULL, NULL, 'cart', '2017-08-30 08:45:58', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('124', '0', '6l7h70b8rfu2vm8hthkr8drg57', NULL, NULL, 'cart', '2017-08-30 08:47:05', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('125', '0', 'vqud0ek6mnlm8k45l66lm2mlg2', NULL, NULL, 'cart', '2017-08-30 08:51:08', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('126', '0', '6cj0cbb33dobb3p573hj8cd343', NULL, NULL, 'cart', '2017-08-30 08:53:09', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('127', '0', 'ri0g8g55mnkh0b8sdptddh2mh2', NULL, NULL, 'cart', '2017-08-30 08:55:10', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('128', '0', 'dvi6n5ne1s8b6rh6cuqaviap90', NULL, NULL, 'cart', '2017-08-30 09:01:14', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('129', '0', '716jor8vgv9475nc4rg9rguqu1', NULL, NULL, 'cart', '2017-08-30 09:03:21', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('130', '0', 'dunls4j7khni8dkvagp7a1d8v7', NULL, NULL, 'cart', '2017-08-30 09:05:18', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('131', '0', '65b2i5chjma4l147qdqbjgjj65', NULL, NULL, 'cart', '2017-08-30 09:21:27', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('132', '0', '2uevhu7g75601fqromc427hea1', NULL, NULL, 'cart', '2017-08-30 09:33:36', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('133', '0', 'v2cqsqec256cogrsr0gg83su87', NULL, NULL, 'cart', '2017-08-30 09:39:39', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('134', '0', '8lq591sllbv49thj8hpham9ki7', NULL, NULL, 'cart', '2017-08-30 09:41:41', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('135', '0', 'sascpqa71l2369k7c6rhmudra0', NULL, NULL, 'cart', '2017-08-30 10:06:08', '2017-08-30 10:06:10', '103.220.17.26', '', 'chrome', '{\"is_mobile\":false}'), ('136', '0', '3fafa9qb4ndi78r7bkjmlmbr30', NULL, NULL, 'cart', '2017-08-30 10:23:03', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('137', '0', 'c29ntuqvohklmnua4hcqs73u82', NULL, NULL, 'cart', '2017-08-30 10:28:54', '0000-00-00 00:00:00', '176.126.63.137', '', 'chrome', '{\"is_mobile\":false}'), ('138', '0', 'mdhpco74a043kdc3q45bp05hr6', NULL, NULL, 'cart', '2017-08-30 10:34:16', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('139', '0', 'egdtf25e85relkgojpten83c44', NULL, NULL, 'cart', '2017-08-30 10:44:23', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('140', '0', 'p5gpd5nb81q7aattgord2nmmk3', NULL, NULL, 'cart', '2017-08-30 11:20:47', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('141', '0', 'ct0v5ossj44b99dbk5l6334aa6', NULL, NULL, 'cart', '2017-08-30 11:44:54', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('142', '0', 'ljsfvdhsjg56kd91eltrdhola6', NULL, NULL, 'cart', '2017-08-30 11:53:26', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('143', '0', 'adcojkt71o1hiaabu9a4oh7fq1', NULL, NULL, 'cart', '2017-08-30 11:54:30', '2017-08-30 11:54:42', '223.31.238.155', '', 'mozilla', '{\"is_mobile\":false}'), ('144', '0', 'n4n86s1l7u1qnl9ed3pljus9s6', NULL, NULL, 'cart', '2017-08-30 11:57:38', '0000-00-00 00:00:00', '66.249.93.200', '', 'chrome', '{\"is_mobile\":false}'), ('145', '0', '0gsu6ee4egf4cm20157erk1gj4', NULL, NULL, 'cart', '2017-08-30 12:08:00', '0000-00-00 00:00:00', '95.0.35.83', '', 'safari', '{\"is_mobile\":false}'), ('146', '0', '4gffea34q1rva44fo6evi38rl2', NULL, NULL, 'cart', '2017-08-30 12:21:03', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('147', '0', 'm5d15ggu7jb9tuds5544vbm1u0', NULL, NULL, 'cart', '2017-08-30 12:40:59', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('148', '0', 'a3l59j4507suimesqsd0lsv7o3', NULL, NULL, 'cart', '2017-08-30 12:42:28', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('149', '0', 'h1btbpghrkeuce31u54sdggq82', NULL, NULL, 'cart', '2017-08-30 12:46:28', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('150', '0', 'brddhv1c049fj5qmh71l1n4270', NULL, NULL, 'cart', '2017-08-30 12:48:41', '0000-00-00 00:00:00', '177.47.252.101', '', 'mozilla', '{\"is_mobile\":false}'), ('151', '0', 'jesg2d4b5meg1a1a7hpe2d7na3', NULL, NULL, 'cart', '2017-08-30 12:49:43', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('152', '0', 'kijoabt2poqtaa7t2jfc1mmrg3', NULL, NULL, 'cart', '2017-08-30 13:07:58', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('153', '0', '97ab2cmm56prfoepnc33oji095', NULL, NULL, 'cart', '2017-08-30 14:10:23', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('154', '0', '12gcv4ntfj5i2qjoi4jvfp55j0', NULL, NULL, 'cart', '2017-08-30 14:19:21', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('155', '0', '752jb5v45oloetnalrvt3bsoq1', NULL, NULL, 'cart', '2017-08-30 15:23:29', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('156', '0', '25av2j2nosq8q6eqcghkkr9c27', NULL, NULL, 'cart', '2017-08-30 15:42:46', '0000-00-00 00:00:00', '46.161.9.6', '', 'mozilla', '{\"is_mobile\":false}'), ('157', '0', '4pbatgvqn03tofgs7ue5uqsli0', NULL, NULL, 'cart', '2017-08-30 15:46:20', '0000-00-00 00:00:00', '81.83.130.139', '', 'safari', '{\"is_mobile\":false}'), ('158', '0', 'tj9aoqpv5p0o7iadjbstm62720', NULL, NULL, 'cart', '2017-08-30 15:48:20', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('159', '0', 'qodqrlhmh2pl2ncpg6dsmt7fs6', NULL, NULL, 'cart', '2017-08-30 16:21:05', '2017-08-30 16:29:05', '14.169.44.144', '', 'chrome', '{\"is_mobile\":false}'), ('160', '0', 'g7g3qnhhlk7aoaq7m903h9l7o5', NULL, NULL, 'cart', '2017-08-30 16:28:00', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('161', '0', '3mql5h8qq9qtikc6onl5thrda3', NULL, NULL, 'cart', '2017-08-30 16:34:00', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('162', '0', 'edh21ienulj636klgmhsk3csg0', NULL, NULL, 'cart', '2017-08-30 17:15:43', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('163', '0', 'ptcgnoq1nbjvdpbb9th03dgpe2', NULL, NULL, 'cart', '2017-08-30 18:53:11', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('164', '0', 'cp5ef7eh6c811pgulcnpohjr61', NULL, NULL, 'cart', '2017-08-30 18:58:00', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('165', '0', '9hvtkt8gh9o0ffkdturduvjl46', NULL, NULL, 'cart', '2017-08-30 19:10:11', '0000-00-00 00:00:00', '192.187.100.154', '', 'edge', '{\"is_mobile\":false}'), ('166', '0', 'qcpp849gmt1utb92poor06kks3', NULL, NULL, 'cart', '2017-08-30 19:22:00', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('167', '0', 'kv1n0eam2m7rfgo2glihp0odo5', NULL, NULL, 'cart', '2017-08-30 19:34:00', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('168', '0', 'n44435c5t15hrglsc03un0kv36', NULL, NULL, 'cart', '2017-08-30 19:59:12', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('169', '0', '17p6vksr5c13ssne20drhtnml0', NULL, NULL, 'cart', '2017-08-30 20:29:07', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('170', '0', 'o8ks5g4ep0tkmnecia9j4hrec6', NULL, NULL, 'cart', '2017-08-30 20:39:09', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('171', '0', '5n9k57dp093lml0b8ea2gdbbv0', NULL, NULL, 'cart', '2017-08-30 21:11:23', '2017-08-30 21:11:33', '194.28.51.189', '', 'edge', '{\"is_mobile\":false}'), ('172', '0', 'd2k0m64m8iuu4cqgpp553icp04', NULL, NULL, 'cart', '2017-08-30 21:18:05', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('173', '0', 'se3gd5et9tbv1odtu7vnpe5ho7', NULL, NULL, 'cart', '2017-08-30 21:33:08', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('174', '0', 'g8goe69nks36sutkoh7lghd7q2', NULL, NULL, 'cart', '2017-08-30 22:00:39', '0000-00-00 00:00:00', '84.232.137.232', '', 'mozilla', '{\"is_mobile\":false}'), ('175', '0', 's70dafmv91n05a693rcfk4i6p1', NULL, NULL, 'cart', '2017-08-30 22:01:52', '0000-00-00 00:00:00', '84.232.137.232', '', 'mozilla', '{\"is_mobile\":false}'), ('176', '0', '7c7m1iavm1cjhfch81j4nq8444', NULL, NULL, 'cart', '2017-08-30 22:09:44', '0000-00-00 00:00:00', '184.154.139.18', '', 'msie', '{\"is_mobile\":false}'), ('177', '0', 'lsj80ht1lqgcfm11g0n80lp0b3', NULL, NULL, 'cart', '2017-08-30 23:18:34', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('178', '0', '5rkln3tbkbentc1t65u38em9d2', NULL, NULL, 'cart', '2017-08-31 00:12:08', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('179', '0', '0rvfqbiu2n55o0a3ucsj9vu004', NULL, NULL, 'cart', '2017-08-31 00:57:09', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('180', '0', 'jm11hr9gmihip2edfiruqobub5', NULL, NULL, 'cart', '2017-08-31 01:53:20', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('181', '0', '7goajk6gp84i6likj2vf5vhju1', NULL, NULL, 'cart', '2017-08-31 04:58:49', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('182', '0', 'vlmtbhodmqvn5fsindlr38sg36', NULL, NULL, 'cart', '2017-08-31 05:17:14', '0000-00-00 00:00:00', '66.249.93.200', '', 'chrome', '{\"is_mobile\":false}'), ('183', '0', 's4j9pg9tgbe6ucg717uhe6tjl4', NULL, NULL, 'cart', '2017-08-31 06:16:24', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('184', '0', 'hnjikedvp4i5h6hl5qr3ek3fk6', NULL, NULL, 'cart', '2017-08-31 06:57:34', '0000-00-00 00:00:00', '207.241.229.65', '', 'mozilla', '{\"is_mobile\":false}'), ('185', '0', 'gbgc3hio709qdch7cp3k2u31l1', NULL, NULL, 'cart', '2017-08-31 08:02:49', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('186', '0', '7np2k8ioljbge9kpvil2r5oft5', NULL, NULL, 'cart', '2017-08-31 08:34:49', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('187', '0', 'o95hbdgekaqfrldhnrslc6orh5', NULL, NULL, 'cart', '2017-08-31 08:54:28', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('188', '0', 'ou2j6k116aqgivhu2oejp64n15', NULL, NULL, 'cart', '2017-08-31 09:04:44', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('189', '0', 'ium0nsi6eefglhjhabdeundq87', NULL, NULL, 'cart', '2017-08-31 10:14:34', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('190', '0', '7k4avqdcbnv8osa886rca5ni01', NULL, NULL, 'cart', '2017-08-31 10:14:37', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('191', '0', 'irq5gje4umaoe1j0tc8df5fjm5', NULL, NULL, 'cart', '2017-08-31 10:19:51', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('192', '0', 'h18lgg108t1om5is77lb3uskv2', NULL, NULL, 'cart', '2017-08-31 10:23:55', '2017-08-31 10:37:33', '150.129.103.90', '', 'chrome', '{\"is_mobile\":false}'), ('193', '0', 'o48a15rc2amntkmopqjji7nkh1', NULL, NULL, 'cart', '2017-08-31 10:29:50', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('194', '0', '5v1l09ao7qo2iuvde7u79e1hd5', NULL, NULL, 'cart', '2017-08-31 10:30:06', '2017-08-31 11:01:18', '150.129.103.90', '', 'mozilla', '{\"is_mobile\":false}'), ('195', '0', '8h63k9a08td58c4vqfapi4rl26', NULL, NULL, 'cart', '2017-08-31 10:30:59', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('196', '0', 'o3froup36jqtrugs4kombrjr17', NULL, NULL, 'cart', '2017-08-31 10:32:54', '2017-08-31 10:39:44', '27.62.224.11', '', 'chrome', '{\"is_mobile\":false}'), ('197', '0', 'sgik5ok09jhpt09jq2lt1re474', NULL, NULL, 'cart', '2017-08-31 10:34:38', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('198', '0', 'fkhq57nnp4cur4do509jbkpbt1', NULL, NULL, 'cart', '2017-08-31 10:39:21', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('199', '0', '1lrpp9kg6n4gqch7bpq2bti344', NULL, NULL, 'cart', '2017-08-31 10:45:07', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('200', '0', 'qcohdepr4fukdtk0gms1rbia35', NULL, NULL, 'cart', '2017-08-31 10:49:28', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('201', '0', 'shn9i5bf09e9joe862qbm5v0n2', NULL, NULL, 'cart', '2017-08-31 10:57:49', '0000-00-00 00:00:00', '66.249.73.27', '', 'chrome', '{\"is_mobile\":true}'), ('202', '0', '4u203k9m4ql0kpga66eeth6cc1', NULL, NULL, 'cart', '2017-08-31 10:59:27', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('203', '0', '2g80e9f0m9rk359ngo5bpa7393', NULL, NULL, 'cart', '2017-08-31 10:59:58', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('204', '0', 'lvk6qh90ju15o557j3j6h29ah6', NULL, NULL, 'cart', '2017-08-31 11:01:37', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('205', '0', '7a8egq0222jq0jpfinlbuouir5', NULL, NULL, 'cart', '2017-08-31 11:06:47', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('206', '0', 'kkh2a5s71dcmu10s863lrhchs0', NULL, NULL, 'cart', '2017-08-31 11:09:53', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('207', '0', 'mdcrmooer0ulkgtethps9culk3', NULL, NULL, 'cart', '2017-08-31 11:10:35', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('208', '0', '9fs55r5lg1f54lql8qqidfrlu0', NULL, NULL, 'cart', '2017-08-31 11:10:45', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('209', '0', 'ndelbevocg233sjbm4ip28an43', NULL, NULL, 'cart', '2017-08-31 11:11:48', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('210', '0', '8im8gpuvsaftn53b5e9l6vpjn4', NULL, NULL, 'cart', '2017-08-31 11:13:48', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('211', '0', 'jc157l25rlqdou1jq6rldhebh3', NULL, NULL, 'cart', '2017-08-31 11:14:23', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('212', '0', 'naku7uk4snmt6jugfqkpikk103', NULL, NULL, 'cart', '2017-08-31 11:15:46', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('213', '0', '3dcrh203ieu1tdnc8qa05b6hc5', NULL, NULL, 'cart', '2017-08-31 11:25:41', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('214', '0', 'm49n3srnb5hdsjkv7k2391au70', NULL, NULL, 'cart', '2017-08-31 11:26:22', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('215', '0', 'rd1je76gl50tsu6kv2trnhnhs7', NULL, NULL, 'cart', '2017-08-31 11:27:15', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('216', '0', 'vb1egmgi0aei5skk7g71s6vth2', NULL, NULL, 'cart', '2017-08-31 11:27:47', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('217', '0', 'dd38prc13dcef1q87nuh1v7lq6', NULL, NULL, 'cart', '2017-08-31 11:29:13', '0000-00-00 00:00:00', '66.249.73.27', '', 'chrome', '{\"is_mobile\":true}'), ('218', '0', 'kgql95stm7bmuj4o67ifmnj3c7', NULL, NULL, 'cart', '2017-08-31 11:29:34', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('219', '0', 'rb6rd8t1msg4hj3iclcjtaqcs1', NULL, NULL, 'cart', '2017-08-31 11:36:58', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('220', '0', 'kv84m4rvnk3ps382g2cgokn240', NULL, NULL, 'cart', '2017-08-31 11:40:11', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('221', '0', 'nfrh1dbngbclvgj02k87u4cpc4', NULL, NULL, 'cart', '2017-08-31 11:40:26', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('222', '0', 'mndjgsuptrtj7vifgf0k5u3626', NULL, NULL, 'cart', '2017-08-31 11:40:32', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('223', '0', 'devpn4knurm8sef7nli6gfdcq7', NULL, NULL, 'cart', '2017-08-31 11:41:35', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('224', '0', 'lhvm2d6pi6s91ro5oog8f1oe02', NULL, NULL, 'cart', '2017-08-31 11:41:56', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('225', '0', '6fet4of6v28rfgeikibhik8ge2', NULL, NULL, 'cart', '2017-08-31 11:42:18', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('226', '0', 'c7vev67hrdd8ohchsv895tgnd6', NULL, NULL, 'cart', '2017-08-31 11:43:42', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('227', '0', 'k6tivt78oj3h0jv0d66dru8bv1', NULL, NULL, 'cart', '2017-08-31 11:44:03', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('228', '0', 'le3rqabi2p74n1gr9t228s50k5', NULL, NULL, 'cart', '2017-08-31 11:44:24', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('229', '0', 'ghint0ckn8oas276bqrmb5g9e7', NULL, NULL, 'cart', '2017-08-31 11:45:28', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('230', '0', 'op0pil3t9mrbhjr46infcp3fk5', NULL, NULL, 'cart', '2017-08-31 11:45:49', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('231', '0', 'bb7gdao38r3e5j26c4tavul4s1', NULL, NULL, 'cart', '2017-08-31 11:46:11', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('232', '0', 'fmhlsaj7nu47grvj3mt7oo3pj3', NULL, NULL, 'cart', '2017-08-31 11:47:14', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('233', '0', 'rkl5mtdbh8n14s93pce5ameal0', NULL, NULL, 'cart', '2017-08-31 11:49:42', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('234', '0', 'aanhavfv5gv1gmuhmvf00raqp5', NULL, NULL, 'cart', '2017-08-31 11:50:25', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('235', '0', 'a3ftvkgehdh5p50faks0maevg0', NULL, NULL, 'cart', '2017-08-31 11:50:46', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('236', '0', '7asjb50mvtb4ug3jf3cjmmviv5', NULL, NULL, 'cart', '2017-08-31 11:52:11', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('237', '0', 'dk9up1gb8aafdt9uhv0kc01q96', NULL, NULL, 'cart', '2017-08-31 11:52:31', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('238', '0', 'm9209248vnum043bcgiqvahl81', NULL, NULL, 'cart', '2017-08-31 11:52:53', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('239', '0', 'heehgr18bakb65758kpl6pfsl7', NULL, NULL, 'cart', '2017-08-31 11:54:39', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('240', '0', '2aego3qv0f1o11ifuits8k46j6', NULL, NULL, 'cart', '2017-08-31 11:55:22', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('241', '0', 'tgrmpkd78p0ntil6vskdkbbu73', NULL, NULL, 'cart', '2017-08-31 11:56:04', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('242', '0', 'mvredpcj9rcnm3tikv33pglc15', NULL, NULL, 'cart', '2017-08-31 11:59:14', '0000-00-00 00:00:00', '66.249.73.27', '', 'chrome', '{\"is_mobile\":true}'), ('243', '0', 'km43ft3qg7ueqbfbp6k1g8drh3', NULL, NULL, 'cart', '2017-08-31 12:02:47', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('244', '0', 'ialscq8ltuaooibg761d2cftl7', NULL, NULL, 'cart', '2017-08-31 12:05:58', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('245', '0', 'ig4nd8vpmmtpcfkc1cdqqs5vq2', NULL, NULL, 'cart', '2017-08-31 12:10:12', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('246', '0', 'rvb3trcotfbbgtq1ftqp51ois5', NULL, NULL, 'cart', '2017-08-31 12:12:19', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('247', '0', 'dqlmufa88vc5enqc1gu8rvv336', NULL, NULL, 'cart', '2017-08-31 12:12:40', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('248', '0', 'c6h318dsco53cbnffmd851pho5', NULL, NULL, 'cart', '2017-08-31 12:13:01', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('249', '0', '9jef4cjbpegsdpuhlsbcafro67', NULL, NULL, 'cart', '2017-08-31 12:13:22', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('250', '0', 'n8nkdlodocvve9cujclhbgbu33', NULL, NULL, 'cart', '2017-08-31 12:15:35', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('251', '0', 'b06jus5nr9d0mpkjfk7tem6lb2', NULL, NULL, 'cart', '2017-08-31 12:16:33', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('252', '0', 'hrqve83mpcg71rql4kv91s3ok2', NULL, NULL, 'cart', '2017-08-31 12:17:19', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('253', '0', 'qc7j39p5fj3nefil0pgavk7fj6', NULL, NULL, 'cart', '2017-08-31 12:17:59', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('254', '0', 's088ujqgm3r94eoadutc272ju1', NULL, NULL, 'cart', '2017-08-31 12:19:02', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('255', '0', 'g40ni109kvuoui8glupq4c2ue6', NULL, NULL, 'cart', '2017-08-31 12:20:49', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('256', '0', 'j8b5rqv9r2l0vt4lsj8l11aot5', NULL, NULL, 'cart', '2017-08-31 12:21:52', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('257', '0', '3qlrp8s2a298do61eacnscike3', NULL, NULL, 'cart', '2017-08-31 12:22:13', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('258', '0', 'flfjk61pl3l3m69nivg670gjc3', NULL, NULL, 'cart', '2017-08-31 12:23:38', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('259', '0', '15k1ork600m7lggrea77cnj2d4', NULL, NULL, 'cart', '2017-08-31 12:27:30', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('260', '0', '1svcouid5r639mufeg98nme470', NULL, NULL, 'cart', '2017-08-31 12:31:02', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('261', '0', 'o44kp0638qrvatbte68pa0b9o6', NULL, NULL, 'cart', '2017-08-31 12:34:13', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('262', '0', '1il6qe9c7t3m33h9dt3i1fm315', NULL, NULL, 'cart', '2017-08-31 12:36:41', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('263', '0', 'fo1rtqkdjheva10dnr9ekemv17', NULL, NULL, 'cart', '2017-08-31 12:38:27', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('264', '0', 'qil8890j1r683s00994d2aghd1', NULL, NULL, 'cart', '2017-08-31 12:41:38', '0000-00-00 00:00:00', '66.249.73.27', '', 'chrome', '{\"is_mobile\":true}'), ('265', '0', '8vkgab6703puhr1l06h4b0ca25', NULL, NULL, 'cart', '2017-08-31 12:42:20', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('266', '0', '1d773u5vf6ji4c439dn54u5f12', NULL, NULL, 'cart', '2017-08-31 12:49:46', '0000-00-00 00:00:00', '66.249.73.26', '', 'chrome', '{\"is_mobile\":true}'), ('267', '0', '0ku23ljhgf1temq4v0rdqubcl0', NULL, NULL, 'cart', '2017-08-31 12:54:01', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('268', '0', 'kbt3e1na8h1v1tllh5kp9ok8e6', NULL, NULL, 'cart', '2017-08-31 13:00:00', '0000-00-00 00:00:00', '66.249.73.26', '', 'chrome', '{\"is_mobile\":true}'), ('269', '0', '32a9bd7ft655nlmtds4m1lr9c5', NULL, NULL, 'cart', '2017-08-31 13:00:23', '0000-00-00 00:00:00', '66.249.73.26', '', 'chrome', '{\"is_mobile\":true}'), ('270', '0', 'njmq7n3ccnl6sf0go92klfi321', NULL, NULL, 'cart', '2017-08-31 13:04:57', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('271', '0', 'nf350p5r3ueunulhq9mstdll57', NULL, NULL, 'cart', '2017-08-31 13:10:36', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('272', '0', 'pmc56b7ca5umg6ss5ufr2bfp73', NULL, NULL, 'cart', '2017-08-31 13:23:41', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('273', '0', 'd91c6bcij6e39hrdm1565eu4m5', NULL, NULL, 'cart', '2017-08-31 13:30:45', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('274', '0', 'kbrgll5j1f22bkk8c7ocd7hp53', NULL, NULL, 'cart', '2017-08-31 13:32:09', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('275', '0', 'rm94sedc8t79vug06sq1gmg6i5', NULL, NULL, 'cart', '2017-08-31 13:34:59', '0000-00-00 00:00:00', '66.249.73.26', '', 'chrome', '{\"is_mobile\":true}'), ('276', '0', 'imsbpr94bmmdmd5qe6qvs2org3', NULL, NULL, 'cart', '2017-08-31 13:45:46', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('277', '0', '1gtguano32kas6a3htej9njsn6', NULL, NULL, 'cart', '2017-08-31 14:01:31', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('278', '0', 'ne089vogipp8o1899m9ch3bhi3', NULL, NULL, 'cart', '2017-08-31 14:14:20', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('279', '0', '9eobd6400aroorbfvghkratot3', NULL, NULL, 'cart', '2017-08-31 14:27:08', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('280', '0', 'k02u76p9am44sbhp09v7nt1t87', NULL, NULL, 'cart', '2017-08-31 14:32:56', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('281', '0', '4k0bve1jq0gijd0skbv60n3ev7', NULL, NULL, 'cart', '2017-08-31 14:36:47', '0000-00-00 00:00:00', '66.249.73.27', '', 'chrome', '{\"is_mobile\":true}'), ('282', '0', 'ob0cq1igvrm3r9k84uk75d5e92', NULL, NULL, 'cart', '2017-08-31 14:38:06', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('283', '0', '4cemtinq1nmjvs5ukhlvggnv00', NULL, NULL, 'cart', '2017-08-31 14:38:47', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('284', '0', 'tl181g53d19m5musbid2vp5l11', NULL, NULL, 'cart', '2017-08-31 14:40:24', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('285', '0', 'sll59ss62grjs8ksggh41bg2g2', NULL, NULL, 'cart', '2017-08-31 14:40:34', '0000-00-00 00:00:00', '77.88.5.57', '', 'mozilla', '{\"is_mobile\":false}'), ('286', '0', '0907pp8h0i6cge55sl6mp60iq0', NULL, NULL, 'cart', '2017-08-31 14:42:00', '0000-00-00 00:00:00', '66.249.73.27', '', 'chrome', '{\"is_mobile\":true}'), ('287', '0', 'mc9k8ier4uuaaj9e02p41voi74', NULL, NULL, 'cart', '2017-08-31 14:48:03', '2017-08-31 14:48:54', '66.249.93.200', '', 'chrome', '{\"is_mobile\":true}'), ('288', '0', '1k4dt4979jtlucehecd38dm621', NULL, NULL, 'cart', '2017-08-31 14:55:42', '0000-00-00 00:00:00', '91.32.244.135', '', 'mozilla', '{\"is_mobile\":false}'), ('289', '0', 'guhpc135m4btqhfqn4165jjq92', NULL, NULL, 'cart', '2017-08-31 15:01:01', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('290', '0', 'ccn49q7ovhnse7um1sr65qclr1', NULL, NULL, 'cart', '2017-08-31 15:02:25', '0000-00-00 00:00:00', '66.249.73.26', '', 'chrome', '{\"is_mobile\":true}'), ('291', '0', 'ni4ueaaghqc20egbp4qgqt8in0', NULL, NULL, 'cart', '2017-08-31 15:11:38', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('292', '0', 'lpfgni1jdmoht0e7k5ics7d7j6', NULL, NULL, 'cart', '2017-08-31 15:23:38', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('293', '0', '5m2a2015gbt2vf2b259l63o3k4', NULL, NULL, 'cart', '2017-08-31 15:23:58', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('294', '0', '93en97v7kn43re01qjtub83ea0', NULL, NULL, 'cart', '2017-08-31 15:24:20', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('295', '0', '9m115g15p6vtnk4v3dr34tnua0', NULL, NULL, 'cart', '2017-08-31 15:25:45', '0000-00-00 00:00:00', '66.249.69.222', '', 'mozilla', '{\"is_mobile\":false}'), ('296', '0', 'u5ea5tgol1vk75eqbq692u1mm2', NULL, NULL, 'cart', '2017-08-31 15:27:09', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('297', '0', 'rnol31vt7pn7uac8ridtrr8ju1', NULL, NULL, 'cart', '2017-08-31 15:31:02', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('298', '0', 'h07j764ck1hnkt7sp9ucvisau7', NULL, NULL, 'cart', '2017-08-31 15:50:50', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('299', '0', 'tiq46k9mi5nk2tnk8ebhk01i25', NULL, NULL, 'cart', '2017-08-31 15:54:21', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('300', '0', '7ntrflm1d02g3e4ap3vd4dler5', NULL, NULL, 'cart', '2017-08-31 15:59:39', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('301', '0', 'i8vp7mchg9ri63hip8u6abit30', NULL, NULL, 'cart', '2017-08-31 16:08:29', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('302', '0', 'qkhiifhltqlh6fcnqhp66of957', NULL, NULL, 'cart', '2017-08-31 16:08:50', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('303', '0', 'mih3l1c5m5n73jrvltq0osvan4', NULL, NULL, 'cart', '2017-08-31 16:09:16', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('304', '0', 'ldko7a8q2v8s3vs9h2gprigk46', NULL, NULL, 'cart', '2017-08-31 16:09:33', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('305', '0', 'bvsfkjnt1niq3an0kormr0i957', NULL, NULL, 'cart', '2017-08-31 16:09:54', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('306', '0', 'lld10pnbjjhd4urlo2utam5421', NULL, NULL, 'cart', '2017-08-31 16:10:36', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('307', '0', 'tecmg3ofttf83kvv85nbp1djm5', NULL, NULL, 'cart', '2017-08-31 16:10:57', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('308', '0', 'up0mapimqmc5baap4av6ff1hj5', NULL, NULL, 'cart', '2017-08-31 16:11:19', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('309', '0', 's49v6t9ar5gm2omh29tj0dmph7', NULL, NULL, 'cart', '2017-08-31 16:11:40', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('310', '0', '9qbhf8ehrjnen24abba5nd6ln5', NULL, NULL, 'cart', '2017-08-31 16:12:01', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('311', '0', 'kota3c3pdmvvue91mp3qqf2th5', NULL, NULL, 'cart', '2017-08-31 16:12:23', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('312', '0', 'k2ko8rq9jf68bmrqnfkiqe8ht6', NULL, NULL, 'cart', '2017-08-31 16:14:30', '0000-00-00 00:00:00', '66.249.73.27', '', 'chrome', '{\"is_mobile\":true}'), ('313', '0', 'ac9q8ll0qch5o77thk5gna6467', NULL, NULL, 'cart', '2017-08-31 16:15:12', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('314', '0', '5ks77oqromtom5nb0gnhfcqe73', NULL, NULL, 'cart', '2017-08-31 16:15:33', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('315', '0', '2iusg2uu6hqlm47gcsu9nkvkf2', NULL, NULL, 'cart', '2017-08-31 16:16:15', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('316', '0', 'i42hssfdifpm7vob9onhmdj3v3', NULL, NULL, 'cart', '2017-08-31 16:18:44', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('317', '0', '75kgg30kgiotfsn0f9dmqr0dq1', NULL, NULL, 'cart', '2017-08-31 16:19:48', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('318', '0', 'qr59pkb829hahprnqop97h2a17', NULL, NULL, 'cart', '2017-08-31 16:20:19', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('319', '0', 'khm96mtd2ecf73iet8a0841bk7', NULL, NULL, 'cart', '2017-08-31 16:21:34', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('320', '0', 'gh71hbcnedqpq192d9d0g3imn5', NULL, NULL, 'cart', '2017-08-31 16:28:58', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('321', '0', 'v5gg2jf1a62v3j7ifekecs5pp5', NULL, NULL, 'cart', '2017-08-31 16:29:20', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('322', '0', 'hnht5cf561eq5ed06en06ujs91', NULL, NULL, 'cart', '2017-08-31 16:39:13', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('323', '0', 'mjvrgi1ou4b20ot2d4bbnft5c4', NULL, NULL, 'cart', '2017-08-31 16:39:35', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('324', '0', 'jbl40cjd3kos6qgpolg27b1np0', NULL, NULL, 'cart', '2017-08-31 16:39:56', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('325', '0', '55hob7raa8nvi2brtvqtma3lj0', NULL, NULL, 'cart', '2017-08-31 16:40:17', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('326', '0', 'ce20lqtb0oo89dcp5ldjrr7mq4', NULL, NULL, 'cart', '2017-08-31 16:50:10', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('327', '0', 'jph0crervitfhkq86o348frc43', NULL, NULL, 'cart', '2017-08-31 16:59:22', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('328', '0', 'l6n62sr74g35bo3et38rqdajr2', NULL, NULL, 'cart', '2017-08-31 17:11:46', '0000-00-00 00:00:00', '66.249.73.9', '', 'mozilla', '{\"is_mobile\":false}'), ('329', '0', 'p01l64dameuqf1v1rbbhf9m7b4', NULL, NULL, 'cart', '2017-08-31 17:15:37', '0000-00-00 00:00:00', '66.249.73.9', '', 'mozilla', '{\"is_mobile\":false}'), ('330', '0', '11o6trbjt8q3mfh4rtavbhod72', NULL, NULL, 'cart', '2017-08-31 17:16:01', '0000-00-00 00:00:00', '66.249.73.9', '', 'mozilla', '{\"is_mobile\":false}'), ('331', '0', 'au3868gf8suh5eopgmsgaedcn5', NULL, NULL, 'cart', '2017-08-31 17:16:41', '0000-00-00 00:00:00', '66.249.73.9', '', 'mozilla', '{\"is_mobile\":false}'), ('332', '0', 'eplo4u757pnhhfdvmlftsu9sv4', NULL, NULL, 'cart', '2017-08-31 17:17:01', '0000-00-00 00:00:00', '66.249.73.11', '', 'mozilla', '{\"is_mobile\":false}'), ('333', '0', 'ah7hjdeishm8j5ab5ogi2nnd01', NULL, NULL, 'cart', '2017-08-31 17:17:23', '0000-00-00 00:00:00', '66.249.73.9', '', 'mozilla', '{\"is_mobile\":false}'), ('334', '0', 'ifaefq3utrlo9s9ts44k6jsr43', NULL, NULL, 'cart', '2017-08-31 17:18:26', '0000-00-00 00:00:00', '66.249.73.11', '', 'mozilla', '{\"is_mobile\":false}'), ('335', '0', 'dcn8kt7f4moah9460pie60bpn6', NULL, NULL, 'cart', '2017-08-31 17:18:48', '0000-00-00 00:00:00', '66.249.73.9', '', 'mozilla', '{\"is_mobile\":false}'), ('336', '0', '64ua9k18d59a9o6u96berueik7', NULL, NULL, 'cart', '2017-08-31 17:19:11', '0000-00-00 00:00:00', '66.249.73.13', '', 'mozilla', '{\"is_mobile\":false}'), ('337', '0', 'v7g9r9skknm041utf06q5b6dq4', NULL, NULL, 'cart', '2017-08-31 17:19:30', '0000-00-00 00:00:00', '66.249.73.9', '', 'mozilla', '{\"is_mobile\":false}'), ('338', '0', 'lrf36vrf3pm7j2nkrkf9r1k970', NULL, NULL, 'cart', '2017-08-31 17:19:51', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('339', '0', 'o1t648dc9q0pusr5v8cu8k7q90', NULL, NULL, 'cart', '2017-08-31 17:57:27', '0000-00-00 00:00:00', '93.158.161.19', '', 'mozilla', '{\"is_mobile\":false}'), ('340', '0', 'bgn2r8gem4mfsgjj1pqev5ebe3', NULL, NULL, 'cart', '2017-08-31 18:00:53', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('341', '0', '0t5r7jp86i363cgstmefq9rr05', NULL, NULL, 'cart', '2017-08-31 18:02:32', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('342', '0', 'rlq6eptrk17r1pvshm7q42kqi0', NULL, NULL, 'cart', '2017-08-31 18:04:50', '0000-00-00 00:00:00', '66.249.73.27', '', 'chrome', '{\"is_mobile\":true}'), ('343', '0', '50ed7v3p23c85dgkroto1lcjb7', NULL, NULL, 'cart', '2017-08-31 18:07:46', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('344', '0', '2h2hmceq0ugntqv40p365krft6', NULL, NULL, 'cart', '2017-08-31 18:11:11', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('345', '0', 'cmn6m5ghjv41d8a2abi0iuccm2', NULL, NULL, 'cart', '2017-08-31 18:11:48', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('346', '0', 'seh4mohpi28g4gfsbikrgd1oa2', NULL, NULL, 'cart', '2017-08-31 18:11:51', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('347', '0', 'neo4lpbrd1inbass6fpisu3qu5', NULL, NULL, 'cart', '2017-08-31 18:11:52', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('348', '0', 't8vjaqdta8hkb1hml18qm7phb1', NULL, NULL, 'cart', '2017-08-31 18:12:13', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('349', '0', '810slpc8ci75cp34kagh14d2i5', NULL, NULL, 'cart', '2017-08-31 18:12:23', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('350', '0', 'cc3qspd4jurrtacnau1rqt31d0', NULL, NULL, 'cart', '2017-08-31 18:12:36', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('351', '0', '8vbs5pcuvfgbdi50eljn76o2o6', NULL, NULL, 'cart', '2017-08-31 18:12:44', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('352', '0', 'lig9n0mahkf74d0tdsfvh4bv92', NULL, NULL, 'cart', '2017-08-31 18:13:06', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('353', '0', 'fb98e392evcnrplnlst24c4u22', NULL, NULL, 'cart', '2017-08-31 18:13:15', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('354', '0', 'qv255lfb9991c2dskrm01eq1g2', NULL, NULL, 'cart', '2017-08-31 18:13:26', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('355', '0', 'ea38hsgd2risi8lop55nuefcl0', NULL, NULL, 'cart', '2017-08-31 18:13:36', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('356', '0', 'akddouogbb24k6nd9iq5mlac81', NULL, NULL, 'cart', '2017-08-31 18:15:45', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('357', '0', 'fpgtq48sq04edbs0770t6212s4', NULL, NULL, 'cart', '2017-08-31 18:15:55', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('358', '0', 'ulk5prlqkg85drsli3dgvugb47', NULL, NULL, 'cart', '2017-08-31 18:16:31', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('359', '0', '833glvrd9s6skohml86oc32ul6', NULL, NULL, 'cart', '2017-08-31 18:16:41', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('360', '0', 't5ooc6ts9rd6hjkb44dcvvo832', NULL, NULL, 'cart', '2017-08-31 18:17:05', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('361', '0', 'gv61t9iblbqekblh9t5jueebu6', NULL, NULL, 'cart', '2017-08-31 18:17:49', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('362', '0', '4fhsuv2lpnlr4uoss0qb9b2eo2', NULL, NULL, 'cart', '2017-08-31 18:18:00', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('363', '0', '5q5kbpg345io96djtrt54bjnr4', NULL, NULL, 'cart', '2017-08-31 18:18:12', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('364', '0', 'ovpugh2u32d23omsvabtmd20q4', NULL, NULL, 'cart', '2017-08-31 18:18:34', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('365', '0', 'osd0nek75r7ttivc5o9j5809n5', NULL, NULL, 'cart', '2017-08-31 18:18:45', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('366', '0', 'br0cin9ea7r0d2qio64saepl45', NULL, NULL, 'cart', '2017-08-31 18:18:56', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('367', '0', 'eg41afvu745hrbliuo6itgfj26', NULL, NULL, 'cart', '2017-08-31 18:19:50', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('368', '0', 'dvgsvqsu40cfg3lns28p52b5u0', NULL, NULL, 'cart', '2017-08-31 18:19:58', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('369', '0', 'mddqgh64hb9vu8m0ndlo6b59t2', NULL, NULL, 'cart', '2017-08-31 18:20:10', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('370', '0', '3kq8ee8n3mb31vec0lmu5n0s05', NULL, NULL, 'cart', '2017-08-31 18:20:20', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('371', '0', '83lqln8ba5tmrgs8l5jv87otp7', NULL, NULL, 'cart', '2017-08-31 18:20:51', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('372', '0', '0s9mnlv3l2fggj6sed0c31c4s4', NULL, NULL, 'cart', '2017-08-31 18:21:12', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('373', '0', '6l8cbfm9e82t55rg5a628fu8r2', NULL, NULL, 'cart', '2017-08-31 18:21:43', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('374', '0', 'jtl3av20896bau9o634pc7lg80', NULL, NULL, 'cart', '2017-08-31 18:21:53', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('375', '0', 'nck2pkmiha0lm7gtk6jgocatn1', NULL, NULL, 'cart', '2017-08-31 18:22:03', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('376', '0', 'evnirf68af12ff4qk8sn29lmo7', NULL, NULL, 'cart', '2017-08-31 18:22:14', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('377', '0', 'v5athgvkabj1ga27jjujb5k953', NULL, NULL, 'cart', '2017-08-31 18:22:24', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('378', '0', 'mqu1drpq713g65k96gu2p2d2h0', NULL, NULL, 'cart', '2017-08-31 18:22:34', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('379', '0', 'nlrtln3bj5mpkrhbtl6ongv962', NULL, NULL, 'cart', '2017-08-31 18:23:51', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('380', '0', '9erkj0midu7lardtqcbd593jt4', NULL, NULL, 'cart', '2017-08-31 18:24:50', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('381', '0', 'nsnm3noo9mptfo8v0d0si6tdi6', NULL, NULL, 'cart', '2017-08-31 18:30:19', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('382', '0', 'b338u0i28ho5loru831c90kml2', NULL, NULL, 'cart', '2017-08-31 18:31:22', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('383', '0', 'oiesfrbueqrpteicmn2njnbfn4', NULL, NULL, 'cart', '2017-08-31 18:32:24', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('384', '0', 'n6g28rjo0uemifurv52tcs5pt1', NULL, NULL, 'cart', '2017-08-31 18:32:55', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('385', '0', 'qsbg11nnel57arpe51aj3ase73', NULL, NULL, 'cart', '2017-08-31 18:37:04', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('386', '0', 'i7ac59up383fgiafvpa4km95t7', NULL, NULL, 'cart', '2017-08-31 18:40:59', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('387', '0', 'j2h1r2tihk850b6qgbgjuih2f4', NULL, NULL, 'cart', '2017-08-31 18:41:08', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('388', '0', '4ig68fcd2rc2u1oqmurndurod5', NULL, NULL, 'cart', '2017-08-31 18:41:39', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('389', '0', '3fetup1ertn8em7ktqi8u0uks7', NULL, NULL, 'cart', '2017-08-31 18:41:49', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('390', '0', 'jj8krmv28ht5mauaqdmp9ut9d4', NULL, NULL, 'cart', '2017-08-31 18:42:38', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('391', '0', 'cnk09uu6n7o8ku3bo4r14i6eh4', NULL, NULL, 'cart', '2017-08-31 18:45:30', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('392', '0', 'rngae8f16320dior2178neb3g3', NULL, NULL, 'cart', '2017-08-31 18:46:12', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('393', '0', '5prhgqg8s93344hmd0gvg8roa1', NULL, NULL, 'cart', '2017-08-31 18:46:22', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('394', '0', 'nje43sie51td760r99jprrvo95', NULL, NULL, 'cart', '2017-08-31 18:46:32', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('395', '0', 'u4vtrs7lukuo78cjud16cc26r6', NULL, NULL, 'cart', '2017-08-31 18:48:28', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('396', '0', 'qbg4m42lfufiok2lqpkfmfof11', NULL, NULL, 'cart', '2017-08-31 18:50:39', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('397', '0', 'ggck89l27vglum7f7p6culdi30', NULL, NULL, 'cart', '2017-08-31 18:52:08', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('398', '0', 'n8esbshi98pqd0sv0929142a43', NULL, NULL, 'cart', '2017-08-31 18:53:18', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('399', '0', 'ed60t9sn8ars3a6gaaqcl8agl3', NULL, NULL, 'cart', '2017-08-31 18:53:50', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('400', '0', '8ll8ts24ekc7fm9aoq1u2mr1f6', NULL, NULL, 'cart', '2017-08-31 18:55:09', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('401', '0', 'o6ref0jsttad5vjonj3l0k2m71', NULL, NULL, 'cart', '2017-08-31 18:56:18', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('402', '0', 'e2cqaggk08npakiok4kvmeofm3', NULL, NULL, 'cart', '2017-08-31 18:56:51', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('403', '0', 'h4trgsmgbs71npea63algq5mm0', NULL, NULL, 'cart', '2017-08-31 18:57:14', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('404', '0', 'svgofebptn1l2f243jbridvg53', NULL, NULL, 'cart', '2017-08-31 18:57:47', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('405', '0', 'pfsu8h4m035tee6gcrb29kf7v2', NULL, NULL, 'cart', '2017-08-31 18:57:58', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('406', '0', 'okrql4h7k3rk9kleladhsrh026', NULL, NULL, 'cart', '2017-08-31 18:58:10', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('407', '0', 'c78mh5t4idlolptrp53cp7r0r3', NULL, NULL, 'cart', '2017-08-31 18:58:21', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('408', '0', 'gqjome57k0u43cnt01dlh6doq6', NULL, NULL, 'cart', '2017-08-31 19:05:46', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('409', '0', '8utstfkfhukmfia8rblnn2c806', NULL, NULL, 'cart', '2017-08-31 19:10:32', '0000-00-00 00:00:00', '66.249.73.28', '', 'chrome', '{\"is_mobile\":true}'), ('410', '0', 'kkfulidprf9te0eteu3efltno5', NULL, NULL, 'cart', '2017-08-31 19:13:01', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('411', '0', '1ipnb7p8ooe7a2k1trdv7u4le3', NULL, NULL, 'cart', '2017-08-31 19:14:09', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('412', '0', 'igj1sm2io99q8kurtjh8o9g194', NULL, NULL, 'cart', '2017-08-31 19:38:53', '0000-00-00 00:00:00', '79.106.209.22', '', 'chrome', '{\"is_mobile\":false}'), ('413', '0', 'fjihokse8avnbmt03q72sj6vv5', NULL, NULL, 'cart', '2017-08-31 20:00:38', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('414', '0', 'oluhduu03i0u45d0sto39ciq40', NULL, NULL, 'cart', '2017-08-31 20:04:13', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('415', '0', '94fj005o4bq0778a99udgg1kb7', NULL, NULL, 'cart', '2017-08-31 20:06:07', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('416', '0', '71flq4jhipfna4jnql1d2v18o0', NULL, NULL, 'cart', '2017-08-31 20:26:05', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('417', '0', 'f68qrpr65mou2ri7ocfpggen37', NULL, NULL, 'cart', '2017-08-31 20:38:18', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('418', '0', '9ihp75n9uk1mbqueibct6d6o54', NULL, NULL, 'cart', '2017-08-31 20:43:41', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('419', '0', 'u57nrlmdgkvqjhpgumurkr95h6', NULL, NULL, 'cart', '2017-08-31 20:43:58', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('420', '0', '7vtnrth304eomc7hmek38ucj41', NULL, NULL, 'cart', '2017-08-31 20:44:55', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('421', '0', 'eab3g03mplo052sl77jfv8iss3', NULL, NULL, 'cart', '2017-08-31 20:46:26', '0000-00-00 00:00:00', '66.249.73.26', '', 'chrome', '{\"is_mobile\":true}'), ('422', '0', '15big00sfguab1ak3a851ag214', NULL, NULL, 'cart', '2017-08-31 20:48:46', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('423', '0', 'c0kddhrrfrlddgmkfifk5h0td5', NULL, NULL, 'cart', '2017-08-31 20:51:24', '0000-00-00 00:00:00', '66.249.73.28', '', 'chrome', '{\"is_mobile\":true}'), ('424', '0', 'u9vjmfroita8hsjtq5764omt23', NULL, NULL, 'cart', '2017-08-31 20:52:49', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('425', '0', '5pj0urec9q32e23lnhlhu1r4g3', NULL, NULL, 'cart', '2017-08-31 20:53:51', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('426', '0', 'upinmaa19h5kg68fvgdb0o69i3', NULL, NULL, 'cart', '2017-08-31 20:58:21', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('427', '0', '3t12uh390p22qvtdn9avb344h0', NULL, NULL, 'cart', '2017-08-31 20:59:06', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('428', '0', 'g222qjciot2e0m2d6be10d3ft4', NULL, NULL, 'cart', '2017-08-31 20:59:19', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('429', '0', 'vla48arkdkt5hlaobv72e72vg5', NULL, NULL, 'cart', '2017-08-31 20:59:30', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('430', '0', 'udkgscp8olh4djc6d2u71mk496', NULL, NULL, 'cart', '2017-08-31 21:02:43', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('431', '0', 'fdqp16lohdsnj00pdukupelun2', NULL, NULL, 'cart', '2017-08-31 21:03:37', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('432', '0', 'cen9l2p96dbvsua328pkj2qcc2', NULL, NULL, 'cart', '2017-08-31 21:04:31', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('433', '0', 'p8uhvv7al4vrll9412mhnpgcu1', NULL, NULL, 'cart', '2017-08-31 21:08:35', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('434', '0', 'ne9i0krfscvqiiu5t578spgf60', NULL, NULL, 'cart', '2017-08-31 21:11:36', '0000-00-00 00:00:00', '66.249.73.27', '', 'chrome', '{\"is_mobile\":true}'), ('435', '0', 'bulkrcremg0r5633befdjksld2', NULL, NULL, 'cart', '2017-08-31 21:11:58', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('436', '0', 'of3nku5e5ilqgbgknuf22crpu6', NULL, NULL, 'cart', '2017-08-31 21:12:29', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('437', '0', 'r3kmr4ahemlj6htpt4aumb30c3', NULL, NULL, 'cart', '2017-08-31 21:12:57', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('438', '0', 'e6un5f7v4ku0t8n32huc62hbk3', NULL, NULL, 'cart', '2017-08-31 21:13:28', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('439', '0', '0itg6rto6nlnbl5mn8bilpgv11', NULL, NULL, 'cart', '2017-08-31 21:13:51', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('440', '0', '05f59docbf2fipr5v8966qnr57', NULL, NULL, 'cart', '2017-08-31 21:14:00', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('441', '0', 'j83hdro5vsnfbf365ulm9k66k2', NULL, NULL, 'cart', '2017-08-31 21:14:07', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('442', '0', 'ba98ipd98tg8d8slrft3dm7d80', NULL, NULL, 'cart', '2017-08-31 21:14:16', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('443', '0', '66v0es227m2p238inkkqaeaje2', NULL, NULL, 'cart', '2017-08-31 21:14:57', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('444', '0', 'ps6gbu28nq3jssuk5785l56e92', NULL, NULL, 'cart', '2017-08-31 21:17:00', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('445', '0', 'pfmt8t96v96l4gdf9re252c6k2', NULL, NULL, 'cart', '2017-08-31 21:18:00', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('446', '0', 'enp37p0n7eheq1aq2tbcopup64', NULL, NULL, 'cart', '2017-08-31 21:19:28', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('447', '0', '5r8hhpjob6nenh1vjugoumes34', NULL, NULL, 'cart', '2017-08-31 21:24:48', '0000-00-00 00:00:00', '184.154.139.46', '', 'msie', '{\"is_mobile\":false}'), ('448', '0', '9sfnn88a9tthek06g6duq0l9b7', NULL, NULL, 'cart', '2017-08-31 22:03:42', '0000-00-00 00:00:00', '46.161.9.6', '', 'opera', '{\"is_mobile\":false}'), ('449', '0', 'ejhs62rgblrll6ka53p3de2sh6', NULL, NULL, 'cart', '2017-08-31 22:04:58', '0000-00-00 00:00:00', '66.249.73.26', '', 'chrome', '{\"is_mobile\":true}'), ('450', '0', 'o3q1re8snta2mlb0jn0ldisvq4', NULL, NULL, 'cart', '2017-08-31 22:20:09', '0000-00-00 00:00:00', '66.249.73.26', '', 'chrome', '{\"is_mobile\":true}'), ('451', '0', 'l00v74k7of45a4935dk6ngfnc3', NULL, NULL, 'cart', '2017-08-31 22:22:20', '0000-00-00 00:00:00', '66.249.73.26', '', 'chrome', '{\"is_mobile\":true}'), ('452', '0', '5j3uv54nkipirpgnatr6vlqv61', NULL, NULL, 'cart', '2017-08-31 22:57:01', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('453', '0', '333va6p00b4qsudoirlue4fic1', NULL, NULL, 'cart', '2017-08-31 23:01:21', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('454', '0', 'dfcma2a0k0jeisk9mjs95dq1r1', NULL, NULL, 'cart', '2017-08-31 23:05:43', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('455', '0', 'uviujj06kvbsj1nq756st932c0', NULL, NULL, 'cart', '2017-08-31 23:33:53', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('456', '0', '0bfiq57lldans1pldb4969js13', NULL, NULL, 'cart', '2017-09-01 00:23:13', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('457', '0', 'ta1u641cn5v4je3n4a9s5kkk70', NULL, NULL, 'cart', '2017-09-01 00:25:23', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('458', '0', 'q88srmv3vm0ojk5qggoakra7t4', NULL, NULL, 'cart', '2017-09-01 00:31:53', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('459', '0', 'tk577sqq7p0asb2goo8k1fetf3', NULL, NULL, 'cart', '2017-09-01 00:34:03', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('460', '0', 'r0blffgv5us97gbdumrqo4ord4', NULL, NULL, 'cart', '2017-09-01 01:08:45', '0000-00-00 00:00:00', '66.249.73.28', '', 'chrome', '{\"is_mobile\":true}'), ('461', '0', 'in42eds2t0p7m73gpvclv4qs40', NULL, NULL, 'cart', '2017-09-01 01:10:55', '0000-00-00 00:00:00', '66.249.73.28', '', 'chrome', '{\"is_mobile\":true}'), ('462', '0', '4e69rrttrd2pirfc4brqvbqtu5', NULL, NULL, 'cart', '2017-09-01 01:19:35', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('463', '0', '4m55bkmt4q46obhpqs2hi8ecr2', NULL, NULL, 'cart', '2017-09-01 01:23:56', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('464', '0', 'nltl90vnj3u3sul9ut3ks8d250', NULL, NULL, 'cart', '2017-09-01 01:45:17', '0000-00-00 00:00:00', '77.75.77.36', '', 'mozilla', '{\"is_mobile\":false}'), ('465', '0', '9qlta1k67hd2qidc1v7vvd5o22', NULL, NULL, 'cart', '2017-09-01 02:09:00', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('466', '0', 'm1au3aahjnbidau50in1v0mev4', NULL, NULL, 'cart', '2017-09-01 02:33:21', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('467', '0', 'g2tsdv3umlpuf22hnko1a98q14', NULL, NULL, 'cart', '2017-09-01 03:49:27', '0000-00-00 00:00:00', '66.249.73.11', '', 'mozilla', '{\"is_mobile\":false}'), ('468', '0', '2663d0l58c9u2kfcjgjufe3cl4', NULL, NULL, 'cart', '2017-09-01 03:57:56', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('469', '0', 'hjr8pn21vrsojv46lpod9ofif1', NULL, NULL, 'cart', '2017-09-01 04:26:08', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('470', '0', 'i3l38iu6dpjej2dnkhndg4v3v6', NULL, NULL, 'cart', '2017-09-01 05:01:07', '0000-00-00 00:00:00', '66.249.73.26', '', 'chrome', '{\"is_mobile\":true}'), ('471', '0', 'qgdnso7s8uu2h6bqugrjese7c1', NULL, NULL, 'cart', '2017-09-01 05:22:29', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('472', '0', 'fo8jticrv8mb80r3belk7g9bb3', NULL, NULL, 'cart', '2017-09-01 05:46:22', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('473', '0', '6rsltvdmguoopk6jmv1m2dh355', NULL, NULL, 'cart', '2017-09-01 06:19:11', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('474', '0', 'ee2v2l0am3drcvct4vjv7ngm84', NULL, NULL, 'cart', '2017-09-01 06:21:04', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('475', '0', '0gnabof20ohs94qf1h6a6t3q83', NULL, NULL, 'cart', '2017-09-01 06:42:50', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('476', '0', 'fvoh4fgq56s62bploftud2emi0', NULL, NULL, 'cart', '2017-09-01 06:44:54', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('477', '0', '6ghqd4v6phec4nisn6ou3lico1', NULL, NULL, 'cart', '2017-09-01 06:49:14', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('478', '0', 'iavk8hoosu3i18cbs49sb784j6', NULL, NULL, 'cart', '2017-09-01 06:53:34', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('479', '0', '697vnn9c2jv0j91k83a8uhcpj1', NULL, NULL, 'cart', '2017-09-01 06:55:45', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('480', '0', '6ocmdmfjkvf9s7cg99dc9e2rj6', NULL, NULL, 'cart', '2017-09-01 07:26:32', '0000-00-00 00:00:00', '207.241.225.249', '', 'mozilla', '{\"is_mobile\":false}'), ('481', '0', '61ffd9bmgb8gikb2ilk95c27r6', NULL, NULL, 'cart', '2017-09-01 07:52:12', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('482', '0', 'c92v9r7m2au5p6uemd8vlttoh4', NULL, NULL, 'cart', '2017-09-01 07:54:18', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('483', '0', 'cupu2s91r3ll0uope1ucm2p090', NULL, NULL, 'cart', '2017-09-01 08:25:13', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('484', '0', '2sndfc07lfo6nu3onhla7off03', NULL, NULL, 'cart', '2017-09-01 08:41:04', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('485', '0', 'pgn5o00mfv5jrliknpc1qs9cu1', NULL, NULL, 'cart', '2017-09-01 08:53:06', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('486', '0', 'kfhi6jl7shoq2268aftar3uh44', NULL, NULL, 'cart', '2017-09-01 09:14:08', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('487', '0', '9eo55l9joiadqdnf238o2igsn3', NULL, NULL, 'cart', '2017-09-01 09:17:34', '0000-00-00 00:00:00', '66.249.73.28', '', 'mozilla', '{\"is_mobile\":false}'), ('488', '0', 'ghkb1p266de0adcto9qjqm2684', NULL, NULL, 'cart', '2017-09-01 09:32:10', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('489', '0', 'f189poheee9s21tc0ur5tjucr5', NULL, NULL, 'cart', '2017-09-01 09:51:24', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('490', '0', 'gk0djhp6kiq74pvv32fgcnlhd2', NULL, NULL, 'cart', '2017-09-01 10:29:25', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('491', '0', 'vt1rjvfciafu0b9dpesd289hc3', NULL, NULL, 'cart', '2017-09-01 10:31:21', '0000-00-00 00:00:00', '188.109.23.54', '', 'chrome', '{\"is_mobile\":false}'), ('492', '0', '0fo4pcbpq094cgp4j6tpu5lc90', NULL, NULL, 'cart', '2017-09-01 10:36:29', '0000-00-00 00:00:00', '109.201.142.113', '', 'safari', '{\"is_mobile\":false}'), ('493', '0', 'aakngeifant805q6pl12155vs5', NULL, NULL, 'cart', '2017-09-01 10:55:51', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('494', '0', 'u96f2ghst6g425oqg2ar5q9ku4', NULL, NULL, 'cart', '2017-09-01 10:57:18', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('495', '0', '8p7agq85fq7q7hm728uhcl61f0', NULL, NULL, 'cart', '2017-09-01 10:57:29', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('496', '0', 'crotu2efj2lt1kg09vtq3ffla1', NULL, NULL, 'cart', '2017-09-01 10:58:13', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('497', '0', 'kcu9tu67m41neaog7j5q1b8pn3', NULL, NULL, 'cart', '2017-09-01 11:28:32', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('498', '0', 'mg2j2a88cfdnpc9k6fcrs5ti63', NULL, NULL, 'cart', '2017-09-01 11:34:43', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('499', '0', '8j419r5oj12m7qp6pgb4e08ba2', NULL, NULL, 'cart', '2017-09-01 11:58:11', '0000-00-00 00:00:00', '46.228.16.206', '', 'mozilla', '{\"is_mobile\":false}'), ('500', '0', 'ls26tb4sdd9ojkvt44n7j0j9m4', NULL, NULL, 'cart', '2017-09-01 12:01:50', '0000-00-00 00:00:00', '66.249.73.28', '', 'chrome', '{\"is_mobile\":true}'), ('501', '0', '37cl6bsn05m174e009422sn0l3', NULL, NULL, 'cart', '2017-09-01 12:36:35', '2017-09-01 12:42:06', '101.160.146.133', '', 'chrome', '{\"is_mobile\":false}'), ('502', '0', 'dcvnje8h07eut7ms2vj13c6m26', NULL, NULL, 'cart', '2017-09-01 13:03:00', '0000-00-00 00:00:00', '66.249.73.27', '', 'chrome', '{\"is_mobile\":true}'), ('503', '0', '7mce09krg4a1he59c1r4djbo64', NULL, NULL, 'cart', '2017-09-01 13:11:12', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('504', '0', 'pc9g1ihtb6996mg897v7s498m3', NULL, NULL, 'cart', '2017-09-01 13:18:52', '0000-00-00 00:00:00', '66.249.93.200', '', 'chrome', '{\"is_mobile\":false}'), ('505', '0', 'an0gju537fhkjgn8no5ni9l5k3', NULL, NULL, 'cart', '2017-09-01 13:31:02', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('506', '0', 'e5gc81iof01ka3cd2ufcqghjg0', NULL, NULL, 'cart', '2017-09-01 13:36:12', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('507', '0', 'u1qklu9r8428o2aua959g8nj85', NULL, NULL, 'cart', '2017-09-01 14:02:46', '0000-00-00 00:00:00', '173.249.71.114', '', 'mozilla', '{\"is_mobile\":false}'), ('508', '0', 'nad7no06p09okvboamfj6kfaa7', NULL, NULL, 'cart', '2017-09-01 14:03:33', '0000-00-00 00:00:00', '54.189.78.78', '', 'msie', '{\"is_mobile\":false}'), ('509', '0', 'qn000plk2s280pk29o62hahc42', NULL, NULL, 'cart', '2017-09-01 14:14:39', '0000-00-00 00:00:00', '66.249.73.27', '', 'chrome', '{\"is_mobile\":true}'), ('510', '0', '2h5jqa8emanm822q1qluddv9r3', NULL, NULL, 'cart', '2017-09-01 14:57:18', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('511', '0', '48e64mmki224qbk7hn5r3h93a3', NULL, NULL, 'cart', '2017-09-01 15:02:22', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('512', '0', 'viiqgtj197uijopak7a5m6c0b1', NULL, NULL, 'cart', '2017-09-01 15:07:34', '0000-00-00 00:00:00', '40.77.167.77', '', 'mozilla', '{\"is_mobile\":false}'), ('513', '0', 'd9fgao0niiuoj6ru679mq94m16', NULL, NULL, 'cart', '2017-09-01 15:15:42', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('514', '0', 'gb3bbddthqiok75lq6q6sifmb7', NULL, NULL, 'cart', '2017-09-01 15:56:01', '0000-00-00 00:00:00', '66.249.73.27', '', 'mozilla', '{\"is_mobile\":false}'), ('515', '0', '4j59c60hkvq6qirfl1487kgh81', NULL, NULL, 'cart', '2017-09-01 15:58:24', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('516', '0', 'j1bshru8anvllafhq5gtn94j22', NULL, NULL, 'cart', '2017-09-01 15:59:31', '0000-00-00 00:00:00', '66.249.73.26', '', 'mozilla', '{\"is_mobile\":false}'), ('517', '0', 'ivvsj5cvvdilfaqm2em450u410', NULL, NULL, 'cart', '2017-09-01 16:27:28', '0000-00-00 00:00:00', '66.249.73.26', '', 'chrome', '{\"is_mobile\":true}'), ('518', '0', 'j1g4aarfviceb3vtku23vkbfh3', NULL, NULL, 'cart', '2017-09-01 17:05:40', '0000-00-00 00:00:00', '66.249.79.4', '', 'chrome', '{\"is_mobile\":true}'), ('519', '0', 'sn6d7gj081blulc4bs0iqhnos2', NULL, NULL, 'cart', '2017-09-01 17:22:11', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('520', '0', 'mcrem4muo9736s8nnkqsa0aes6', NULL, NULL, 'cart', '2017-09-01 17:32:10', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('521', '0', '2p72m2iai4bs6l48ms9o9ev3h1', NULL, NULL, 'cart', '2017-09-01 17:57:07', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('522', '0', 'l3l8lbu0rkov14knnr6at08744', NULL, NULL, 'cart', '2017-09-01 19:45:16', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('523', '0', 'dhf1rl2velrubvdnoh0oees032', NULL, NULL, 'cart', '2017-09-01 21:07:29', '2017-09-01 21:08:03', '2.247.254.167', '', 'mozilla', '{\"is_mobile\":false}'), ('524', '0', '7545t3718i2vpsdmb1tdb5cvb5', NULL, NULL, 'cart', '2017-09-01 21:20:25', '0000-00-00 00:00:00', '184.154.139.47', '', 'msie', '{\"is_mobile\":false}'), ('525', '0', 'kif1mfobjb1dbc3tcjcbmgge16', NULL, NULL, 'cart', '2017-09-01 23:13:50', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('526', '0', 'vjcdsers98tro3b2smmqac6kn0', NULL, NULL, 'cart', '2017-09-01 23:34:57', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('527', '0', '7krvfidmi4l63njf09ue0cdgn1', NULL, NULL, 'cart', '2017-09-02 00:19:33', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('528', '0', 'v5iesj19uqtraq947gejsdden3', NULL, NULL, 'cart', '2017-09-02 00:33:56', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('529', '0', 'c62bjag12hdoohe75nsf6hv7k5', NULL, NULL, 'cart', '2017-09-02 01:05:22', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('530', '0', '91sfqbbfi9v5sph0ghbgjajen3', NULL, NULL, 'cart', '2017-09-02 02:32:06', '0000-00-00 00:00:00', '40.77.167.77', '', 'mozilla', '{\"is_mobile\":false}'), ('531', '0', '60nu2o0ljdmravlktoh9n8qdn7', NULL, NULL, 'cart', '2017-09-02 03:14:52', '0000-00-00 00:00:00', '66.249.79.24', '', 'chrome', '{\"is_mobile\":true}'), ('532', '0', 'cfaq62qef6ich9mtjqqb3bad26', NULL, NULL, 'cart', '2017-09-02 03:59:42', '0000-00-00 00:00:00', '66.249.79.26', '', 'mozilla', '{\"is_mobile\":false}'), ('533', '0', 'll8h9md16q94q2am7qagka1pq0', NULL, NULL, 'cart', '2017-09-02 04:23:14', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('534', '0', 'nvdaem858f172h532q0v5to1v7', NULL, NULL, 'cart', '2017-09-02 05:51:52', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('535', '0', 't5qf9p0gsaagt40skeskq5u720', NULL, NULL, 'cart', '2017-09-02 08:51:48', '0000-00-00 00:00:00', '66.249.79.24', '', 'chrome', '{\"is_mobile\":true}'), ('536', '0', 'lkmdsjsdsklmv9f0fnagvo49s7', NULL, NULL, 'cart', '2017-09-02 10:01:09', '0000-00-00 00:00:00', '141.8.143.177', '', 'mozilla', '{\"is_mobile\":false}'), ('537', '0', 'ikchno15mvhvs0g1r7vg27lja5', NULL, NULL, 'cart', '2017-09-02 10:01:17', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('538', '0', 'pnd9se9jb23bqpkrircqvs3s53', NULL, NULL, 'cart', '2017-09-02 10:35:35', '0000-00-00 00:00:00', '141.8.143.177', '', 'mozilla', '{\"is_mobile\":false}'), ('539', '0', 'kblsdn1mhj0duql5oe7m11ed22', NULL, NULL, 'cart', '2017-09-02 11:31:32', '2017-09-02 11:33:25', '41.225.144.72', '', 'chrome', '{\"is_mobile\":false}'), ('540', '0', 'ojfs7j9o8sprktu4bn3rnr5m86', NULL, NULL, 'cart', '2017-09-02 12:56:46', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('541', '0', '7m5aeem4fddcoicgjq0e0qgkc5', NULL, NULL, 'cart', '2017-09-02 15:25:19', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('542', '0', 'o8t74f2ft30ep88h05u8rdq127', NULL, NULL, 'cart', '2017-09-02 15:29:26', '0000-00-00 00:00:00', '66.249.79.26', '', 'mozilla', '{\"is_mobile\":false}'), ('543', '0', 'drqqf353kai4dda1c0or72ruh6', NULL, NULL, 'cart', '2017-09-02 16:20:13', '0000-00-00 00:00:00', '190.148.39.161', '', 'chrome', '{\"is_mobile\":false}'), ('544', '0', 'tefiuhjqa2q9g2cijipmnj6f95', NULL, NULL, 'cart', '2017-09-02 16:47:15', '0000-00-00 00:00:00', '77.88.5.57', '', 'mozilla', '{\"is_mobile\":false}'), ('545', '0', 'caqdiat17ekd2nqhmlbs36okb0', NULL, NULL, 'cart', '2017-09-02 16:58:08', '0000-00-00 00:00:00', '50.89.63.46', '', 'mozilla', '{\"is_mobile\":false}'), ('546', '0', 'ri5qni9i3ci1r4r1i18hj7r387', NULL, NULL, 'cart', '2017-09-02 17:54:18', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('547', '0', 'hd8rcauc8t6e5gb9r3rv7jfba0', NULL, NULL, 'cart', '2017-09-02 20:19:15', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('548', '0', 'cr13v5redmu10oajri9fvoj9p7', NULL, NULL, 'cart', '2017-09-02 21:17:51', '0000-00-00 00:00:00', '184.154.139.24', '', 'msie', '{\"is_mobile\":false}'), ('549', '0', '1m5fre7oc0cl0s98hrel70r4v4', NULL, NULL, 'cart', '2017-09-02 22:33:51', '0000-00-00 00:00:00', '77.88.5.57', '', 'mozilla', '{\"is_mobile\":false}'), ('550', '0', 'srn6jr8n85at2r1rta9inssu67', NULL, NULL, 'cart', '2017-09-02 23:46:58', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('551', '0', '8ae71qbmo64nllpai4dru6g7c4', NULL, NULL, 'cart', '2017-09-02 23:51:18', '0000-00-00 00:00:00', '77.88.5.57', '', 'mozilla', '{\"is_mobile\":false}'), ('552', '0', 'lhqja0c4as4aroprongq1asdr4', NULL, NULL, 'cart', '2017-09-03 00:04:12', '0000-00-00 00:00:00', '176.193.176.128', '', 'msie', '{\"is_mobile\":false}'), ('553', '0', '8a7uip5ear599h3hokukr851l3', NULL, NULL, 'cart', '2017-09-03 00:52:10', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('554', '0', 'l8tcb9up9294hnekr52tdgv2s2', NULL, NULL, 'cart', '2017-09-03 01:13:38', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('555', '0', 'r9cod939a0lg1330toeavo3643', NULL, NULL, 'cart', '2017-09-03 02:20:11', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('556', '0', '818sf2ufg0tu4ibnere70ipn53', NULL, NULL, 'cart', '2017-09-03 03:32:42', '2017-09-03 03:34:00', '70.173.47.48', '', 'chrome', '{\"is_mobile\":false}'), ('557', '0', 'pbsaaut66hrd6v3qgj9g0p1k22', NULL, NULL, 'cart', '2017-09-03 04:16:20', '0000-00-00 00:00:00', '5.255.250.124', '', 'mozilla', '{\"is_mobile\":false}'), ('558', '0', '3hmsv2gnb2tkb6dpb5eel5sdj6', NULL, NULL, 'cart', '2017-09-03 04:47:13', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('559', '0', '9d14pqtd85i6gv4fa5qgovn466', NULL, NULL, 'cart', '2017-09-03 05:38:15', '0000-00-00 00:00:00', '66.249.93.200', '', 'chrome', '{\"is_mobile\":false}'), ('560', '0', 'c80ocgm0h39j60qaouec6602i5', NULL, NULL, 'cart', '2017-09-03 05:49:27', '0000-00-00 00:00:00', '66.249.79.4', '', 'chrome', '{\"is_mobile\":true}'), ('561', '0', 'j2d9lm9542ovcrp6fag0m372h3', NULL, NULL, 'cart', '2017-09-03 05:52:49', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('562', '0', 'ei6r3a01pshaiqnlfe4c3tifl1', NULL, NULL, 'cart', '2017-09-03 05:54:31', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('563', '0', '5lohhvjr0ve712q8kk0a537e05', NULL, NULL, 'cart', '2017-09-03 05:56:11', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('564', '0', '7cqj4t0qsaj4799l9kleniu623', NULL, NULL, 'cart', '2017-09-03 06:16:27', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('565', '0', 'n6h70s58g0f37sn1hd237a8is5', NULL, NULL, 'cart', '2017-09-03 06:21:25', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('566', '0', 'bpbs4oc552k5qso14pbkq35dv6', NULL, NULL, 'cart', '2017-09-03 06:46:43', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('567', '0', '3jal5ir9lrcitv4pa664k4r7k1', NULL, NULL, 'cart', '2017-09-03 06:57:36', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('568', '0', 'g2lsmmppiv73bmg811m9c76230', NULL, NULL, 'cart', '2017-09-03 07:08:58', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('569', '0', '4tgne49iu1gik6hrm8rnect7v5', NULL, NULL, 'cart', '2017-09-03 07:11:53', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('570', '0', '64jngg6qagjvi03ot2ng8rfjr1', NULL, NULL, 'cart', '2017-09-03 07:27:01', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('571', '0', '3utugbaqqo74f2kr6n5bu58e81', NULL, NULL, 'cart', '2017-09-03 07:27:28', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('572', '0', 'n2le16ke13r6hgg0d7tio7g7k5', NULL, NULL, 'cart', '2017-09-03 07:28:42', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('573', '0', 'ugkguf7ldlfovopjmgaj7um745', NULL, NULL, 'cart', '2017-09-03 07:32:04', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('574', '0', '5q9ppdmehv9q2539tomhgfkm43', NULL, NULL, 'cart', '2017-09-03 07:42:10', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('575', '0', '3067oo4b6k2t7ja65g8lhc1h27', NULL, NULL, 'cart', '2017-09-03 07:47:25', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('576', '0', 't88rrh60pgbiiueli6u46lcb01', NULL, NULL, 'cart', '2017-09-03 07:57:30', '2017-09-03 08:02:20', '112.110.128.168', '', 'safari', '{\"is_mobile\":true}'), ('577', '0', '4js59arj9t553ftibuqc9k1pt2', NULL, NULL, 'cart', '2017-09-03 07:58:59', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('578', '0', 'br1lnc63a1l2fvhppfkp8p16d5', NULL, NULL, 'cart', '2017-09-03 08:06:37', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('579', '0', 'gbpshfacokjfr10sve4g6n7ei3', NULL, NULL, 'cart', '2017-09-03 08:44:31', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('580', '0', 'jbkkb6osl33m4c32o5494o0ok0', NULL, NULL, 'cart', '2017-09-03 09:55:28', '0000-00-00 00:00:00', '66.249.79.4', '', 'chrome', '{\"is_mobile\":true}'), ('581', '0', 'npaa867s8d0nu3t0i4oh552da6', NULL, NULL, 'cart', '2017-09-03 09:56:48', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('582', '0', 'vsauj7vellcdkkf6vohal8hk32', NULL, NULL, 'cart', '2017-09-03 10:22:02', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('583', '0', 'gbssshmjo6unrcrn5abjblo710', NULL, NULL, 'cart', '2017-09-03 10:23:40', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('584', '0', 't3lr9j2qs86mnr1t384pi4ue45', NULL, NULL, 'cart', '2017-09-03 11:29:37', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('585', '0', '27gnb6dm07k1c8a4jpt7rc95g5', NULL, NULL, 'cart', '2017-09-03 11:46:47', '0000-00-00 00:00:00', '5.255.250.124', '', 'mozilla', '{\"is_mobile\":false}'), ('586', '0', 'garg0h3q5nq10etmlhbo11q0h7', NULL, NULL, 'cart', '2017-09-03 12:20:23', '0000-00-00 00:00:00', '66.249.79.30', '', 'chrome', '{\"is_mobile\":true}'), ('587', '0', 'oirkjagk0a2num64phc1hkbtn4', NULL, NULL, 'cart', '2017-09-03 12:22:36', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('588', '0', '5t92sv2dkm1gos1nb6bitsqkc3', NULL, NULL, 'cart', '2017-09-03 12:23:29', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('589', '0', 'qk7al0in6crmj7glohq7bqsfe5', NULL, NULL, 'cart', '2017-09-03 13:57:22', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('590', '0', 'qkm5c9al8jo96c2fplqtgc58l0', NULL, NULL, 'cart', '2017-09-03 13:57:24', '0000-00-00 00:00:00', '77.88.5.57', '', 'mozilla', '{\"is_mobile\":false}'), ('591', '0', '8k76bq4f2gaeusoor8001ng900', NULL, NULL, 'cart', '2017-09-03 15:17:04', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('592', '0', '0e9t1044r0mrdrcev2882fs874', NULL, NULL, 'cart', '2017-09-03 15:22:23', '0000-00-00 00:00:00', '89.42.145.20', '', 'opera', '{\"is_mobile\":false}'), ('593', '0', 'oao85ddkoeclu3ggoho4c3i2d5', NULL, NULL, 'cart', '2017-09-03 15:26:15', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('594', '0', 't6hnd2ophd65nouhu61v3shqg5', NULL, NULL, 'cart', '2017-09-03 16:27:45', '0000-00-00 00:00:00', '66.249.79.30', '', 'chrome', '{\"is_mobile\":true}'), ('595', '0', 'e0lntppor3i70stqjham40td03', NULL, NULL, 'cart', '2017-09-03 16:40:38', '0000-00-00 00:00:00', '174.65.171.23', '', 'chrome', '{\"is_mobile\":true}'), ('596', '0', 'o1ldaqhhggrn06m1l8v08uif67', NULL, NULL, 'cart', '2017-09-03 16:52:41', '2017-09-03 16:56:06', '85.101.176.234', '', 'chrome', '{\"is_mobile\":false}'), ('597', '0', '5tp6rtrmk870ov21lvdilcd9v3', NULL, NULL, 'cart', '2017-09-03 17:20:45', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('598', '0', 's1co9i7394i32f59bs695oodv0', NULL, NULL, 'cart', '2017-09-03 17:26:06', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('599', '0', 'gk455qiiakmo3k2vnvio3pbjl4', NULL, NULL, 'cart', '2017-09-03 18:02:49', '0000-00-00 00:00:00', '5.255.250.124', '', 'mozilla', '{\"is_mobile\":false}'), ('600', '0', '98jnrn6d4ahibm34p61r4l6f27', NULL, NULL, 'cart', '2017-09-03 18:43:45', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('601', '0', '2o88r44la48mmba54hkumhftv1', NULL, NULL, 'cart', '2017-09-03 19:03:27', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('602', '0', 'di3o7f3sdk94r83vbv61hvk177', NULL, NULL, 'cart', '2017-09-03 19:17:48', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('603', '0', 'lvjs6otmgilhrj5abr9eu516a1', NULL, NULL, 'cart', '2017-09-03 19:50:40', '0000-00-00 00:00:00', '106.223.68.54', '', 'chrome', '{\"is_mobile\":false}'), ('604', '0', '7efs4t9efe06bbq2j5v8tnp7g7', NULL, NULL, 'cart', '2017-09-03 20:09:01', '0000-00-00 00:00:00', '77.75.77.119', '', 'mozilla', '{\"is_mobile\":false}'), ('605', '0', '9bstchcsg9ulae48epcrnj0rn4', NULL, NULL, 'cart', '2017-09-03 20:17:21', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('606', '0', 'neer50732j7avphks8p4b2lii3', NULL, NULL, 'cart', '2017-09-03 20:30:09', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('607', '0', '125k3trs8db290osbnvtie12o5', NULL, NULL, 'cart', '2017-09-03 21:00:36', '0000-00-00 00:00:00', '77.88.5.57', '', 'mozilla', '{\"is_mobile\":false}'), ('608', '0', 'h3gptvb0c207fl12ug68rno851', NULL, NULL, 'cart', '2017-09-03 21:14:52', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('609', '0', 'gj0gaoshg1qaqjt44054i289s4', NULL, NULL, 'cart', '2017-09-03 21:20:38', '0000-00-00 00:00:00', '184.154.139.46', '', 'msie', '{\"is_mobile\":false}'), ('610', '0', 'pi529euh6bb2ugsgfogl2098v4', NULL, NULL, 'cart', '2017-09-03 21:27:44', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('611', '0', 'q26rc7bmgi96cb7o85j543fqp4', NULL, NULL, 'cart', '2017-09-03 22:03:37', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('612', '0', 'qdte3arni4e8rmgo70k2ide822', NULL, NULL, 'cart', '2017-09-03 22:28:27', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('613', '0', 'rmpt9vhnlpo0u4ap6uoskh82m7', NULL, NULL, 'cart', '2017-09-03 23:18:32', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('614', '0', 'upu2qm9ghqcua5142aohaqci33', NULL, NULL, 'cart', '2017-09-04 03:50:50', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('615', '0', 'o8dbp9q486nepkfqq37heh4ta4', NULL, NULL, 'cart', '2017-09-04 04:50:45', '0000-00-00 00:00:00', '88.80.21.102', '', 'opera', '{\"is_mobile\":false}'), ('616', '0', 'qaeoibpq9d0p18qm2upuqmeme7', NULL, NULL, 'cart', '2017-09-04 05:40:50', '2017-09-04 05:49:48', '103.25.44.2', '', 'mozilla', '{\"is_mobile\":false}'), ('617', '0', '7qlre94bgnrf1fn3ule2ag8nm7', NULL, NULL, 'cart', '2017-09-04 06:29:25', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('618', '0', 'hjp29fg4cdduvcuiplgsp61cn3', NULL, NULL, 'cart', '2017-09-04 06:48:13', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('619', '0', 'd990vr2ksvirul9k4n724jasq6', NULL, NULL, 'cart', '2017-09-04 06:53:14', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('620', '0', '0p84k3viqngtnj1bk19vcvmnk4', NULL, NULL, 'cart', '2017-09-04 07:17:48', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('621', '0', 'n2o3v59j5656v9e9h0rsmn66d3', NULL, NULL, 'cart', '2017-09-04 09:17:33', '0000-00-00 00:00:00', '178.162.205.100', '', 'mozilla', '{\"is_mobile\":false}'), ('622', '0', '9p29rbvlj3aebtppgd2gdmukq1', NULL, NULL, 'cart', '2017-09-04 09:40:57', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('623', '0', 'khjsbkcan033tuh63ejc3e7gr6', NULL, NULL, 'cart', '2017-09-04 09:59:41', '2017-09-04 10:54:11', '178.162.205.100', '', 'mozilla', '{\"is_mobile\":false}'), ('624', '0', 'ojqb8mj6rvqtkgn12127onpni5', NULL, NULL, 'cart', '2017-09-04 10:54:09', '0000-00-00 00:00:00', '178.162.205.100', '', 'mozilla', '{\"is_mobile\":false}'), ('625', '0', 'hbp5clg5as2egcrvs4alof4rc6', NULL, NULL, 'cart', '2017-09-04 11:26:56', '0000-00-00 00:00:00', '141.8.144.69', '', 'mozilla', '{\"is_mobile\":false}'), ('626', '0', 'i03s0ggfdq1mchva0tf8bd3m20', NULL, NULL, 'cart', '2017-09-04 11:47:04', '0000-00-00 00:00:00', '84.201.133.42', '', 'mozilla', '{\"is_mobile\":false}'), ('627', '0', '707iv8ih085m9otpq8l6pl9dj7', NULL, NULL, 'cart', '2017-09-04 12:02:50', '0000-00-00 00:00:00', '5.14.249.224', '', 'mozilla', '{\"is_mobile\":false}'), ('628', '0', 'udmc1eju32nhd2v6c47p8ng3j2', NULL, NULL, 'cart', '2017-09-04 12:03:12', '2017-09-04 12:03:37', '5.14.249.224', '', 'mozilla', '{\"is_mobile\":false}'), ('629', '0', '1tst4s4cpekcolkp3d5khn0772', NULL, NULL, 'cart', '2017-09-04 12:14:10', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('630', '0', 'e27m10apci1jbhalt23o9djom4', NULL, NULL, 'cart', '2017-09-04 12:22:19', '0000-00-00 00:00:00', '5.14.249.224', '', 'mozilla', '{\"is_mobile\":false}'), ('631', '0', 'f6mt8hsmrfmn411ec718f389p3', NULL, NULL, 'cart', '2017-09-04 12:28:27', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('632', '0', 'jv31pi4sokr16ilovtl7r84g16', NULL, NULL, 'cart', '2017-09-04 12:50:16', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('633', '0', 'ca63f00saipll6d2s0jq2k2kb6', NULL, NULL, 'cart', '2017-09-04 12:51:35', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('634', '0', '13ep37cq83shfmc3rcdad3kth5', NULL, NULL, 'cart', '2017-09-04 13:28:39', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('635', '0', 'kd8v11l5pvgam504vtbs3mh4e7', NULL, NULL, 'cart', '2017-09-04 14:05:31', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('636', '0', 'h9aobgbovd4bufrk6eoe562lm5', NULL, NULL, 'cart', '2017-09-04 14:09:32', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('637', '0', 'ddvvg2hkitjifm928mj876r6c0', NULL, NULL, 'cart', '2017-09-04 16:39:13', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('638', '0', 'lit4ul2nq1tf9f17kl0albo7d1', NULL, NULL, 'cart', '2017-09-04 16:43:20', '2017-09-04 16:43:51', '171.61.182.248', '', 'mozilla', '{\"is_mobile\":false}'), ('639', '0', 'kcd1ntqou1i3tov6e1vb2bo326', NULL, NULL, 'cart', '2017-09-04 16:48:26', '0000-00-00 00:00:00', '13.76.241.210', '', 'mozilla', '{\"is_mobile\":false}'), ('640', '0', 'fpcnu2a80e19ndiktfee436tk3', NULL, NULL, 'cart', '2017-09-04 16:48:26', '0000-00-00 00:00:00', '104.209.188.207', '', 'mozilla', '{\"is_mobile\":false}'), ('641', '0', '3jq37tggi21ka14ge9je21d276', NULL, NULL, 'cart', '2017-09-04 16:54:07', '0000-00-00 00:00:00', '96.92.182.214', '', 'chrome', '{\"is_mobile\":false}'), ('642', '0', 'hoffpuv2ep83fp2j09g9vl8q55', NULL, NULL, 'cart', '2017-09-04 16:59:41', '0000-00-00 00:00:00', '171.61.182.248', '', 'mozilla', '{\"is_mobile\":false}'), ('643', '0', 'm2rresrh9he5vvfcf7frg51b41', NULL, NULL, 'cart', '2017-09-04 19:01:14', '0000-00-00 00:00:00', '180.76.15.141', '', 'mozilla', '{\"is_mobile\":false}'), ('644', '0', '55gnvo5lahke7alne41l43riu6', NULL, NULL, 'cart', '2017-09-04 19:12:55', '0000-00-00 00:00:00', '87.121.155.175', '', 'chrome', '{\"is_mobile\":false}'), ('645', '0', 'mnotbb4r3pipq0h69k8l2t4u71', NULL, NULL, 'cart', '2017-09-04 20:41:55', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('646', '0', 'eq9vmgfdu8339v5t4ieo5mt5k3', NULL, NULL, 'cart', '2017-09-04 20:43:30', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('647', '0', 'emum6gcg0pmfnvgkdd13ie8as2', NULL, NULL, 'cart', '2017-09-04 20:45:52', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('648', '0', 'gklnvvdc100gr74tkov07l2hb5', NULL, NULL, 'cart', '2017-09-04 21:17:46', '0000-00-00 00:00:00', '184.154.139.47', '', 'msie', '{\"is_mobile\":false}'), ('649', '0', 'l7eo1e5bqq5lvdv6q10b21q3b1', NULL, NULL, 'cart', '2017-09-04 21:43:09', '0000-00-00 00:00:00', '200.100.242.8', '', 'chrome', '{\"is_mobile\":false}'), ('650', '0', 'fu0skklet40c5f8mgb3fjmqkj5', NULL, NULL, 'cart', '2017-09-04 21:59:25', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('651', '0', 'j6cmuh37u7ndrbfv6vuidabou0', NULL, NULL, 'cart', '2017-09-05 00:25:06', '0000-00-00 00:00:00', '67.2.254.235', '', 'mozilla', '{\"is_mobile\":false}'), ('652', '0', '4jlsvdueiddbo7jfcq7aemu9b6', NULL, NULL, 'cart', '2017-09-05 01:05:21', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('653', '0', 'l599mlbntrmu20vnvdan9mhsb4', NULL, NULL, 'cart', '2017-09-05 02:50:33', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('654', '0', '3ir1ds1ij7192od2aj12spoki1', NULL, NULL, 'cart', '2017-09-05 02:59:19', '0000-00-00 00:00:00', '180.76.15.18', '', 'mozilla', '{\"is_mobile\":false}'), ('655', '0', '8e6uis9uplngfq4plnepqhasl7', NULL, NULL, 'cart', '2017-09-05 05:11:40', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('656', '0', 'vtcif02njlgahtu0q7sjs8abq2', NULL, NULL, 'cart', '2017-09-05 05:35:30', '2017-09-05 05:46:36', '178.162.205.100', '', 'mozilla', '{\"is_mobile\":false}'), ('657', '0', 'q74bqpjk29dtp1qj6v2mivaj84', NULL, NULL, 'cart', '2017-09-05 05:45:38', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('658', '0', 'c0dfpu53c78qm3a3tirp0q3ef2', NULL, NULL, 'cart', '2017-09-05 07:24:22', '2017-09-05 07:26:31', '94.74.174.151', '', 'chrome', '{\"is_mobile\":false}'), ('659', '0', '7l6glf763dg3u316s85a499rd1', NULL, NULL, 'cart', '2017-09-05 09:34:26', '2017-09-05 09:35:11', '101.8.176.158', '', 'mozilla', '{\"is_mobile\":false}'), ('660', '0', '0um4uhmmr6mm113hte1eslvro1', NULL, NULL, 'cart', '2017-09-05 10:31:34', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('661', '0', '9fiiknn273sqcgesfp0kk0cnv6', NULL, NULL, 'cart', '2017-09-05 12:08:46', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('662', '0', 'uetrda25cdg8c5l37gu0v5dpu1', NULL, NULL, 'cart', '2017-09-05 12:17:28', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('663', '0', '0votkafoskju7n1nco9hs1rrh0', NULL, NULL, 'cart', '2017-09-05 12:20:00', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('664', '0', 'c96uqkiitc5mjrftifb3rk5741', NULL, NULL, 'cart', '2017-09-05 12:40:57', '2017-09-05 12:45:15', '129.56.11.43', '', 'mozilla', '{\"is_mobile\":false}'), ('665', '0', 'avljr4torm3kk9ndpibuq3ug54', NULL, NULL, 'cart', '2017-09-05 12:51:55', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('666', '0', 'qprculc7f00pdghdako09mgv54', NULL, NULL, 'cart', '2017-09-05 13:02:50', '2017-09-05 13:05:59', '129.56.11.43', '', 'mozilla', '{\"is_mobile\":false}'), ('667', '0', 'm299bm1aro230hsp2128h93cn2', NULL, NULL, 'cart', '2017-09-05 13:27:55', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('668', '0', 'segarqa7os4ae7b88dohamq382', NULL, NULL, 'cart', '2017-09-05 17:28:13', '2017-09-05 17:35:56', '129.56.11.43', '', 'mozilla', '{\"is_mobile\":false}'), ('669', '0', 'n2sq4sf48vhff7o1qthjat1fn1', NULL, NULL, 'cart', '2017-09-05 17:29:08', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('670', '0', '5pobr02qo8geh0h6ioc4knu4q5', NULL, NULL, 'cart', '2017-09-05 18:15:00', '0000-00-00 00:00:00', '46.242.97.46', '', 'chrome', '{\"is_mobile\":false}'), ('671', '0', 'vmjkq6gj0v6uk5gred8cdurtk5', NULL, NULL, 'cart', '2017-09-05 18:32:01', '0000-00-00 00:00:00', '45.116.233.34', '', 'chrome', '{\"is_mobile\":false}'), ('672', '0', 'h04vlntpqnubrftc5g4550taa6', NULL, NULL, 'cart', '2017-09-05 18:43:03', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('673', '0', 'o7lv9d2fcu4l7c7l7jrbh3tvv0', NULL, NULL, 'cart', '2017-09-05 18:44:44', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('674', '0', 'gja3eus39pqfika7uqdlkppva3', NULL, NULL, 'cart', '2017-09-05 20:17:21', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('675', '0', '6fs6t2s9tgpub0ms2mv76u53l0', NULL, NULL, 'cart', '2017-09-05 20:23:21', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('676', '0', '5j9qor4rvpb1rnom1459j0g4e5', NULL, NULL, 'cart', '2017-09-05 20:29:16', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('677', '0', 'econih2nmeboen5v1nscltmv31', NULL, NULL, 'cart', '2017-09-05 21:17:07', '0000-00-00 00:00:00', '184.154.139.24', '', 'msie', '{\"is_mobile\":false}'), ('678', '0', 'n8p3p83u52kk7hv2petbogpb65', NULL, NULL, 'cart', '2017-09-05 23:54:06', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('679', '0', '6pm9ii1a61iaaqtk08r5beh4o4', NULL, NULL, 'cart', '2017-09-06 03:08:20', '2017-09-06 03:08:30', '104.0.100.133', '', 'mozilla', '{\"is_mobile\":false}'), ('680', '0', 'vlfkdqkddfp2grntc4d7umf8q5', NULL, NULL, 'cart', '2017-09-06 03:55:33', '0000-00-00 00:00:00', '66.249.79.157', '', 'mozilla', '{\"is_mobile\":false}'), ('681', '0', '3e9cv36qifqift476c1mfj8ft3', NULL, NULL, 'cart', '2017-09-06 04:18:16', '0000-00-00 00:00:00', '114.125.18.143', '', 'chrome', '{\"is_mobile\":false}'), ('682', '0', 'fjf4tq4p0tr58iusucfegvfd85', NULL, NULL, 'cart', '2017-09-06 05:45:29', '0000-00-00 00:00:00', '66.249.79.158', '', 'chrome', '{\"is_mobile\":true}'), ('683', '0', 'lv0nsepps144a2jup5p0ft8ka2', NULL, NULL, 'cart', '2017-09-06 07:54:22', '2017-09-06 08:03:03', '83.12.104.250', '', 'chrome', '{\"is_mobile\":false}'), ('684', '0', 'm2iegrv7343ga8n4lqqn4kate6', NULL, NULL, 'cart', '2017-09-06 08:31:55', '2017-09-06 08:36:12', '106.51.26.100', '', 'chrome', '{\"is_mobile\":false}'), ('685', '0', '3q2rm42o37n0r6cihuc8nveti0', NULL, NULL, 'cart', '2017-09-06 09:53:59', '2017-09-06 11:08:18', '217.118.93.89', '', 'chrome', '{\"is_mobile\":false}'), ('686', '0', 'g0ogq92ebvm0l21tcjdhkpcn57', NULL, NULL, 'cart', '2017-09-06 11:25:21', '2017-09-06 20:11:08', '217.118.93.89', '', 'chrome', '{\"is_mobile\":false}'), ('687', '0', '3dbjo70o2akmoepc9skq4g70d2', NULL, NULL, 'cart', '2017-09-06 11:32:23', '0000-00-00 00:00:00', '103.217.212.197', '', 'chrome', '{\"is_mobile\":false}'), ('688', '0', '9uh333c9eehfr1aasnv5ovrgj7', NULL, NULL, 'cart', '2017-09-06 11:41:43', '2017-09-06 12:48:31', '188.168.95.224', '', 'chrome', '{\"is_mobile\":false}'), ('689', '0', '8gcchtc351dmdivqfhdlfrae74', NULL, NULL, 'cart', '2017-09-06 12:46:26', '0000-00-00 00:00:00', '117.151.45.97', '', 'chrome', '{\"is_mobile\":false}'), ('690', '0', '497tid725c8tk4pcfj5m0p30h1', NULL, NULL, 'cart', '2017-09-06 12:49:59', '2017-09-06 12:50:07', '66.102.9.12', '', 'chrome', '{\"is_mobile\":true}'), ('691', '0', '0jbsaeij0v2jji7lruk84d8e36', NULL, NULL, 'cart', '2017-09-06 12:51:28', '0000-00-00 00:00:00', '66.249.93.196', '', 'chrome', '{\"is_mobile\":true}'), ('692', '0', 'o5dap5teq0o3ft447516kcnvt2', NULL, NULL, 'cart', '2017-09-06 12:51:28', '0000-00-00 00:00:00', '66.249.93.198', '', 'chrome', '{\"is_mobile\":false}'), ('693', '0', '66boqnsb4hjgduj4ss4l3sna95', NULL, NULL, 'cart', '2017-09-06 12:51:54', '0000-00-00 00:00:00', '66.249.93.200', '', 'chrome', '{\"is_mobile\":true}'), ('694', '0', '0jrijqavdd1vffqan8dgctpa82', NULL, NULL, 'cart', '2017-09-06 12:51:54', '0000-00-00 00:00:00', '66.249.93.198', '', 'chrome', '{\"is_mobile\":false}'), ('695', '0', 'he85f7buhmbrnk5pli27bis3o0', NULL, NULL, 'cart', '2017-09-06 12:53:59', '0000-00-00 00:00:00', '66.249.93.200', '', 'chrome', '{\"is_mobile\":false}'), ('696', '0', 't5vrovrma6lpbccl21df3pa4i6', NULL, NULL, 'cart', '2017-09-06 12:53:59', '0000-00-00 00:00:00', '66.249.93.196', '', 'chrome', '{\"is_mobile\":true}'), ('697', '0', '7bqmk9bor9vakiip71ejis1el0', NULL, NULL, 'cart', '2017-09-06 19:06:59', '2017-09-06 19:09:29', '36.224.224.162', '', 'chrome', '{\"is_mobile\":false}'), ('698', '0', 'la28bhi40hh005fjt2q0rc1mo1', NULL, NULL, 'cart', '2017-09-06 19:15:40', '0000-00-00 00:00:00', '66.249.93.200', '', 'chrome', '{\"is_mobile\":false}'), ('699', '0', '4htpid2q5k0sshjselmg4fudh2', NULL, NULL, 'cart', '2017-09-06 19:15:40', '0000-00-00 00:00:00', '66.249.93.196', '', 'chrome', '{\"is_mobile\":true}'), ('700', '0', '91d7p4kduofda3t7c2qffkkpi6', NULL, NULL, 'cart', '2017-09-06 19:17:16', '0000-00-00 00:00:00', '195.211.23.206', '', 'mozilla', '{\"is_mobile\":false}'), ('701', '0', 'r91ogt1tkh8gu61nmpgsenooc1', NULL, NULL, 'cart', '2017-09-06 19:18:05', '2017-09-06 19:18:30', '66.102.9.9', '', 'chrome', '{\"is_mobile\":true}'), ('702', '0', 'c7c4t56k0f7mig3c2lg48mma44', NULL, NULL, 'cart', '2017-09-06 19:28:12', '0000-00-00 00:00:00', '66.249.93.196', '', 'chrome', '{\"is_mobile\":true}'), ('703', '0', '73pl3ijn1d3g5acbf7meeicpo0', NULL, NULL, 'cart', '2017-09-06 19:28:13', '0000-00-00 00:00:00', '66.249.93.200', '', 'chrome', '{\"is_mobile\":false}'), ('704', '0', 'h2uj6d13btvul5i5trcstkqkp1', NULL, NULL, 'cart', '2017-09-06 20:05:36', '0000-00-00 00:00:00', '66.249.93.196', '', 'chrome', '{\"is_mobile\":true}'), ('705', '0', '7628666pnkcps3dqrun03e3s02', NULL, NULL, 'cart', '2017-09-06 20:05:36', '0000-00-00 00:00:00', '66.249.93.196', '', 'chrome', '{\"is_mobile\":false}'), ('706', '0', 'vbq8ghsnt8kubh0k9072hu5ri6', NULL, NULL, 'cart', '2017-09-06 21:23:12', '0000-00-00 00:00:00', '184.154.139.24', '', 'msie', '{\"is_mobile\":false}'), ('707', '0', '6vvp0d0mjkskumo23enab59r45', NULL, NULL, 'cart', '2017-09-06 22:15:55', '2017-09-06 22:16:39', '86.146.73.149', '', 'mozilla', '{\"is_mobile\":false}'), ('708', '0', 'tf28caemfcsfl5s24qjsees560', NULL, NULL, 'cart', '2017-09-07 13:21:58', '0000-00-00 00:00:00', '40.77.167.63', '', 'mozilla', '{\"is_mobile\":false}'), ('709', '0', 'l6rkevt0b12trs6sv09bd6mmd1', NULL, NULL, 'cart', '2017-09-07 14:24:13', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('710', '0', '7doi3fc4hrb6idklam1rq7ouj7', NULL, NULL, 'cart', '2017-09-07 15:29:21', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('711', '0', 'qc4apjq90ocmemm71tle5ufrq4', NULL, NULL, 'cart', '2017-09-07 15:45:13', '2017-09-07 15:45:16', '46.175.165.27', '', 'msie', '{\"is_mobile\":false}'), ('712', '0', '7d83oj62oc3k9h70c9217k1e63', NULL, NULL, 'cart', '2017-09-07 20:11:32', '2017-09-07 20:13:57', '81.233.220.231', '', 'safari', '{\"is_mobile\":true}'), ('713', '0', 's190gm0e25hseg7rgivvpl0vp3', NULL, NULL, 'cart', '2017-09-07 21:17:41', '0000-00-00 00:00:00', '184.154.139.24', '', 'msie', '{\"is_mobile\":false}'), ('714', '0', 'l59r06l0gm8gisv21nkl2k9q02', NULL, NULL, 'cart', '2017-09-07 22:52:31', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('715', '0', 'elvmn8a8tibqtbsrdgrc3vi0v2', NULL, NULL, 'cart', '2017-09-08 00:59:05', '0000-00-00 00:00:00', '66.249.79.4', '', 'chrome', '{\"is_mobile\":true}'), ('716', '0', 'mk0r6dtr2u5bkgiv49a5peq2a4', NULL, NULL, 'cart', '2017-09-08 01:07:51', '0000-00-00 00:00:00', '66.249.79.4', '', 'chrome', '{\"is_mobile\":true}'), ('717', '0', 'c4f505d3q7iemm59ajqf1vi1d2', NULL, NULL, 'cart', '2017-09-08 02:26:57', '0000-00-00 00:00:00', '66.249.79.3', '', 'chrome', '{\"is_mobile\":true}'), ('718', '0', 'r289am23tsrakkq88thv3kkg31', NULL, NULL, 'cart', '2017-09-08 06:06:15', '0000-00-00 00:00:00', '66.249.79.3', '', 'chrome', '{\"is_mobile\":true}'), ('719', '0', 'vkte4oq855mfq990bppkfjhc05', NULL, NULL, 'cart', '2017-09-08 06:19:57', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('720', '0', '4l8ggtm9rdjm6ij50j41qu3t73', NULL, NULL, 'cart', '2017-09-08 07:04:49', '0000-00-00 00:00:00', '103.25.44.2', '', 'mozilla', '{\"is_mobile\":false}'), ('721', '0', '8qtum4hr7rpptbiteu1aftdm06', NULL, NULL, 'cart', '2017-09-08 08:19:27', '0000-00-00 00:00:00', '202.61.120.190', '', 'chrome', '{\"is_mobile\":false}'), ('722', '0', 'q9rsmf250qiktfc9snphln03u0', NULL, NULL, 'cart', '2017-09-08 08:40:20', '0000-00-00 00:00:00', '66.249.79.3', '', 'chrome', '{\"is_mobile\":true}'), ('723', '0', '1u64go5osbh397f7jqg8na0nv4', NULL, NULL, 'cart', '2017-09-08 10:32:44', '0000-00-00 00:00:00', '90.100.35.144', '', 'mozilla', '{\"is_mobile\":false}'), ('724', '0', 'd8npq42v8s0kjm6an3o0d5dr56', NULL, NULL, 'cart', '2017-09-08 11:14:35', '0000-00-00 00:00:00', '66.249.79.30', '', 'chrome', '{\"is_mobile\":true}'), ('725', '0', 'sk9d6hgkfu33vfhmrb5qrc17a3', NULL, NULL, 'cart', '2017-09-08 12:55:02', '0000-00-00 00:00:00', '5.145.203.234', '', 'chrome', '{\"is_mobile\":false}'), ('726', '0', '3snntrdirskps2n6is99n1r1f4', NULL, NULL, 'cart', '2017-09-08 13:05:58', '0000-00-00 00:00:00', '66.249.79.30', '', 'chrome', '{\"is_mobile\":true}'), ('727', '0', 'hbvrgd8c5pmcus2dodufkvbut4', NULL, NULL, 'cart', '2017-09-08 14:14:33', '0000-00-00 00:00:00', '66.249.79.4', '', 'chrome', '{\"is_mobile\":true}'), ('728', '0', 'o9os2l88kvllghcopdoshda6p5', NULL, NULL, 'cart', '2017-09-08 14:15:12', '2017-09-08 14:15:35', '175.140.90.119', '', 'chrome', '{\"is_mobile\":false}'), ('729', '0', 'uhrr6a4rqbbm4uar8bi67upt95', NULL, NULL, 'cart', '2017-09-08 16:11:12', '2017-09-20 17:33:42', '87.176.147.80', '', 'mozilla', '{\"is_mobile\":false}'), ('730', '0', '5o2dd8pdbcgne4oqutivv53j60', NULL, NULL, 'cart', '2017-09-08 16:43:19', '0000-00-00 00:00:00', '166.137.252.29', '', 'safari', '{\"is_mobile\":true}'), ('731', '0', '2oinkg6i7gtupuddpfbsoq1uu5', NULL, NULL, 'cart', '2017-09-08 17:53:22', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('732', '0', 'jjnc5uufo96nj2ssr490mimp65', NULL, NULL, 'cart', '2017-09-08 18:14:22', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('733', '0', 'tkv2dootako67pd1k8kjurj6n6', NULL, NULL, 'cart', '2017-09-08 18:36:34', '0000-00-00 00:00:00', '43.252.33.104', '', 'mozilla', '{\"is_mobile\":false}'), ('734', '0', 'aoeidvvmk198rd26v95ttts2s7', NULL, NULL, 'cart', '2017-09-08 18:38:26', '0000-00-00 00:00:00', '180.76.15.163', '', 'mozilla', '{\"is_mobile\":false}'), ('735', '0', 'bfn5rul2292rbfjc6gmgcb7cf1', NULL, NULL, 'cart', '2017-09-08 21:17:13', '0000-00-00 00:00:00', '184.154.139.46', '', 'msie', '{\"is_mobile\":false}'), ('736', '0', '4u0kenrpmk1rqdc8q03i1ih2s3', NULL, NULL, 'cart', '2017-09-08 22:50:53', '0000-00-00 00:00:00', '66.249.79.24', '', 'mozilla', '{\"is_mobile\":false}'), ('737', '0', 'hq78kgp2v04t8o1uhe6irsrgt7', NULL, NULL, 'cart', '2017-09-08 22:56:12', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('738', '0', 'vgsihhtr099lhmdltshd9bs642', NULL, NULL, 'cart', '2017-09-08 23:55:24', '0000-00-00 00:00:00', '79.202.38.13', '', 'chrome', '{\"is_mobile\":false}'), ('739', '0', 'c1l86lcnbtmn7hus9qlea1pit7', NULL, NULL, 'cart', '2017-09-09 03:29:27', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('740', '0', '7j28lkfk9pdo03vtl46l9ec824', NULL, NULL, 'cart', '2017-09-09 06:51:46', '0000-00-00 00:00:00', '180.76.15.136', '', 'mozilla', '{\"is_mobile\":false}'), ('741', '0', 'bd45cb3lth2bdp9dlos2v27770', NULL, NULL, 'cart', '2017-09-09 07:35:08', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('742', '0', 'vm9mtmbj6s0mfon338dta90pe2', NULL, NULL, 'cart', '2017-09-09 08:56:48', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('743', '0', 'b946nnrned5qkqvdfm3itgscc1', NULL, NULL, 'cart', '2017-09-09 10:09:47', '0000-00-00 00:00:00', '145.129.116.179', '', 'chrome', '{\"is_mobile\":false}'), ('744', '0', 'lcot42v9jt718oekc7h5n76g54', NULL, NULL, 'cart', '2017-09-09 10:38:47', '0000-00-00 00:00:00', '5.14.249.224', '', 'mozilla', '{\"is_mobile\":false}'), ('745', '0', 'of2r504bmk1q0uf09g58ufshk1', NULL, NULL, 'cart', '2017-09-09 10:38:54', '2017-09-09 10:39:19', '5.14.249.224', '', 'mozilla', '{\"is_mobile\":false}'), ('746', '0', 'tho9pr0tmfnl5noi22e5fsi493', NULL, NULL, 'cart', '2017-09-09 13:57:22', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('747', '0', 'hrqmd8pm8v75n1g92f2e1o9kk2', NULL, NULL, 'cart', '2017-09-09 14:37:31', '0000-00-00 00:00:00', '141.8.143.177', '', 'mozilla', '{\"is_mobile\":false}'), ('748', '0', 'ev9udpk9dsla4b3rdikaomg4e5', NULL, NULL, 'cart', '2017-09-09 14:45:39', '0000-00-00 00:00:00', '5.255.250.124', '', 'mozilla', '{\"is_mobile\":false}'), ('749', '0', 'tsfupvdl3ju0ro5nnsskqod781', NULL, NULL, 'cart', '2017-09-09 16:16:30', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('750', '0', 'dpatp8u6fgpvaup3j5lumioqh5', NULL, NULL, 'cart', '2017-09-09 18:30:39', '0000-00-00 00:00:00', '192.0.116.114', '', 'safari', '{\"is_mobile\":false}'), ('751', '0', 'lc8spjvt1bffftad1au2j5cdu4', NULL, NULL, 'cart', '2017-09-09 19:03:07', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('752', '0', 'taqt7jcmhg83b7oe0498qlcbd6', NULL, NULL, 'cart', '2017-09-09 19:20:55', '0000-00-00 00:00:00', '46.42.134.214', '', 'mozilla', '{\"is_mobile\":false}'), ('753', '0', '84mnvgco2imvrdlvvnop1hgjo5', NULL, NULL, 'cart', '2017-09-09 21:22:47', '0000-00-00 00:00:00', '184.154.139.46', '', 'msie', '{\"is_mobile\":false}'), ('754', '0', 'aqs5m7mscmj1g6c48s0u5vu7v0', NULL, NULL, 'cart', '2017-09-09 22:47:44', '0000-00-00 00:00:00', '79.11.186.69', '', '', '{\"is_mobile\":false}'), ('755', '0', 't0hmiliu6ic4drctsnfegienb0', NULL, NULL, 'cart', '2017-09-09 22:47:46', '0000-00-00 00:00:00', '79.11.186.69', '', '', '{\"is_mobile\":false}'), ('756', '0', '2m563h57pkrds01u44259vi7f0', NULL, NULL, 'cart', '2017-09-09 23:15:40', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('757', '0', 'mna4q9i62tcpa1ttko35teg7o1', NULL, NULL, 'cart', '2017-09-10 00:43:43', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('758', '0', 'sos0dqq2gm89mj207etmiou290', NULL, NULL, 'cart', '2017-09-10 01:05:21', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('759', '0', '12itnhdr08766kfqmtigh8gv94', NULL, NULL, 'cart', '2017-09-10 03:18:10', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('760', '0', '0q0vgmch90djpav3gh7pt2uq07', NULL, NULL, 'cart', '2017-09-10 03:23:35', '0000-00-00 00:00:00', '67.2.254.235', '', 'mozilla', '{\"is_mobile\":false}'), ('761', '0', '3f06s6ggknrfishh79h908h306', NULL, NULL, 'cart', '2017-09-10 03:28:14', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('762', '0', 'hnfvshumllvnjga2958qk5j4e4', NULL, NULL, 'cart', '2017-09-10 03:44:02', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('763', '0', '8o1m31267cd0gvf7fava5fh8u5', NULL, NULL, 'cart', '2017-09-10 04:19:32', '0000-00-00 00:00:00', '66.249.79.4', '', 'chrome', '{\"is_mobile\":true}'), ('764', '0', 'qpl6219ksf6r8g0esgh08drg76', NULL, NULL, 'cart', '2017-09-10 05:53:26', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('765', '0', 'qc27p8dl1r5125aj39i9qibvd2', NULL, NULL, 'cart', '2017-09-10 05:58:32', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('766', '0', 'mv6r7nqhbhrfe6kq3c527q6f13', NULL, NULL, 'cart', '2017-09-10 06:09:03', '0000-00-00 00:00:00', '185.114.141.32', '', 'mozilla', '{\"is_mobile\":false}'), ('767', '0', '7flb6p9r13sqrt4i62geldan87', NULL, NULL, 'cart', '2017-09-10 06:42:01', '0000-00-00 00:00:00', '66.249.79.4', '', 'chrome', '{\"is_mobile\":true}'), ('768', '0', 'eqqi51hicusuhi7rj6nshfooi3', NULL, NULL, 'cart', '2017-09-10 07:34:01', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('769', '0', 'h2qhff9cdmds338qqtk0tnlrr2', NULL, NULL, 'cart', '2017-09-10 07:53:17', '0000-00-00 00:00:00', '66.249.79.3', '', 'chrome', '{\"is_mobile\":true}'), ('770', '0', '76aue02fe1cjhkhsnfueflnuj1', NULL, NULL, 'cart', '2017-09-10 07:58:27', '0000-00-00 00:00:00', '66.249.79.4', '', 'chrome', '{\"is_mobile\":true}'), ('771', '0', 'ltq3k6hgk2hbrhrpt3qtpfnk46', NULL, NULL, 'cart', '2017-09-10 08:01:29', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('772', '0', '2qmrfqhgcghajk4te8qskfg3n5', NULL, NULL, 'cart', '2017-09-10 08:23:46', '0000-00-00 00:00:00', '66.249.79.3', '', 'chrome', '{\"is_mobile\":true}'), ('773', '0', 'm1ptola09epp4rl3dccoevdua6', NULL, NULL, 'cart', '2017-09-10 08:24:41', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('774', '0', '3i8mjsk5jr2bcegq0gdvnipur5', NULL, NULL, 'cart', '2017-09-10 08:49:08', '0000-00-00 00:00:00', '66.249.79.30', '', 'chrome', '{\"is_mobile\":true}'), ('775', '0', 'rrv90vk6sgidm23kgt2a7l2hq0', NULL, NULL, 'cart', '2017-09-10 09:06:47', '0000-00-00 00:00:00', '94.249.160.50', '', 'mozilla', '{\"is_mobile\":false}'), ('776', '0', '21fcv6odjd4k4ltdhvgocoear3', NULL, NULL, 'cart', '2017-09-10 09:10:06', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('777', '0', '8oqu6q0qvm3okk4necbdit22a2', NULL, NULL, 'cart', '2017-09-10 09:36:57', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('778', '0', '8g05cien10fl75gm7rlbvopti1', NULL, NULL, 'cart', '2017-09-10 10:14:09', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('779', '0', 'cbf62u9rg0ve56nf95pq1k3ae5', NULL, NULL, 'cart', '2017-09-10 11:01:34', '0000-00-00 00:00:00', '66.249.79.4', '', 'chrome', '{\"is_mobile\":true}'), ('780', '0', 'i5qgcst3ea3c3e3ni1evncg5b6', NULL, NULL, 'cart', '2017-09-10 12:18:33', '0000-00-00 00:00:00', '66.249.79.4', '', 'chrome', '{\"is_mobile\":true}'), ('781', '0', 'sk8urq7v3ef8b5jecko9gu1v91', NULL, NULL, 'cart', '2017-09-10 12:54:03', '0000-00-00 00:00:00', '66.249.79.30', '', 'chrome', '{\"is_mobile\":true}'), ('782', '0', 'msrgcjjpt3dkiuj0gh5uq9hvq2', NULL, NULL, 'cart', '2017-09-10 16:05:51', '0000-00-00 00:00:00', '84.232.137.232', '', 'mozilla', '{\"is_mobile\":false}'), ('783', '0', 'e7tthmcra7q7ocj2l1lfpragd5', NULL, NULL, 'cart', '2017-09-10 16:31:00', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('784', '0', 'ngqs6bpmi23f2631utgtfaha02', NULL, NULL, 'cart', '2017-09-10 16:34:02', '0000-00-00 00:00:00', '84.232.137.232', '', 'mozilla', '{\"is_mobile\":false}'), ('785', '0', '0bgchhbcvevj4m19fu3rtadpc7', NULL, NULL, 'cart', '2017-09-10 16:53:27', '0000-00-00 00:00:00', '66.249.79.4', '', 'chrome', '{\"is_mobile\":true}'), ('786', '0', 'f81vthlmgubh7562cnudprl3p0', NULL, NULL, 'cart', '2017-09-10 17:18:45', '0000-00-00 00:00:00', '66.249.79.3', '', 'mozilla', '{\"is_mobile\":false}'), ('787', '0', 'hkl69hpbc1dhag6o8b3fd0d270', NULL, NULL, 'cart', '2017-09-10 17:34:00', '0000-00-00 00:00:00', '94.249.224.128', '', 'chrome', '{\"is_mobile\":false}'), ('788', '0', '30hf7j7r9j64eqp2of0o9h6ai2', NULL, NULL, 'cart', '2017-09-10 17:49:47', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('789', '0', 'inf4afol9fdtupp1cubqfmi7i3', NULL, NULL, 'cart', '2017-09-10 18:22:59', '0000-00-00 00:00:00', '103.5.133.14', '', 'chrome', '{\"is_mobile\":false}'), ('790', '0', 'krkd12g4hrj0ronvggb7esnh71', NULL, NULL, 'cart', '2017-09-10 18:29:23', '0000-00-00 00:00:00', '66.249.79.4', '', 'chrome', '{\"is_mobile\":true}'), ('791', '0', '70engkd22m3s1erdnd74ri5910', NULL, NULL, 'cart', '2017-09-10 19:03:31', '0000-00-00 00:00:00', '94.249.160.165', '', 'edge', '{\"is_mobile\":false}'), ('792', '0', '0uukgtvggmpsaafg3kuunv14h6', NULL, NULL, 'cart', '2017-09-10 19:04:24', '0000-00-00 00:00:00', '66.249.79.4', '', 'chrome', '{\"is_mobile\":true}'), ('793', '0', '410j9lgca18oajvscv9vm4j855', NULL, NULL, 'cart', '2017-09-10 19:04:25', '0000-00-00 00:00:00', '66.249.79.4', '', 'chrome', '{\"is_mobile\":true}'), ('794', '0', 'qg21o76shebgcftcbht2gqugn7', NULL, NULL, 'cart', '2017-09-10 19:34:43', '0000-00-00 00:00:00', '66.249.79.30', '', 'chrome', '{\"is_mobile\":true}'), ('795', '0', 'rs10d5h899gr1mo9urp4soh1s4', NULL, NULL, 'cart', '2017-09-10 20:22:07', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('796', '0', 'fi69rud4ecsq9i2e0s3r29dso0', NULL, NULL, 'cart', '2017-09-10 20:24:01', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('797', '0', '6eppek2r2cd4udhcaupnijigh2', NULL, NULL, 'cart', '2017-09-10 20:25:51', '2017-09-10 20:26:29', '109.236.120.225', '', 'chrome', '{\"is_mobile\":false}'), ('798', '0', '9femsqehqain7uij8bj2a1hmo7', NULL, NULL, 'cart', '2017-09-10 21:03:22', '0000-00-00 00:00:00', '5.255.250.124', '', 'mozilla', '{\"is_mobile\":false}'), ('799', '0', 'omb3hemivqt381o5t2tc9hoji5', NULL, NULL, 'cart', '2017-09-10 21:18:36', '0000-00-00 00:00:00', '184.154.139.24', '', 'msie', '{\"is_mobile\":false}'), ('800', '0', 'ccqbrjj95kpjpquhmuebmmg2e6', NULL, NULL, 'cart', '2017-09-10 23:30:06', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('801', '0', '1tie84jf2d3uaoc30nr6tnq670', NULL, NULL, 'cart', '2017-09-11 00:16:28', '0000-00-00 00:00:00', '77.88.5.57', '', 'mozilla', '{\"is_mobile\":false}'), ('802', '0', 'qrr5nrsfb865butsslgef600q2', NULL, NULL, 'cart', '2017-09-11 01:02:14', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('803', '0', 'fahqh67tnth8g141m1u6qaeg91', NULL, NULL, 'cart', '2017-09-11 03:00:41', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('804', '0', 'kjkftsbfbgjdvl6fh4f9uudbk7', NULL, NULL, 'cart', '2017-09-11 03:17:22', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('805', '0', '894fou3nh07nkjhs257qgjq882', NULL, NULL, 'cart', '2017-09-11 04:16:48', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('806', '0', '15a3vme65mkfn831s1mbsf1ce3', NULL, NULL, 'cart', '2017-09-11 04:16:54', '0000-00-00 00:00:00', '66.249.79.4', '', 'chrome', '{\"is_mobile\":true}'), ('807', '0', 'gc46u1acomqfihbtpid3uf6ra5', NULL, NULL, 'cart', '2017-09-11 05:23:09', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('808', '0', 'b3lv9f29k49lh5v6u1bh39qgs5', NULL, NULL, 'cart', '2017-09-11 06:15:40', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('809', '0', '3k11bm4ps1n8popb5gdj84n6h0', NULL, NULL, 'cart', '2017-09-11 06:18:53', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('810', '0', 'tf32ket0re5n6l04d9pj86ooo7', NULL, NULL, 'cart', '2017-09-11 06:24:57', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('811', '0', 'uu364gm66k6ue3qjtr85hnd3n4', NULL, NULL, 'cart', '2017-09-11 07:19:41', '0000-00-00 00:00:00', '1.170.41.129', '', 'chrome', '{\"is_mobile\":false}'), ('812', '0', 'sqjpumbsnl752mkrj9e4asak94', NULL, NULL, 'cart', '2017-09-11 07:19:43', '0000-00-00 00:00:00', '1.170.41.129', '', '', '{\"is_mobile\":false}'), ('813', '0', 'tsph6mlthars4asusiimqhh2i4', NULL, NULL, 'cart', '2017-09-11 09:13:27', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('814', '0', '50ga7vs767v569h5r0863qvsh1', NULL, NULL, 'cart', '2017-09-11 10:33:01', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('815', '0', 'qttgatuj2gq0uf2gmmkkt2fd54', NULL, NULL, 'cart', '2017-09-11 10:41:28', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('816', '0', '9e8eqsrijo5ubnu3fq35l1fbc0', NULL, NULL, 'cart', '2017-09-11 11:37:53', '2017-09-11 11:38:44', '59.50.79.125', '', 'chrome', '{\"is_mobile\":false}'), ('817', '0', '6ecvecihj7hvnitfslksoacc31', NULL, NULL, 'cart', '2017-09-11 12:37:51', '0000-00-00 00:00:00', '188.109.23.54', '', 'safari', '{\"is_mobile\":false}'), ('818', '0', 'o7nc14f0cv8q47d22tfiul3a74', NULL, NULL, 'cart', '2017-09-11 12:41:34', '0000-00-00 00:00:00', '188.109.23.54', '', 'safari', '{\"is_mobile\":false}'), ('819', '0', 'uhn33n10agt6anjm7cj93ma2o0', NULL, NULL, 'cart', '2017-09-11 14:36:35', '0000-00-00 00:00:00', '78.13.234.240', '', 'chrome', '{\"is_mobile\":false}'), ('820', '0', '3c9sgu4dmgohgucabasjkr6912', NULL, NULL, 'cart', '2017-09-11 14:37:05', '0000-00-00 00:00:00', '78.13.234.240', '', 'chrome', '{\"is_mobile\":false}'), ('821', '0', 'o772t87p6eutjejjofa1ogsdu6', NULL, NULL, 'cart', '2017-09-11 15:06:57', '0000-00-00 00:00:00', '14.142.81.39', '', 'chrome', '{\"is_mobile\":false}'), ('822', '0', '260sa55ma4cqb191aogsbmkgp5', NULL, NULL, 'cart', '2017-09-11 15:16:39', '2017-09-11 15:30:02', '78.233.199.79', '', 'chrome', '{\"is_mobile\":false}'), ('823', '0', 'qs40dv9p9o4gechoft2vupmq77', NULL, NULL, 'cart', '2017-09-11 15:28:52', '2017-09-11 15:28:54', '98.212.43.133', '', 'mozilla', '{\"is_mobile\":false}'), ('824', '0', '0caekl53ptpc75ma65sos16n23', NULL, NULL, 'cart', '2017-09-11 15:29:22', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('825', '0', 'u4tkl09be2992au5su25ecnu34', NULL, NULL, 'cart', '2017-09-11 17:30:20', '2017-09-11 17:31:58', '176.59.104.63', '', 'chrome', '{\"is_mobile\":true}'), ('826', '0', 'di0c0m2h5ar0vs5bopc8vl4v45', NULL, NULL, 'cart', '2017-09-11 17:30:20', '0000-00-00 00:00:00', '66.102.9.130', '', 'chrome', '{\"is_mobile\":true}'), ('827', '0', 'uhtqlib12veae7hfcrji66end3', NULL, NULL, 'cart', '2017-09-11 17:53:21', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('828', '0', 'bi6jmk3nmfj4juf0h9brht50t3', NULL, NULL, 'cart', '2017-09-11 21:19:49', '0000-00-00 00:00:00', '184.154.139.47', '', 'msie', '{\"is_mobile\":false}'), ('829', '0', 'ou70vmr024skr16lhthe3mlb25', NULL, NULL, 'cart', '2017-09-11 22:41:21', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('830', '0', '5415ek1skkcgbjnp5g24tivbl5', NULL, NULL, 'cart', '2017-09-12 02:19:28', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('831', '0', 'rbibkb9fu4abup51ipo7rc08q7', NULL, NULL, 'cart', '2017-09-12 07:05:52', '2017-09-12 07:08:56', '92.161.183.28', '', 'chrome', '{\"is_mobile\":false}'), ('832', '0', 'tbdn1olhmo0pjhh1ut7j2qsdf0', NULL, NULL, 'cart', '2017-09-12 07:32:52', '2017-09-12 07:34:27', '91.147.236.42', '', 'mozilla', '{\"is_mobile\":false}'), ('833', '0', '3fvq2rrjotcvn2k78bsaq9e2v3', NULL, NULL, 'cart', '2017-09-12 08:01:11', '0000-00-00 00:00:00', '77.118.173.138', '', 'mozilla', '{\"is_mobile\":false}'), ('834', '0', 'u31pr1itkledq3eov4ugkslud0', NULL, NULL, 'cart', '2017-09-12 08:02:52', '0000-00-00 00:00:00', '77.118.173.138', '', 'mozilla', '{\"is_mobile\":false}'), ('835', '0', 'sqootvjdosna9ak66stqvmv9s6', NULL, NULL, 'cart', '2017-09-12 08:24:57', '0000-00-00 00:00:00', '77.118.173.138', '', 'mozilla', '{\"is_mobile\":false}'), ('836', '0', '1qik6drhgmthqf84djbufuqbc6', NULL, NULL, 'cart', '2017-09-12 09:36:07', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('837', '0', 'ns2o2d93kdcspgb6blfkgcn2d3', NULL, NULL, 'cart', '2017-09-12 12:12:14', '0000-00-00 00:00:00', '186.149.198.48', '', 'chrome', '{\"is_mobile\":false}'), ('838', '0', 'ptur2i6aa2gi7j15fh2l89fj72', NULL, NULL, 'cart', '2017-09-12 12:12:14', '0000-00-00 00:00:00', '186.149.198.48', '', 'chrome', '{\"is_mobile\":false}'), ('839', '0', 'ogfpi37lkff3aan0o8adp7j2d0', NULL, NULL, 'cart', '2017-09-12 12:48:31', '0000-00-00 00:00:00', '81.82.226.134', '', 'safari', '{\"is_mobile\":false}'), ('840', '0', 'vakv4vfs14ag1cg1j2e0rtq345', NULL, NULL, 'cart', '2017-09-12 12:49:25', '0000-00-00 00:00:00', '81.82.226.134', '', 'safari', '{\"is_mobile\":false}'), ('841', '0', '6olncot7ntko5f1c5p285s2930', NULL, NULL, 'cart', '2017-09-12 12:49:27', '0000-00-00 00:00:00', '81.82.226.134', '', 'safari', '{\"is_mobile\":false}'), ('842', '0', 'up6lt47pselk1331nt8b89p474', NULL, NULL, 'cart', '2017-09-12 12:49:32', '0000-00-00 00:00:00', '81.82.226.134', '', 'safari', '{\"is_mobile\":false}'), ('843', '0', '4ssctjbbqv8aer93mhhkp2dl51', NULL, NULL, 'cart', '2017-09-12 13:43:14', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('844', '0', 'hbvtnc8h17t5r1cidi1chpme93', NULL, NULL, 'cart', '2017-09-12 14:30:02', '0000-00-00 00:00:00', '207.241.226.22', '', 'mozilla', '{\"is_mobile\":false}'), ('845', '0', 's3j0930kho9o4o5qv0rggplv32', NULL, NULL, 'cart', '2017-09-12 14:40:51', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('846', '0', '62188mghg6vivraov6aqcvm8d2', NULL, NULL, 'cart', '2017-09-12 14:56:40', '0000-00-00 00:00:00', '90.100.35.144', '', 'mozilla', '{\"is_mobile\":false}'), ('847', '0', 'eiiq2ved4gjnklhuf4jcsoj8s0', NULL, NULL, 'cart', '2017-09-12 15:13:32', '0000-00-00 00:00:00', '90.100.35.144', '', 'mozilla', '{\"is_mobile\":false}'), ('848', '0', 'hgc73ir12odm4ieig61sj0ss30', NULL, NULL, 'cart', '2017-09-12 16:26:54', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('849', '0', 'tifffd5rh8eg2uq3fmchdjb0g4', NULL, NULL, 'cart', '2017-09-12 18:22:40', '0000-00-00 00:00:00', '54.165.90.203', '', '', '{\"is_mobile\":false}'), ('850', '0', 'ekoliqaniqd8mb6d1046t7n8m2', NULL, NULL, 'cart', '2017-09-12 20:37:59', '0000-00-00 00:00:00', '88.231.180.233', '', 'mozilla', '{\"is_mobile\":false}'), ('851', '0', 'rraov9g76rnsdspn9mrddo40d3', NULL, NULL, 'cart', '2017-09-12 21:10:00', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('852', '0', 'p07gk9844494rc5t1bvo5m5957', NULL, NULL, 'cart', '2017-09-12 21:17:20', '0000-00-00 00:00:00', '184.154.139.46', '', 'msie', '{\"is_mobile\":false}'), ('853', '0', 'bd1trgjijl4ma21v9g8f3aj304', NULL, NULL, 'cart', '2017-09-12 21:54:33', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('854', '0', 'pv03n22opkbt04fk86d865ed96', NULL, NULL, 'cart', '2017-09-12 23:00:30', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('855', '0', 'ej3dvv0v78fg56kegpciooop94', NULL, NULL, 'cart', '2017-09-12 23:09:36', '2017-09-12 23:22:07', '76.103.125.31', '', '', '{\"is_mobile\":false}'), ('856', '0', '240t4padt8lu6lr7l7eo6tji81', NULL, NULL, 'cart', '2017-09-12 23:48:29', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('857', '0', 'd3r73scdemrnmqncc96f629bl0', NULL, NULL, 'cart', '2017-09-13 01:18:18', '0000-00-00 00:00:00', '207.46.13.174', '', 'mozilla', '{\"is_mobile\":false}'), ('858', '0', '0j4f6k22rdgmdr251m44hlfem0', NULL, NULL, 'cart', '2017-09-13 01:34:22', '0000-00-00 00:00:00', '116.23.126.75', '', 'chrome', '{\"is_mobile\":false}'), ('859', '0', '6n53llfuid4jdfk2cqsj28ogo1', NULL, NULL, 'cart', '2017-09-13 02:43:09', '0000-00-00 00:00:00', '14.165.215.134', '', 'chrome', '{\"is_mobile\":false}'), ('860', '0', '1sv4osdh5g98g225treh9rut91', NULL, NULL, 'cart', '2017-09-13 02:51:54', '0000-00-00 00:00:00', '141.8.144.71', '', 'mozilla', '{\"is_mobile\":false}'), ('861', '0', 'tckmickpbtvts2hrdl5u16pj20', NULL, NULL, 'cart', '2017-09-13 03:37:18', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('862', '0', 'qcijmmj1boiua5plg48du6c2b1', NULL, NULL, 'cart', '2017-09-13 07:14:44', '2017-09-13 07:15:16', '114.7.6.62', '', 'chrome', '{\"is_mobile\":false}'), ('863', '0', 'v427pedhc9nfp1o3q0bi4p12h3', NULL, NULL, 'cart', '2017-09-13 10:04:18', '0000-00-00 00:00:00', '66.249.66.157', '', 'chrome', '{\"is_mobile\":true}'), ('864', '0', 'rm6nre4u552qhp5qqlgao28qq3', NULL, NULL, 'cart', '2017-09-13 10:04:26', '0000-00-00 00:00:00', '66.249.66.157', '', 'chrome', '{\"is_mobile\":true}'), ('865', '0', '8mkut9p737cb0ict2kguedhtp3', NULL, NULL, 'cart', '2017-09-13 12:41:59', '0000-00-00 00:00:00', '92.220.200.78', '', 'chrome', '{\"is_mobile\":false}'), ('866', '0', 'eqi587a0ugnp0ojhoeej26rge5', NULL, NULL, 'cart', '2017-09-13 14:50:17', '0000-00-00 00:00:00', '66.102.9.158', '', 'chrome', '{\"is_mobile\":true}'), ('867', '0', '7m0iskdugmm9jelpn9cphmf9u0', NULL, NULL, 'cart', '2017-09-13 14:50:19', '2017-09-13 15:50:00', '176.59.104.79', '', 'chrome', '{\"is_mobile\":true}'), ('868', '0', 'jkosu2a5vnun5gv84rl1hlgnd3', NULL, NULL, 'cart', '2017-09-13 15:31:25', '0000-00-00 00:00:00', '207.241.230.236', '', 'mozilla', '{\"is_mobile\":false}'), ('869', '0', '65tn92bbesjca0aicsm2m757v0', NULL, NULL, 'cart', '2017-09-13 15:46:24', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('870', '0', '5gs8lf2hh9i2toaipjdvgpq7q6', NULL, NULL, 'cart', '2017-09-13 15:58:38', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('871', '0', 'ghtnsq5vd524p5hp7j8i0eurp2', NULL, NULL, 'cart', '2017-09-13 16:19:25', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('872', '0', '3uq02r08ir950cpn7sd1iv2dp2', NULL, NULL, 'cart', '2017-09-13 16:21:30', '2017-09-13 16:22:51', '24.149.8.3', '', 'chrome', '{\"is_mobile\":false}'), ('873', '0', 's4o6a7br8u9o9of69u1f92u3c2', NULL, NULL, 'cart', '2017-09-13 21:36:15', '0000-00-00 00:00:00', '184.154.139.18', '', 'msie', '{\"is_mobile\":false}'), ('874', '0', 'er4vk8u9uohp3t6s7fs9rdro86', NULL, NULL, 'cart', '2017-09-14 01:59:23', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('875', '0', 'kr2smljl1mh17m61ue22uu5di3', NULL, NULL, 'cart', '2017-09-14 02:56:38', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('876', '0', 'dvuvmr7bpmh1n947tclvf8rqk7', NULL, NULL, 'cart', '2017-09-14 03:29:21', '0000-00-00 00:00:00', '66.249.79.4', '', 'mozilla', '{\"is_mobile\":false}'), ('877', '0', 'tl08636ueob8nkcanh0fhnnlm0', NULL, NULL, 'cart', '2017-09-14 05:53:45', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('878', '0', '5rrbl2r4j82hb5iso10o6e36l4', NULL, NULL, 'cart', '2017-09-14 06:40:31', '2017-09-14 06:43:12', '76.103.125.31', '', 'chrome', '{\"is_mobile\":false}'), ('879', '0', '0dk789pf2uuacohv76lte39827', NULL, NULL, 'cart', '2017-09-14 07:12:07', '2017-09-14 09:18:40', '95.251.158.154', '', 'chrome', '{\"is_mobile\":false}'), ('880', '0', 'jmgk4nmkkfjdglm7oh31sljnn7', NULL, NULL, 'cart', '2017-09-14 07:24:53', '0000-00-00 00:00:00', '66.102.9.152', '', 'chrome', '{\"is_mobile\":true}'), ('881', '0', 'ajftu7ilhqtmlcen2rsgt4nrq1', NULL, NULL, 'cart', '2017-09-14 07:44:19', '2017-09-14 08:02:28', '109.245.220.61', '', 'chrome', '{\"is_mobile\":false}'), ('882', '0', 'n97furjqnkkvpf3pbarmgspad1', NULL, NULL, 'cart', '2017-09-14 07:57:02', '0000-00-00 00:00:00', '81.35.94.90', '', 'mozilla', '{\"is_mobile\":false}'), ('883', '0', 'q76gu6f0h35oc566r64b7edva1', NULL, NULL, 'cart', '2017-09-14 07:57:21', '0000-00-00 00:00:00', '5.141.192.178', '', 'mozilla', '{\"is_mobile\":false}'), ('884', '0', 'k1crlh0f5kcjdfvfutgc1t1l70', NULL, NULL, 'cart', '2017-09-14 07:57:48', '2017-09-14 08:01:05', '223.184.26.189', '', 'mozilla', '{\"is_mobile\":false}'), ('885', '0', '8dfpgnf9408k139uqvogvvfqg0', NULL, NULL, 'cart', '2017-09-14 08:21:43', '0000-00-00 00:00:00', '94.163.122.243', '', 'chrome', '{\"is_mobile\":false}'), ('886', '0', '82iapijefhpshrat7l0hoqn5f4', NULL, NULL, 'cart', '2017-09-14 08:21:46', '2017-09-14 08:22:34', '94.163.122.243', '', 'chrome', '{\"is_mobile\":false}'), ('887', '0', 'ajdotjiaitjdluj0lg32untsi5', NULL, NULL, 'cart', '2017-09-14 08:33:55', '0000-00-00 00:00:00', '94.67.72.8', '', 'chrome', '{\"is_mobile\":false}'), ('888', '0', '5afoiha8riptuub8f2bg9ft3o7', NULL, NULL, 'cart', '2017-09-14 09:01:59', '2017-09-14 09:10:45', '220.247.166.245', '', 'chrome', '{\"is_mobile\":false}'), ('889', '0', 'qevmnvhap9dnmst6tuhql0jco0', NULL, NULL, 'cart', '2017-09-14 09:07:15', '2017-09-14 09:09:13', '193.197.73.9', '', 'mozilla', '{\"is_mobile\":false}'), ('890', '0', 'rafopa37jcmh8eno0smh6ro9q4', NULL, NULL, 'cart', '2017-09-14 09:31:56', '0000-00-00 00:00:00', '79.66.224.69', '', 'chrome', '{\"is_mobile\":false}'), ('891', '0', 'orhf8paqm0pmami8c7dr3iku67', NULL, NULL, 'cart', '2017-09-14 09:47:32', '0000-00-00 00:00:00', '27.145.43.72', '', 'mozilla', '{\"is_mobile\":false}'), ('892', '0', 'lcf0m8l32qee5p3m3lrmgn01r1', NULL, NULL, 'cart', '2017-09-14 09:47:57', '0000-00-00 00:00:00', '41.202.250.194', '', 'mozilla', '{\"is_mobile\":false}'), ('893', '0', 'or4dtk26o54qnd9spsaei7nsi6', NULL, NULL, 'cart', '2017-09-14 09:52:58', '2017-09-14 09:56:57', '84.74.149.129', '', 'chrome', '{\"is_mobile\":false}'), ('894', '0', 'ik331aidmc098l795ee1gn7eq7', NULL, NULL, 'cart', '2017-09-14 09:56:22', '2017-09-14 09:56:24', '197.210.227.173', '', 'mozilla', '{\"is_mobile\":false}'), ('895', '0', 'fklhasnh9ns14th5lfg86fa7a5', NULL, NULL, 'cart', '2017-09-14 09:59:06', '2017-09-14 10:25:13', '79.122.11.11', '', 'chrome', '{\"is_mobile\":false}'), ('896', '0', '1ip5flj88a2itb2vd4vm5a3016', NULL, NULL, 'cart', '2017-09-14 10:21:03', '2017-09-14 10:21:05', '93.103.225.176', '', 'chrome', '{\"is_mobile\":false}'), ('897', '0', 'dha69mgm4icb187tnk92qhbq90', NULL, NULL, 'cart', '2017-09-14 10:38:01', '2017-09-14 10:38:02', '175.137.155.87', '', 'mozilla', '{\"is_mobile\":false}'), ('898', '0', '5e9mitvth9dnps7cgphq73pu21', NULL, NULL, 'cart', '2017-09-14 10:41:21', '0000-00-00 00:00:00', '66.249.79.30', '', 'mozilla', '{\"is_mobile\":false}'), ('899', '0', '56hualeuc84m5h1q5vehq4m7d2', NULL, NULL, 'cart', '2017-09-14 10:44:20', '0000-00-00 00:00:00', '60.54.123.137', '', 'mozilla', '{\"is_mobile\":false}'), ('900', '0', 'm80jc7f618346dn6ev6hv5ana0', NULL, NULL, 'cart', '2017-09-14 10:53:28', '0000-00-00 00:00:00', '192.126.163.24', '', 'chrome', '{\"is_mobile\":false}'), ('901', '0', 'r6h8qij6tgb13ljth053r67pq5', NULL, NULL, 'cart', '2017-09-14 10:58:55', '0000-00-00 00:00:00', '5.255.250.202', '', 'mozilla', '{\"is_mobile\":false}'), ('902', '0', '3niejq7utsago4fqv5iho3ah35', NULL, NULL, 'cart', '2017-09-14 11:02:46', '0000-00-00 00:00:00', '74.125.76.32', '', '', '{\"is_mobile\":false}'), ('903', '0', 'ru9ruhoc1rtn2ra0lsj3e40hd5', NULL, NULL, 'cart', '2017-09-14 11:02:48', '0000-00-00 00:00:00', '74.125.76.33', '', '', '{\"is_mobile\":false}'), ('904', '0', 'td6aldqr3h6pmquofrdv5g0m87', NULL, NULL, 'cart', '2017-09-14 11:02:48', '0000-00-00 00:00:00', '74.125.76.36', '', '', '{\"is_mobile\":false}'), ('905', '0', 'ctsiifjv9hmmmilg0doks2e6d3', NULL, NULL, 'cart', '2017-09-14 11:02:50', '0000-00-00 00:00:00', '74.125.76.35', '', '', '{\"is_mobile\":false}'), ('906', '0', '13dfkcavda26666qdbc4ola2d2', NULL, NULL, 'cart', '2017-09-14 11:02:51', '0000-00-00 00:00:00', '74.125.76.35', '', '', '{\"is_mobile\":false}'), ('907', '0', 'p7h6pij5laosohng2l6luqib70', NULL, NULL, 'cart', '2017-09-14 11:02:52', '0000-00-00 00:00:00', '74.125.76.35', '', '', '{\"is_mobile\":false}'), ('908', '0', 'ng98s67ri4sb3dgoso4udeq1j5', NULL, NULL, 'cart', '2017-09-14 11:12:43', '2017-09-14 11:18:16', '202.105.47.32', '', 'mozilla', '{\"is_mobile\":false}'), ('909', '0', 'caegf5truk5i51n7sbb3lu5ed5', NULL, NULL, 'cart', '2017-09-14 11:12:53', '0000-00-00 00:00:00', '177.193.175.154', '', 'mozilla', '{\"is_mobile\":false}'), ('910', '0', 'i6ungtelu08k0nb2dsggl0hsb3', NULL, NULL, 'cart', '2017-09-14 11:17:24', '0000-00-00 00:00:00', '94.158.81.4', '', 'chrome', '{\"is_mobile\":false}'), ('911', '0', 'jqja8cm6il490ens45itsff6i5', NULL, NULL, 'cart', '2017-09-14 11:30:55', '0000-00-00 00:00:00', '114.179.64.14', '', 'chrome', '{\"is_mobile\":false}'), ('912', '0', 'tv8858au3qseojn68qftlq09k2', NULL, NULL, 'cart', '2017-09-14 11:40:42', '2017-09-14 11:41:02', '89.28.122.202', '', 'chrome', '{\"is_mobile\":false}'), ('913', '0', 'kcsa6ap9e5lqsmdk0t9aujgdc4', NULL, NULL, 'cart', '2017-09-14 11:41:19', '2017-09-14 11:41:53', '200.159.196.25', '', 'chrome', '{\"is_mobile\":false}'), ('914', '0', 'd23lfgge40b698ahrku2cdrp17', NULL, NULL, 'cart', '2017-09-14 11:48:31', '2017-09-14 11:51:12', '149.154.201.33', '', 'chrome', '{\"is_mobile\":false}'), ('915', '0', 'fdi4d6394e49brb2tpbi424kv5', NULL, NULL, 'cart', '2017-09-14 11:50:37', '2017-09-14 11:51:52', '191.249.174.67', '', 'chrome', '{\"is_mobile\":false}'), ('916', '0', 'fnqvgeskkvuo2ams7imclq9io1', NULL, NULL, 'cart', '2017-09-14 11:56:12', '0000-00-00 00:00:00', '107.167.112.74', '', 'opera', '{\"is_mobile\":false}'), ('917', '0', '39o4ffv21sj3j3ob9jk9n3cv71', NULL, NULL, 'cart', '2017-09-14 11:56:48', '2017-09-14 11:57:16', '107.167.112.74', '', 'opera', '{\"is_mobile\":false}'), ('918', '0', 'am50gqv4bbv7hscnvjalnls3g7', NULL, NULL, 'cart', '2017-09-14 11:56:50', '0000-00-00 00:00:00', '81.83.130.139', '', 'safari', '{\"is_mobile\":false}'), ('919', '0', 'e9jd254u1bdrihmkdvvi9t8im5', NULL, NULL, 'cart', '2017-09-14 11:57:01', '0000-00-00 00:00:00', '81.83.130.139', '', 'safari', '{\"is_mobile\":false}'), ('920', '0', 'afsqk4oe5hcrf4jrdqlagg2hf6', NULL, NULL, 'cart', '2017-09-14 11:57:02', '0000-00-00 00:00:00', '81.83.130.139', '', 'safari', '{\"is_mobile\":false}'), ('921', '0', '84u65hih589crle326kq06oeh0', NULL, NULL, 'cart', '2017-09-14 11:57:11', '0000-00-00 00:00:00', '81.83.130.139', '', 'safari', '{\"is_mobile\":false}'), ('922', '0', '51kkoa3a558ltgeti9alvg9986', NULL, NULL, 'cart', '2017-09-14 12:01:42', '2017-09-14 12:01:47', '78.8.238.150', '', 'chrome', '{\"is_mobile\":false}'), ('923', '0', 'e0jhkdv0i6g988jq6uvo23gos0', NULL, NULL, 'cart', '2017-09-14 12:17:10', '2017-09-14 12:21:21', '119.157.249.120', '', 'chrome', '{\"is_mobile\":false}'), ('924', '0', 'a6ih5jffrg7f6fa57mfcmp8124', NULL, NULL, 'cart', '2017-09-14 12:23:22', '0000-00-00 00:00:00', '85.57.198.69', '', 'safari', '{\"is_mobile\":true}'), ('925', '0', '8hadrtpupql127ubhulpcavd57', NULL, NULL, 'cart', '2017-09-14 12:24:49', '0000-00-00 00:00:00', '85.57.198.69', '', 'safari', '{\"is_mobile\":true}'), ('926', '0', 't9fec877pm2kqferap90ggmrf0', NULL, NULL, 'cart', '2017-09-14 12:24:53', '0000-00-00 00:00:00', '85.57.198.69', '', 'safari', '{\"is_mobile\":true}'), ('927', '0', 'p5nlaudeipbvccjr29abgo9155', NULL, NULL, 'cart', '2017-09-14 12:24:56', '0000-00-00 00:00:00', '85.57.198.69', '', 'safari', '{\"is_mobile\":true}'), ('928', '0', '1h798hdujm5iq8pfsna78lrmm3', NULL, NULL, 'cart', '2017-09-14 12:25:03', '0000-00-00 00:00:00', '85.57.198.69', '', 'safari', '{\"is_mobile\":true}'), ('929', '0', '8oqlupl8hr8e1n95t9vbgs8b05', NULL, NULL, 'cart', '2017-09-14 12:34:25', '2017-09-14 12:36:50', '189.74.98.44', '', 'chrome', '{\"is_mobile\":false}'), ('930', '0', '0g8lo25bhka1s6e1iq0ugktv86', NULL, NULL, 'cart', '2017-09-14 13:06:25', '2017-09-14 13:13:56', '168.187.173.14', '', 'chrome', '{\"is_mobile\":false}'), ('931', '0', 'da3f4p782c5oisdl4k7kkf6q43', NULL, NULL, 'cart', '2017-09-14 13:09:16', '2017-09-14 13:10:22', '118.189.195.79', '', 'opera', '{\"is_mobile\":false}'), ('932', '0', '7598qmn5t2c1qsbre6u364iq40', NULL, NULL, 'cart', '2017-09-14 13:11:12', '0000-00-00 00:00:00', '54.204.20.250', '', 'mozilla', '{\"is_mobile\":false}'), ('933', '0', 'o7iiimak2f9nrlcthhq4v6j6d3', NULL, NULL, 'cart', '2017-09-14 13:17:57', '2017-09-14 13:18:02', '103.57.95.223', '', 'chrome', '{\"is_mobile\":false}'), ('934', '0', '0cujklm052ijdl0oth1fi7fvm7', NULL, NULL, 'cart', '2017-09-14 13:22:56', '2017-09-14 13:23:19', '195.39.155.177', '', 'chrome', '{\"is_mobile\":false}'), ('935', '0', 'hss2eq96l6pm17hmrvb0l3muq5', NULL, NULL, 'cart', '2017-09-14 13:26:14', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('936', '0', '383mpdos718qqdpreleq2opsi0', NULL, NULL, 'cart', '2017-09-14 13:27:36', '2017-09-14 13:27:47', '2.236.65.192', '', 'mozilla', '{\"is_mobile\":false}'), ('937', '0', '6o6ujghmf0s423o5glcqmerlm2', NULL, NULL, 'cart', '2017-09-14 13:39:51', '2017-09-14 13:43:15', '177.134.130.80', '', 'chrome', '{\"is_mobile\":false}'), ('938', '0', 'vjq8alnrgpntt38njb6jbqq183', NULL, NULL, 'cart', '2017-09-14 13:41:42', '2017-09-14 13:44:55', '201.208.125.23', '', 'chrome', '{\"is_mobile\":false}'), ('939', '0', 'tutbg0pkk2a226t4fnkv8s9vp2', NULL, NULL, 'cart', '2017-09-14 13:43:04', '0000-00-00 00:00:00', '77.88.5.57', '', 'mozilla', '{\"is_mobile\":false}'), ('940', '0', 'fn55s7sj14mmkc65nevdg2dhd7', NULL, NULL, 'cart', '2017-09-14 13:51:36', '0000-00-00 00:00:00', '109.105.4.69', '', 'mozilla', '{\"is_mobile\":false}'), ('941', '0', '5hciqo3nl0rm0bj4su0p0oua12', NULL, NULL, 'cart', '2017-09-14 13:58:52', '0000-00-00 00:00:00', '201.34.169.52', '', 'chrome', '{\"is_mobile\":false}'), ('942', '0', '91pc30ecufrhmi7b5ua7s12ip0', NULL, NULL, 'cart', '2017-09-14 13:58:55', '0000-00-00 00:00:00', '201.34.169.52', '', 'chrome', '{\"is_mobile\":false}'), ('943', '0', 'rcor7sc1jgo8mc6oe1j7hbn013', NULL, NULL, 'cart', '2017-09-14 14:03:20', '0000-00-00 00:00:00', '107.182.231.195', '', 'mozilla', '{\"is_mobile\":false}'), ('944', '0', '0ti1g2p9qaci8lsq8regruf167', NULL, NULL, 'cart', '2017-09-14 14:27:05', '2017-09-14 14:27:07', '107.189.132.9', '', 'mozilla', '{\"is_mobile\":false}'), ('945', '0', 'isqsq0olmd3pf25po1p9hutah1', NULL, NULL, 'cart', '2017-09-14 14:27:06', '2017-09-14 14:32:11', '189.69.96.106', '', 'mozilla', '{\"is_mobile\":false}'), ('946', '0', 'gio6r7tf0nkn4vj8titleulbr2', NULL, NULL, 'cart', '2017-09-14 14:27:16', '0000-00-00 00:00:00', '117.185.27.115', '', 'chrome', '{\"is_mobile\":false}'), ('947', '0', 'm55jqaltg8ue0a1te3jh1c6od3', NULL, NULL, 'cart', '2017-09-14 14:27:19', '0000-00-00 00:00:00', '117.185.27.115', '', 'chrome', '{\"is_mobile\":false}'), ('948', '0', 'h93iefkhnbk70khfskgterhru2', NULL, NULL, 'cart', '2017-09-14 14:50:36', '2017-09-14 14:53:25', '90.87.113.84', '', 'chrome', '{\"is_mobile\":false}'), ('949', '0', 'l248cg18dnn428khhasmuoufp6', NULL, NULL, 'cart', '2017-09-14 14:52:07', '2017-09-14 14:52:11', '5.14.144.65', '', 'chrome', '{\"is_mobile\":false}'), ('950', '0', 'mv7lphk8iv2ullj1ntb783dct1', NULL, NULL, 'cart', '2017-09-14 14:56:15', '2017-09-14 14:56:19', '41.87.128.66', '', 'chrome', '{\"is_mobile\":false}'), ('951', '0', 'shms4bsvfiphlp1s8dsr0enjv6', NULL, NULL, 'cart', '2017-09-14 15:01:40', '2017-09-14 15:04:59', '79.40.177.216', '', 'chrome', '{\"is_mobile\":false}'), ('952', '0', 'oihgrfk5gojqljckl5as444ca5', NULL, NULL, 'cart', '2017-09-14 15:18:05', '2017-09-14 15:21:38', '197.27.121.72', '', 'chrome', '{\"is_mobile\":false}'), ('953', '0', 'hb7pmh026424d0trohrtd01u86', NULL, NULL, 'cart', '2017-09-14 15:21:52', '2017-09-14 16:41:40', '78.233.199.79', '', 'chrome', '{\"is_mobile\":false}'), ('954', '0', 'n9ki6kpkpu75082vqss5o3d4q0', NULL, NULL, 'cart', '2017-09-14 15:24:37', '2017-09-14 15:24:52', '36.83.50.89', '', 'mozilla', '{\"is_mobile\":false}'), ('955', '0', 'cd9es32q0l99718oem1adcus80', NULL, NULL, 'cart', '2017-09-14 15:43:36', '2017-09-14 17:29:03', '177.183.49.36', '', 'mozilla', '{\"is_mobile\":false}'), ('956', '0', 'cctqderers045d7mpk807k6q02', NULL, NULL, 'cart', '2017-09-14 15:50:27', '2017-09-14 15:50:28', '78.57.221.133', '', 'mozilla', '{\"is_mobile\":false}'), ('957', '0', '6tv6nh7libban5cih7c3sojap2', NULL, NULL, 'cart', '2017-09-14 15:55:42', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('958', '0', 'mk3biqk4f4b1cdcnega7g4mqi3', NULL, NULL, 'cart', '2017-09-14 15:59:42', '2017-09-14 16:01:23', '116.110.111.122', '', 'chrome', '{\"is_mobile\":false}'), ('959', '0', 'ph1048dimqiekm3h9kguub0vq6', NULL, NULL, 'cart', '2017-09-14 16:18:14', '2017-09-14 16:24:52', '196.184.115.75', '', 'mozilla', '{\"is_mobile\":false}'), ('960', '0', 'niehgdgpeanc3j70mfen6lh1r3', NULL, NULL, 'cart', '2017-09-14 16:21:38', '2017-09-14 16:23:53', '177.190.194.130', '', 'chrome', '{\"is_mobile\":false}'), ('961', '0', '6bm0uha7kqmsg9i8u6f2rmsmv1', NULL, NULL, 'cart', '2017-09-14 16:46:04', '2017-09-14 16:49:08', '88.231.242.196', '', 'chrome', '{\"is_mobile\":false}'), ('962', '0', 'iadil50f8qu5grdka495d8iag6', NULL, NULL, 'cart', '2017-09-14 16:47:24', '2017-09-14 17:01:22', '107.182.230.72', '', 'chrome', '{\"is_mobile\":false}'), ('963', '0', 'm12nou55pb9pen3onmg2a6r7i4', NULL, NULL, 'cart', '2017-09-14 16:47:48', '2017-09-14 16:49:28', '99.19.6.36', '', 'mozilla', '{\"is_mobile\":false}'), ('964', '0', '7t8fuua615l3c8lu9588tml9n7', NULL, NULL, 'cart', '2017-09-14 16:57:45', '2017-09-14 17:12:41', '190.232.74.141', '', 'chrome', '{\"is_mobile\":false}'), ('965', '0', 'c0hfmag6p67q457rnnflm4rf82', NULL, NULL, 'cart', '2017-09-14 17:10:11', '2017-09-14 17:12:36', '189.124.144.91', '', 'chrome', '{\"is_mobile\":false}'), ('966', '0', 'ahirbiojma7r29b7245j1dvla7', NULL, NULL, 'cart', '2017-09-14 17:12:18', '2017-09-14 17:12:20', '77.69.63.254', '', 'chrome', '{\"is_mobile\":false}'), ('967', '0', '550k0rdv64o081ongbonl5q085', NULL, NULL, 'cart', '2017-09-14 17:25:56', '2017-09-14 17:26:03', '77.223.71.157', '', 'mozilla', '{\"is_mobile\":false}'), ('968', '0', 's9ovct13ini88pcq7lqa0apqk5', NULL, NULL, 'cart', '2017-09-14 17:44:18', '2017-09-14 17:45:33', '178.93.31.174', '', 'mozilla', '{\"is_mobile\":false}'), ('969', '0', '7vl4jcvc423tjbevo1o33m5kh5', NULL, NULL, 'cart', '2017-09-14 17:56:27', '2017-09-14 17:58:51', '87.97.40.17', '', 'chrome', '{\"is_mobile\":false}'), ('970', '0', '6rhqceie6deqkku1hjsf4poop2', NULL, NULL, 'cart', '2017-09-14 18:10:53', '2017-09-14 18:11:01', '41.249.115.94', '', 'chrome', '{\"is_mobile\":false}'), ('971', '0', 'bv3h21ec9l2sagvaouplk9qq95', NULL, NULL, 'cart', '2017-09-14 18:13:32', '2017-09-14 18:14:36', '194.135.153.54', '', 'chrome', '{\"is_mobile\":false}'), ('972', '0', '3g6t8cftb6tk1qd3eibdkanf35', NULL, NULL, 'cart', '2017-09-14 18:16:50', '0000-00-00 00:00:00', '151.249.128.249', '', 'chrome', '{\"is_mobile\":false}'), ('973', '0', '769ggjj31c3bhaovv935dlnm33', NULL, NULL, 'cart', '2017-09-14 18:19:29', '2017-09-15 10:18:24', '78.187.118.201', '', 'mozilla', '{\"is_mobile\":false}'), ('974', '0', '4a7pu7fjorfcaf0ff347ur3j95', NULL, NULL, 'cart', '2017-09-14 18:30:13', '2017-09-14 18:31:20', '83.26.158.204', '', 'opera', '{\"is_mobile\":false}'), ('975', '0', 'krn1k2t37ihnti94hb79lorpa3', NULL, NULL, 'cart', '2017-09-14 18:35:44', '2017-09-14 18:36:00', '181.66.17.98', '', 'chrome', '{\"is_mobile\":false}'), ('976', '0', 'nbjoocrbuu535bfontbda3rto5', NULL, NULL, 'cart', '2017-09-14 18:36:12', '2017-09-14 18:54:24', '179.52.6.125', '', 'chrome', '{\"is_mobile\":false}'), ('977', '0', 'jmfnvu6h574jrhs4vastsp19h7', NULL, NULL, 'cart', '2017-09-14 19:07:21', '2017-09-14 19:07:32', '14.187.94.8', '', 'mozilla', '{\"is_mobile\":false}'), ('978', '0', '5o9s3a4r6vudu6m1o7fc4ir7v6', NULL, NULL, 'cart', '2017-09-14 19:16:37', '2017-09-14 19:17:01', '41.109.6.254', '', 'chrome', '{\"is_mobile\":false}'), ('979', '0', 'li42sla0ctuvcrs3t98i6gv817', NULL, NULL, 'cart', '2017-09-14 19:21:38', '0000-00-00 00:00:00', '177.35.187.98', '', 'chrome', '{\"is_mobile\":false}'), ('980', '0', 'c776jjtl65fggh55kf7obj52b7', NULL, NULL, 'cart', '2017-09-14 19:26:26', '0000-00-00 00:00:00', '201.159.30.110', '', 'safari', '{\"is_mobile\":false}'), ('981', '0', 'e1jafcip3jpsgbqvs94ka11uv6', NULL, NULL, 'cart', '2017-09-14 19:29:57', '2017-09-14 19:31:40', '66.249.93.200', '', 'chrome', '{\"is_mobile\":true}'), ('982', '0', 'vk6l4hgd1ad2221q8c1iom34q3', NULL, NULL, 'cart', '2017-09-14 19:33:35', '0000-00-00 00:00:00', '141.8.144.31', '', 'mozilla', '{\"is_mobile\":false}'), ('983', '0', '3biol96csoieaa0isnqd8e1to4', NULL, NULL, 'cart', '2017-09-14 19:36:45', '0000-00-00 00:00:00', '201.159.30.110', '', 'safari', '{\"is_mobile\":false}'), ('984', '0', '3avr9f1pa23t7m9c1gm4ih8bi3', NULL, NULL, 'cart', '2017-09-14 19:47:19', '0000-00-00 00:00:00', '190.234.245.15', '', 'chrome', '{\"is_mobile\":false}'), ('985', '0', 'gkocvf0grgqilm86rmm9cda0k2', NULL, NULL, 'cart', '2017-09-14 19:54:13', '0000-00-00 00:00:00', '138.94.165.213', '', 'chrome', '{\"is_mobile\":false}'), ('986', '0', 't4etg7n48l2mq29umf3poqcd83', NULL, NULL, 'cart', '2017-09-14 19:55:33', '2017-09-14 19:55:51', '181.57.247.243', '', 'mozilla', '{\"is_mobile\":false}'), ('987', '0', 'amvi54h13bs1e3gmeoib2bubj1', NULL, NULL, 'cart', '2017-09-14 19:56:13', '2017-09-14 23:18:17', '152.168.147.93', '', 'chrome', '{\"is_mobile\":false}'), ('988', '0', 'c0e3jpd7ct2hdhpss09cs0mj86', NULL, NULL, 'cart', '2017-09-14 20:00:46', '2017-09-14 20:01:41', '46.237.0.79', '', 'mozilla', '{\"is_mobile\":false}'), ('989', '0', 'vsq534iedtncqv5b25p9t2ull1', NULL, NULL, 'cart', '2017-09-14 20:00:49', '0000-00-00 00:00:00', '181.57.247.243', '', 'mozilla', '{\"is_mobile\":false}'), ('990', '0', 'kl91lg93unl0ga6o80if7u2lg7', NULL, NULL, 'cart', '2017-09-14 20:02:55', '2017-09-14 20:03:25', '154.122.159.29', '', 'chrome', '{\"is_mobile\":false}'), ('991', '0', 'qsaevt78uikhm99i9q9nnpgac5', NULL, NULL, 'cart', '2017-09-14 20:16:49', '0000-00-00 00:00:00', '178.151.216.128', '', 'chrome', '{\"is_mobile\":false}'), ('992', '0', '61l514jn2mfofl8m8oksh1lph5', NULL, NULL, 'cart', '2017-09-14 20:16:51', '0000-00-00 00:00:00', '178.151.216.128', '', 'chrome', '{\"is_mobile\":false}'), ('993', '0', 'q87457igor15chdgicprv51n41', NULL, NULL, 'cart', '2017-09-14 20:51:44', '0000-00-00 00:00:00', '92.245.5.64', '', 'mozilla', '{\"is_mobile\":false}'), ('994', '0', 'glq095jch5kh6k93f5h7en0qr2', NULL, NULL, 'cart', '2017-09-14 21:00:10', '2017-09-14 21:01:48', '95.15.89.142', '', 'chrome', '{\"is_mobile\":false}'), ('995', '0', 'g5foav566rm8jnj6anil3q54v5', NULL, NULL, 'cart', '2017-09-14 21:07:08', '0000-00-00 00:00:00', '94.103.239.68', '', 'safari', '{\"is_mobile\":false}'), ('996', '0', '59rgb6gdf1fthvvmrk3466sg42', NULL, NULL, 'cart', '2017-09-14 21:11:26', '2017-09-14 21:25:21', '94.180.134.9', '', 'mozilla', '{\"is_mobile\":false}'), ('997', '0', 'adljoeq5rsf7opamfo3s4eh617', NULL, NULL, 'cart', '2017-09-14 21:25:19', '2017-09-14 21:28:14', '197.157.0.36', '', 'chrome', '{\"is_mobile\":false}'), ('998', '0', '397roddjlg360hdeq6aol3cuo2', NULL, NULL, 'cart', '2017-09-14 21:26:09', '0000-00-00 00:00:00', '184.154.139.46', '', 'msie', '{\"is_mobile\":false}'), ('999', '0', 'gbr38kkncglkrc4qmq726jjnf2', NULL, NULL, 'cart', '2017-09-14 21:28:24', '2017-09-14 21:32:18', '189.162.240.51', '', 'chrome', '{\"is_mobile\":false}'), ('1000', '0', '1v33jru5lmjm3iadoajlno7lm4', NULL, NULL, 'cart', '2017-09-14 21:50:44', '0000-00-00 00:00:00', '129.56.11.49', '', 'mozilla', '{\"is_mobile\":false}');
