<?php
/**
 * @package J2Store
 * @copyright Copyright (c)2014-17 Ramesh Elamathi / J2Store.org
 * @license GNU GPL v3 or later
 */
/** ensure this file is being included by a parent file */
defined('_JEXEC') or die('Restricted access');
require_once(JPATH_ADMINISTRATOR.'/components/com_j2store/library/plugins/app.php');
class plgJ2StoreApp_qtydiscount extends J2StoreAppPlugin
{
	/**
	 * @var $_element  string  Should always correspond with the plugin's filename,
	 *                         forcing it to be unique
	 */
    var $_element   = 'app_qtydiscount';

    /**
     * Overriding
     *
     * @param $options
     * @return unknown_type
     */
    function onJ2StoreGetAppView( $row )
    {

	   	if (!$this->_isMe($row))
    	{
    		return null;
    	}

    	$html = $this->viewList();


    	return $html;
    }

/**
     * Validates the data submitted based on the suffix provided
     * A controller for this plugin, you could say
     *
     * @param $task
     * @return html
     */
    function viewList()
    {
    	$app = JFactory::getApplication();
    	$option = 'com_j2store';
    	$ns = $option.'.app.'.$this->_element;
    	$html = "";
    	JToolBarHelper::title(JText::_('J2STORE_APP').'-'.JText::_('PLG_J2STORE_'.strtoupper($this->_element)),'j2store-logo');
    	JToolBarHelper::apply('apply');
    	JToolBarHelper::save();
    	JToolBarHelper::back('PLG_J2STORE_BACK_TO_APPS', 'index.php?option=com_j2store&view=apps');
    	JToolBarHelper::back('J2STORE_BACK_TO_DASHBOARD', 'index.php?option=com_j2store');

    	$vars = new JObject();
    	//model should always be a plural
    	$this->includeCustomModel('AppQtydiscounts');

    	$model = F0FModel::getTmpInstance('AppQtydiscounts', 'J2StoreModel');

    	$data = $this->params->toArray();
    	$newdata = array();
    	$newdata['params'] = $data;
    	$form = $model->getForm($newdata);
    	$vars->form = $form;

    	$this->includeCustomTables();

    	$id = $app->input->getInt('id', '0');
    	$vars->id = $id;
    	$vars->action = "index.php?option=com_j2store&view=app&task=view&id={$id}";
    	$html = $this->_getLayout('default', $vars);
    	return $html;
    }


	/**
	 * Method to display the list of prices based on the quantity
	 * @param object $product
	 */
    public function onJ2StoreBeforeRenderingProductPrice($product){
    	$app = JFactory::getApplication();
    	if($app->isAdmin()) return '';
    	$vars = new JObject();
    	$productpriceModel = F0FModel::getTmpInstance('Productprices','J2StoreModel');
    	//here we can set the variant id
    	$productpriceModel->setState('variant_id',$product->variant->j2store_variant_id);
    	$group_id = implode(',',JAccess::getGroupsByUser(JFactory::getUser()->id));


    	$productpriceModel->setState('group_id',$group_id);

    	$pricinglist = $productpriceModel->getList();
	   	//assign the values into vars
    	$vars->pricing_list =$pricinglist;
    	$vars->params = $this->params;
    	$vars->product = $product;
    	$vars->configparams =J2Store::config();
		$vars->date_format = $this->params->get('date_format' ,J2Store::config()->get('date_format', JText::_('DATE_FORMAT_LC1') ));

		$layout = 'default';
    	if($product->product_type == 'variable'){
    		$layout ='variable';
    	}
    	$html ='';
    	//here we have to check the view is product
    	if($this->params->get('display_qtydiscount_in') =='1' && $app->input->get('task') =='view'){
    		$html = $this->_getLayout('form_'.$layout, $vars);
    	}elseif($app->input->get('task') !='view' && $this->params->get('display_qtydiscount_in') =='2'){
    		$html = $this->_getLayout('form_'.$layout, $vars);
    	}elseif($this->params->get('display_qtydiscount_in') =='3'){
    		$html = $this->_getLayout('form_'.$layout, $vars);
    	}

    	return $html;
    }
}

